/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.blackboard.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.BinaryStorageService;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.impl.TransientBlackboardImpl;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.tools.DatamodelSerializationUtils;
import org.eclipse.smila.datamodel.tools.record.filter.RecordFilterHelper;
import org.eclipse.smila.recordstorage.RecordStorage;
import org.eclipse.smila.recordstorage.RecordStorageException;

public class PersistingBlackboardImpl
extends TransientBlackboardImpl {
    private final Log _log = LogFactory.getLog(this.getClass());
    private RecordStorage _recordStorage;
    private BinaryStorageService _binaryStorage;

    public PersistingBlackboardImpl(RecordFilterHelper filterHelper, File attachmentsTempDir) {
        super(filterHelper, attachmentsTempDir);
    }

    public void setRecordStorage(RecordStorage recordStorage) {
        this._recordStorage = recordStorage;
    }

    public void setBinaryStorage(BinaryStorageService binaryStorage) {
        this._binaryStorage = binaryStorage;
    }

    @Override
    public void load(Id id) throws BlackboardAccessException {
        Record record = null;
        if (id == null) {
            throw new IllegalArgumentException("Record Id cannot be null");
        }
        if (!this.containsRecord(id)) {
            if (this._recordStorage == null) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)"RecordStorage is not bound - creating empty record");
                }
                this.create(id);
                return;
            }
            try {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Loading record by id: " + DatamodelSerializationUtils.serialize2string((Id)id)));
                }
                if ((record = this._recordStorage.loadRecord(id)) != null) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Record loaded " + DatamodelSerializationUtils.serialize2string((Record)record)));
                    }
                    super.setRecord(record);
                } else if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("No record found with id: " + id));
                }
            }
            catch (RecordStorageException exception) {
                throw new BlackboardAccessException("Error loading record with idHash = " + id.getIdHash(), exception);
            }
        }
    }

    @Override
    public void setRecord(Record record) throws BlackboardAccessException {
        Id id = record.getId();
        super.setRecord(record);
        Iterator attachmentNames = record.getAttachmentNames();
        while (attachmentNames.hasNext()) {
            String attachmentName = (String)attachmentNames.next();
            byte[] attachment = record.getAttachment(attachmentName);
            if (attachment == null) continue;
            this.setAttachment(id, attachmentName, attachment);
        }
    }

    @Override
    public void commit(Id id) throws BlackboardAccessException {
        Record record;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Committing record, IdHash=" + id.getIdHash()));
        }
        if ((record = this.getCachedRecord(id)) == null) {
            throw new BlackboardAccessException("Record with idHash = " + id.getIdHash() + " is not loaded in the blackboard.");
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Record to commit: " + DatamodelSerializationUtils.serialize2string((Record)record)));
        }
        try {
            if (this._recordStorage == null) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)"RecordStorage is not bound - record won't be committed to RecordStorage");
                }
            } else {
                this._recordStorage.storeRecord(record);
            }
        }
        catch (RecordStorageException ex) {
            try {
                this.invalidate(id);
            }
            catch (Exception e) {
                this._log.error((Object)("Error invalidating record with id = " + id.getIdHash()), (Throwable)e);
            }
            throw new BlackboardAccessException(ex);
        }
        super.commit(id);
    }

    @Override
    public void invalidate(Id id) {
        try {
            try {
                if (this._recordStorage == null) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn((Object)"RecordStorage is not bound - invalidate won't remove attachments of the non-committed record.");
                    }
                } else if (!this._recordStorage.existsRecord(id)) {
                    this.removeCachedRecordAttachments(id);
                }
            }
            catch (RecordStorageException recordStorageException) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)"RecordStorage could not check existence of record - invalidate won't remove attachments of the non-committed record.");
                }
                super.invalidate(id);
            }
        }
        finally {
            super.invalidate(id);
        }
    }

    @Override
    public byte[] getAttachment(Id id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        if (!record.hasAttachment(name)) {
            throw new BlackboardAccessException("Record with idHash = " + id.getIdHash() + " doesn't have the attachment [" + name + "]");
        }
        byte[] attachment = null;
        try {
            attachment = this._binaryStorage.fetchAsByte(this.getAttachmentId(id, name));
        }
        catch (BinaryStorageException bsex) {
            throw new BlackboardAccessException("Could not get the attachment-file from binary storage for record having id :" + id.getIdHash(), bsex);
        }
        return attachment;
    }

    @Override
    public InputStream getAttachmentAsStream(Id id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        if (!record.hasAttachment(name)) {
            throw new BlackboardAccessException("Record with idHash = " + id.getIdHash() + " doesn't have the attachment [" + name + "]");
        }
        InputStream attachmentInputStream = null;
        try {
            attachmentInputStream = this._binaryStorage.fetchAsStream(this.getAttachmentId(id, name));
        }
        catch (BinaryStorageException bsex) {
            throw new BlackboardAccessException("Could not get the attachment-file from binary storage for record having id :" + id.getIdHash(), bsex);
        }
        return attachmentInputStream;
    }

    @Override
    public void setAttachment(Id id, String name, byte[] attachment) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        this.storeAttachment(id, name, attachment);
        this.checkCachedFileAttachment(id, name);
        record.setAttachment(name, null);
    }

    @Override
    public void setAttachmentFromStream(Id id, String name, InputStream attachmentStream) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        this.storeAttachment(id, name, attachmentStream);
        this.checkCachedFileAttachment(id, name);
        record.setAttachment(name, null);
    }

    @Override
    public void setAttachmentFromFile(Id id, String name, File attachmentFile) throws BlackboardAccessException {
        FileInputStream attachmentStream = null;
        try {
            try {
                Record record = this.getRecord(id);
                attachmentStream = FileUtils.openInputStream((File)attachmentFile);
                this.storeAttachment(id, name, attachmentFile);
                this.checkCachedFileAttachment(id, name);
                record.setAttachment(name, null);
            }
            catch (IOException exception) {
                throw new BlackboardAccessException(exception);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(attachmentStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)attachmentStream);
    }

    @Override
    public void removeAttachment(Id id, String name) throws BlackboardAccessException {
        try {
            try {
                String attachmentId = this.getAttachmentId(id, name);
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Removing attachment " + attachmentId + " from binary storage"));
                }
                this._binaryStorage.remove(attachmentId);
            }
            catch (BinaryStorageException bsex) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)("Failed to remove attachment " + name + " from binary storage for record having id :" + id.getIdHash() + " - " + bsex.getMessage()));
                }
                throw new BlackboardAccessException(bsex);
            }
        }
        finally {
            super.removeAttachment(id, name);
        }
    }

    private void storeAttachment(Id id, String name, InputStream attachment) throws BlackboardAccessException {
        String attachmentId = this.getAttachmentId(id, name);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Saving attachment " + attachmentId + " to binary storage"));
        }
        try {
            this._binaryStorage.store(attachmentId, attachment);
        }
        catch (BinaryStorageException bsex) {
            throw new BlackboardAccessException("Failed to save attachment in binary storage for record having id :" + id.getIdHash(), bsex);
        }
    }

    private void storeAttachment(Id id, String name, byte[] attachment) throws BlackboardAccessException {
        String attachmentId = this.getAttachmentId(id, name);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Saving attachment " + attachmentId + " to binary storage"));
        }
        try {
            this._binaryStorage.store(attachmentId, attachment);
        }
        catch (BinaryStorageException bsex) {
            throw new BlackboardAccessException("Failed to save attachment in binary storage for record having id :" + id.getIdHash(), bsex);
        }
    }

    private void storeAttachment(Id id, String name, File attachment) throws BlackboardAccessException {
        String attachmentId = this.getAttachmentId(id, name);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Saving attachment " + attachmentId + " to binary storage"));
        }
        FileInputStream attachmentStream = null;
        try {
            try {
                attachmentStream = FileUtils.openInputStream((File)attachment);
                this._binaryStorage.store(attachmentId, (InputStream)attachmentStream);
            }
            catch (Exception exception) {
                throw new BlackboardAccessException("Failed to save attachment in binary storage for record having id :" + id.getIdHash(), exception);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)attachmentStream);
        }
    }

    private void removeCachedRecordAttachments(Id id) {
        Record record = this.getCachedRecord(id);
        if (record != null) {
            if (record.hasAttachments()) {
                Iterator attachmentNames = record.getAttachmentNames();
                while (attachmentNames.hasNext()) {
                    String attachmentName = (String)attachmentNames.next();
                    try {
                        this._binaryStorage.remove(this.getAttachmentId(id, attachmentName));
                    }
                    catch (BinaryStorageException storageException) {
                        if (!this._log.isErrorEnabled()) continue;
                        this._log.error((Object)("Could not invalidate/delete the attachment-file from binary storage for record having id :" + id.getIdHash() + " - " + storageException.getMessage()));
                    }
                }
            }
        } else if (this._log.isWarnEnabled()) {
            this._log.warn((Object)("Record with idHash = " + id.getIdHash() + " is not loaded in the blackboard."));
        }
    }
}

