/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.blackboard.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.blackboard.path.PathStep;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.datamodel.tools.DatamodelCopyUtils;
import org.eclipse.smila.datamodel.tools.DatamodelSerializationUtils;
import org.eclipse.smila.datamodel.tools.record.filter.RecordFilterHelper;
import org.eclipse.smila.datamodel.tools.record.filter.RecordFilterNotFoundException;
import org.eclipse.smila.utils.digest.DigestHelper;

public class TransientBlackboardImpl
implements Blackboard {
    private static final Iterator<String> EMPTY_STRING_ITERATOR = Collections.EMPTY_SET.iterator();
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Map<Id, Record> _recordMap = new HashMap<Id, Record>();
    private final Map<Id, Map<String, File>> _attachmentMap = new HashMap<Id, Map<String, File>>();
    private final Map<String, Serializable> _globalNotes = new HashMap<String, Serializable>();
    private final Map<Id, Map<String, Serializable>> _recordNotesMap = new HashMap<Id, Map<String, Serializable>>();
    private final RecordFilterHelper _filterHelper;
    private final File _attachmentsTempDir;

    public TransientBlackboardImpl(RecordFilterHelper filterHelper, File attachmentsTempDir) {
        this._filterHelper = filterHelper;
        this._attachmentsTempDir = attachmentsTempDir;
    }

    @Override
    public void commit() throws BlackboardAccessException {
        int numberOfRecords = this._recordMap.size();
        int commitFailures = 0;
        for (Id id : this.getIds()) {
            try {
                this.commit(id);
            }
            catch (Exception ex) {
                ++commitFailures;
                this._log.error((Object)("failed to commit " + id), (Throwable)ex);
            }
        }
        this.invalidate();
        if (commitFailures > 0) {
            throw new BlackboardAccessException("Failed to commit " + commitFailures + " of " + numberOfRecords + " records on blackboard, see log for IDs.");
        }
    }

    @Override
    public void invalidate() {
        for (Id id : this.getIds()) {
            try {
                this.invalidate(id);
            }
            catch (Exception ex) {
                this._log.error((Object)("failed to invalidate " + id), (Throwable)ex);
            }
        }
        for (Map map : this._attachmentMap.values()) {
            for (File attachmentFile : map.values()) {
                FileUtils.deleteQuietly((File)attachmentFile);
            }
        }
        this._recordMap.clear();
        this._globalNotes.clear();
        this._recordNotesMap.clear();
        this._attachmentMap.clear();
    }

    @Override
    public void create(Id id) {
        Record record = null;
        if (id == null) {
            throw new IllegalArgumentException("Record Id cannot be null");
        }
        if (!this._recordMap.containsKey(id)) {
            record = RecordFactory.DEFAULT_INSTANCE.createRecord();
            record.setId(id);
            this._recordMap.put(id, record);
        }
    }

    @Override
    public void load(Id id) throws BlackboardAccessException {
        this.create(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecord(Record record) throws BlackboardAccessException {
        Id id = record.getId();
        Map<Id, Record> map = this._recordMap;
        synchronized (map) {
            this._recordMap.put(id, record);
        }
    }

    @Override
    public Id split(Id id, String fragmentName) throws BlackboardAccessException {
        Id splittedId = id.createFragmentId(fragmentName);
        Record record = this._recordMap.get(id);
        Record splitRecord = RecordFactory.DEFAULT_INSTANCE.createRecord();
        splitRecord.setId(splittedId);
        splitRecord.setMetadata(DatamodelCopyUtils.cloneMObject((MObject)record.getMetadata(), (RecordFactory)RecordFactory.DEFAULT_INSTANCE));
        this._recordMap.put(splittedId, splitRecord);
        if (this._recordNotesMap.containsKey(id)) {
            this._recordNotesMap.put(splittedId, this._recordNotesMap.get(id));
        }
        return splittedId;
    }

    @Override
    public void commit(Id id) throws BlackboardAccessException {
        this.invalidate(id);
    }

    @Override
    public void invalidate(Id id) {
        Map<String, File> recordFileAttachments = this._attachmentMap.get(id);
        if (recordFileAttachments != null) {
            Set<String> attachmentNames = recordFileAttachments.keySet();
            for (String attachmentName : attachmentNames) {
                File attachment = recordFileAttachments.get(attachmentName);
                FileUtils.deleteQuietly((File)attachment);
            }
        }
        this._recordNotesMap.remove(id);
        this._attachmentMap.remove(id);
        this._recordMap.remove(id);
    }

    @Override
    public Literal createLiteral(Id id) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        Literal literal = record.getFactory().createLiteral();
        return literal;
    }

    @Override
    public Annotation createAnnotation(Id id) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        Annotation annotation = record.getFactory().createAnnotation();
        return annotation;
    }

    @Override
    public Iterator<String> getAttributeNames(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        if (attribute != null) {
            int index = this.getLastIndex(path);
            List mObjects = attribute.getObjects();
            if (mObjects.size() > index) {
                return ((MObject)mObjects.get(index)).getAttributeNames();
            }
        }
        return EMPTY_STRING_ITERATOR;
    }

    @Override
    public Iterator<String> getAttributeNames(Id id) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        return record.getMetadata().getAttributeNames();
    }

    @Override
    public boolean hasAttribute(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        return attribute != null;
    }

    @Override
    public boolean hasLiterals(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        return attribute != null && attribute.hasLiterals();
    }

    @Override
    public int getLiteralsSize(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        if (attribute != null) {
            return attribute.literalSize();
        }
        return 0;
    }

    @Override
    public List<Literal> getLiterals(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        if (attribute != null) {
            return attribute.getLiterals();
        }
        return Collections.emptyList();
    }

    @Override
    public Literal getLiteral(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        int index = this.getLastIndex(path);
        if (attribute != null && index < attribute.literalSize()) {
            return (Literal)attribute.getLiterals().get(index);
        }
        return null;
    }

    @Override
    public void setLiterals(Id id, Path path, List<Literal> literals) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path, true);
        attribute.setLiterals(literals);
    }

    @Override
    public void setLiteral(Id id, Path path, Literal literal) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path, true);
        attribute.setLiteral(literal);
    }

    @Override
    public void addLiteral(Id id, Path path, Literal literal) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path, true);
        attribute.addLiteral(literal);
    }

    @Override
    public void removeLiteral(Id id, Path path) throws BlackboardAccessException {
        List literals;
        Attribute attribute = this.getAttributeByPath(id, path, true);
        int index = this.getLastIndex(path);
        if (index < (literals = attribute.getLiterals()).size()) {
            literals.remove(index);
            attribute.setLiterals((Collection)literals);
        }
    }

    @Override
    public void removeLiterals(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path, true);
        attribute.removeLiterals();
    }

    @Override
    public boolean hasObjects(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        if (attribute != null) {
            return attribute.hasObjects();
        }
        return false;
    }

    @Override
    public int getObjectSize(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        if (attribute != null) {
            return attribute.getObjects().size();
        }
        return 0;
    }

    @Override
    public void removeObject(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        if (attribute != null) {
            int index = this.getLastIndex(path);
            List objects = attribute.getObjects();
            if (objects.size() > index) {
                objects.remove(index);
                attribute.setObjects((Collection)objects);
            }
        }
    }

    @Override
    public void removeObjects(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        if (attribute != null) {
            attribute.removeObjects();
        }
    }

    @Override
    public String getObjectSemanticType(Id id, Path path) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        int index = this.getLastIndex(path);
        if (attribute != null && attribute.getObjects().size() > index) {
            return ((MObject)attribute.getObjects().get(index)).getSemanticType();
        }
        return null;
    }

    @Override
    public void setObjectSemanticType(Id id, Path path, String typeName) throws BlackboardAccessException {
        Attribute attribute = this.getAttributeByPath(id, path);
        int index = this.getLastIndex(path);
        ((MObject)attribute.getObjects().get(index)).setSemanticType(typeName);
    }

    @Override
    public Iterator<String> getAnnotationNames(Id id, Path path) throws BlackboardAccessException {
        Annotatable annotatable = this.getAnnotatableObject(id, path);
        if (annotatable != null) {
            return annotatable.getAnnotationNames();
        }
        return EMPTY_STRING_ITERATOR;
    }

    @Override
    public boolean hasAnnotation(Id id, Path path, String name) throws BlackboardAccessException {
        Annotatable annotatable = this.getAnnotatableObject(id, path);
        return annotatable != null && annotatable.hasAnnotation(name);
    }

    @Override
    public boolean hasAnnotations(Id id, Path path) throws BlackboardAccessException {
        Annotatable annotatable = this.getAnnotatableObject(id, path);
        return annotatable != null && annotatable.hasAnnotations();
    }

    @Override
    public List<Annotation> getAnnotations(Id id, Path path, String name) throws BlackboardAccessException {
        Annotatable annotatable = this.getAnnotatableObject(id, path);
        if (annotatable != null) {
            return (List)annotatable.getAnnotations(name);
        }
        return Collections.emptyList();
    }

    @Override
    public Annotation getAnnotation(Id id, Path path, String name) throws BlackboardAccessException {
        Annotatable annotatable = this.getAnnotatableObject(id, path);
        if (annotatable != null) {
            return annotatable.getAnnotation(name);
        }
        return null;
    }

    @Override
    public void setAnnotations(Id id, Path path, String name, List<Annotation> annotations) throws BlackboardAccessException {
        this.getAnnotableObject(id, path, true).setAnnotations(name, annotations);
    }

    @Override
    public void setAnnotation(Id id, Path path, String name, Annotation annotation) throws BlackboardAccessException {
        this.getAnnotableObject(id, path, true).setAnnotation(name, annotation);
    }

    @Override
    public void addAnnotation(Id id, Path path, String name, Annotation annotation) throws BlackboardAccessException {
        this.getAnnotableObject(id, path, true).addAnnotation(name, annotation);
    }

    @Override
    public void removeAnnotation(Id id, Path path, String name) throws BlackboardAccessException {
        Annotatable annotatable = this.getAnnotatableObject(id, path);
        if (annotatable != null) {
            annotatable.removeAnnotations(name);
        }
    }

    @Override
    public void removeAnnotations(Id id, Path path) throws BlackboardAccessException {
        Annotatable annotatable = this.getAnnotatableObject(id, path);
        if (annotatable != null) {
            annotatable.removeAnnotations();
        }
    }

    @Override
    public boolean hasAttachment(Id id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        return record.hasAttachment(name);
    }

    @Override
    public byte[] getAttachment(Id id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        if (!record.hasAttachment(name)) {
            throw new BlackboardAccessException("Record with idHash = " + id.getIdHash() + " doesn't have the attachment [" + name + "]");
        }
        return record.getAttachment(name);
    }

    @Override
    public InputStream getAttachmentAsStream(Id id, String name) throws BlackboardAccessException {
        return new ByteArrayInputStream(this.getAttachment(id, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getAttachmentAsFile(Id id, String name) throws BlackboardAccessException {
        Map<Id, Map<String, File>> map = this._attachmentMap;
        synchronized (map) {
            File attachmentFile = null;
            if (this._attachmentMap.get(id) != null && (attachmentFile = this._attachmentMap.get(id).get(name)) != null) {
                return attachmentFile;
            }
            try {
                attachmentFile = new File(this._attachmentsTempDir, this.getAttachmentId(id, name));
                FileUtils.writeByteArrayToFile((File)attachmentFile, (byte[])this.getAttachment(id, name));
                Map<String, File> recordAtttachmentFiles = this._attachmentMap.get(id);
                if (recordAtttachmentFiles == null) {
                    recordAtttachmentFiles = new HashMap<String, File>();
                }
                recordAtttachmentFiles.put(name, attachmentFile);
                this._attachmentMap.put(id, recordAtttachmentFiles);
            }
            catch (IOException ex) {
                throw new BlackboardAccessException("Error getting attachment as file, record id: " + id.getIdHash(), ex);
            }
            return attachmentFile;
        }
    }

    @Override
    public void setAttachment(Id id, String name, byte[] attachment) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        this.checkCachedFileAttachment(id, name);
        record.setAttachment(name, attachment);
    }

    @Override
    public void setAttachmentFromStream(Id id, String name, InputStream attachmentStream) throws BlackboardAccessException {
        try {
            Record record = this.getRecord(id);
            this.checkCachedFileAttachment(id, name);
            record.setAttachment(name, IOUtils.toByteArray((InputStream)attachmentStream));
        }
        catch (IOException ex) {
            throw new BlackboardAccessException(ex);
        }
    }

    @Override
    public void setAttachmentFromFile(Id id, String name, File attachmentFile) throws BlackboardAccessException {
        try {
            Record record = this.getRecord(id);
            this.checkCachedFileAttachment(id, name);
            record.setAttachment(name, FileUtils.readFileToByteArray((File)attachmentFile));
        }
        catch (IOException ex) {
            throw new BlackboardAccessException(ex);
        }
    }

    @Override
    public void removeAttachment(Id id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        this.checkCachedFileAttachment(id, name);
        record.removeAttachment(name);
    }

    @Override
    public boolean hasGlobalNote(String name) throws BlackboardAccessException {
        return this._globalNotes.containsKey(name);
    }

    @Override
    public Serializable getGlobalNote(String name) throws BlackboardAccessException {
        return this._globalNotes.get(name);
    }

    @Override
    public void setGlobalNote(String name, Serializable object) throws BlackboardAccessException {
        this._globalNotes.put(name, object);
    }

    @Override
    public boolean hasRecordNote(Id id, String name) throws BlackboardAccessException {
        Map<String, Serializable> recordNotes = this._recordNotesMap.get(id);
        if (recordNotes == null) {
            return false;
        }
        return recordNotes.containsKey(name);
    }

    @Override
    public Serializable getRecordNote(Id id, String name) throws BlackboardAccessException {
        Map<String, Serializable> recordNotes = this._recordNotesMap.get(id);
        if (recordNotes != null) {
            return recordNotes.get(name);
        }
        throw new BlackboardAccessException("Record note not found");
    }

    @Override
    public void setRecordNote(Id id, String name, Serializable object) throws BlackboardAccessException {
        Map<String, Serializable> recordNotes = this._recordNotesMap.get(id);
        if (recordNotes == null) {
            recordNotes = new HashMap<String, Serializable>();
            recordNotes.put(name, object);
            this._recordNotesMap.put(id, recordNotes);
        } else {
            recordNotes.put(name, object);
            this._recordNotesMap.put(id, recordNotes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(Record record) throws BlackboardAccessException {
        if (record == null) {
            throw new IllegalArgumentException("record must not be null!");
        }
        if (record.getId() == null) {
            throw new IllegalArgumentException("record.id must not be null!");
        }
        if (record.getMetadata() == null) {
            throw new IllegalArgumentException("record.metadata must not be null!");
        }
        Record oldRecord = null;
        Record record2 = this._recordMap;
        synchronized (record2) {
            try {
                this.load(record.getId());
                oldRecord = this._recordMap.get(record.getId());
            }
            catch (Exception e) {
                this._log.warn((Object)("Error synchronizing record " + record.getId() + " with record storage, creating a new record"), (Throwable)e);
            }
        }
        if (oldRecord == null) {
            this.setRecord(record);
            return;
        }
        record2 = oldRecord;
        synchronized (record2) {
            MObject mobject = record.getMetadata();
            if (mobject.hasAttributes()) {
                DatamodelCopyUtils.copyAttributes((MObject)mobject, (MObject)oldRecord.getMetadata(), (RecordFactory)record.getFactory());
            }
            Iterator attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = (String)attachmentNames.next();
                oldRecord.setAttachment(attachmentName, record.getAttachment(attachmentName));
            }
        }
        this.setRecord(oldRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record getRecord(Id id) throws BlackboardAccessException {
        Map<Id, Record> map = this._recordMap;
        synchronized (map) {
            Record record = this._recordMap.get(id);
            if (record != null) {
                return record;
            }
            this.load(id);
            return this._recordMap.get(id);
        }
    }

    @Override
    public Record getRecord(Id id, String filterName) throws RecordFilterNotFoundException, BlackboardAccessException {
        Record record = this.getRecord(id);
        return this.filterRecord(record, filterName);
    }

    @Override
    public Record filterRecord(Record record, String filterName) throws RecordFilterNotFoundException {
        Record newRecord = this._filterHelper.filter(record, filterName);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("RECORD BEFORE FILTERING:" + DatamodelSerializationUtils.serialize2string((Record)record)));
            this._log.debug((Object)("RECORD AFTER  FILTERING:" + DatamodelSerializationUtils.serialize2string((Record)newRecord)));
        }
        return newRecord;
    }

    protected String getAttachmentId(Id id, String name) {
        return DigestHelper.calculateDigest((String)(String.valueOf(id.getIdHash()) + name));
    }

    protected void checkCachedFileAttachment(Id id, String name) throws BlackboardAccessException {
        Map<String, File> recordFileAttachments = this._attachmentMap.get(id);
        if (recordFileAttachments != null && recordFileAttachments.get(name) != null) {
            throw new BlackboardAccessException("Attachment [" + name + "] of record with idHash=" + id.getIdHash() + " was previously loaded by getAttachmentAsFile method");
        }
    }

    protected Attribute getAttributeByPath(Id id, Path path) throws BlackboardAccessException {
        return this.getAttributeByPath(id, path, false);
    }

    protected Attribute getAttributeByPath(Id id, Path path, boolean create) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        MObject metadata = record.getMetadata();
        PathStep lastStep = this.getLastStep(path);
        int i = 0;
        while (i < path.length() - 1) {
            PathStep pathStep = path.get(i);
            int index = pathStep.getIndex();
            String name = pathStep.getName();
            Attribute attribute = this.getAttributeByName(record, metadata, name, create);
            if (attribute != null) {
                if (attribute.objectSize() > index) {
                    metadata = (MObject)attribute.getObjects().get(index);
                } else if (create) {
                    while (attribute.objectSize() <= index) {
                        metadata = record.getFactory().createMetadataObject();
                        attribute.addObject(metadata);
                    }
                } else {
                    return null;
                }
            }
            ++i;
        }
        return this.getAttributeByName(record, metadata, lastStep.getName(), create);
    }

    protected Attribute getAttributeByName(Record record, MObject metadata, String name, boolean create) {
        Attribute attribute = null;
        if (metadata.hasAttribute(name)) {
            attribute = metadata.getAttribute(name);
        } else if (create) {
            attribute = record.getFactory().createAttribute();
            metadata.setAttribute(name, attribute);
        }
        return attribute;
    }

    protected int getLastIndex(Path path) {
        PathStep lastStep = this.getLastStep(path);
        return lastStep.getIndex();
    }

    protected PathStep getLastStep(Path path) {
        return path.get(path.length() - 1);
    }

    protected boolean isEmpty(Path path) {
        return path == null || path.isEmpty() || "".equals(path.toString());
    }

    protected Annotatable getAnnotatableObject(Id id, Path path) throws BlackboardAccessException {
        return this.getAnnotableObject(id, path, false);
    }

    protected Annotatable getAnnotableObject(Id id, Path path, boolean create) throws BlackboardAccessException {
        if (this.isEmpty(path)) {
            Record record = this.getRecord(id);
            return record.getMetadata();
        }
        Attribute attribute = this.getAttributeByPath(id, path, create);
        if (attribute != null) {
            int index = this.getLastIndex(path);
            if (index == -1) {
                return attribute;
            }
            List mObjects = attribute.getObjects();
            if (mObjects.size() > index) {
                return (Annotatable)mObjects.get(index);
            }
        }
        return null;
    }

    protected Record getCachedRecord(Id id) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Getting cached record with idHash=" + id.getIdHash()));
        }
        return this._recordMap.get(id);
    }

    protected boolean containsRecord(Id id) {
        return this._recordMap.containsKey(id);
    }

    protected Collection<Id> getIds() {
        return new ArrayList<Id>(this._recordMap.keySet());
    }
}

