/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.blackboard.path;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.blackboard.path.PathStep;

public class Path
implements Serializable,
Iterable<PathStep> {
    public static final char SEPARATOR = '/';
    private static final long serialVersionUID = 4628822718743464377L;
    private Stack<PathStep> _pathStack = new Stack();

    public Path() {
    }

    public Path(Path path) {
        for (PathStep pathStep : path) {
            this._pathStack.add(pathStep);
        }
    }

    public Path(String path) {
        String[] stringArray = StringUtils.split((String)path, (char)'/');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pathStepString = stringArray[n2];
            String[] pathStepParts = StringUtils.split((String)pathStepString, (char)'[');
            int index = 0;
            if (pathStepParts.length > 1 && pathStepParts[1].indexOf(93) > 0) {
                index = Integer.valueOf(pathStepParts[1].substring(0, pathStepParts[1].length() - 1));
            }
            this._pathStack.add(new PathStep(pathStepParts[0], index));
            ++n2;
        }
    }

    public Path add(PathStep step) {
        this._pathStack.add(step);
        return this;
    }

    public Path add(String attributeName) {
        PathStep pathStep = new PathStep(attributeName);
        return this.add(pathStep);
    }

    public Path add(String attributeName, int index) {
        PathStep pathStep = new PathStep(attributeName, index);
        return this.add(pathStep);
    }

    public Path up() {
        this._pathStack.pop();
        return this;
    }

    public Path incIndex() {
        this._pathStack.peek().incIndex();
        return this;
    }

    @Override
    public Iterator<PathStep> iterator() {
        return this._pathStack.iterator();
    }

    public boolean isEmpty() {
        return this._pathStack.isEmpty();
    }

    public PathStep get(int index) {
        return (PathStep)this._pathStack.get(index);
    }

    public String getName(int index) {
        return ((PathStep)this._pathStack.get(index)).getName();
    }

    public int getIndex(int index) {
        return ((PathStep)this._pathStack.get(index)).getIndex();
    }

    public int length() {
        return this._pathStack.size();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Path) {
            Path otherPath = (Path)other;
            Iterator<PathStep> pathIterator1 = this.iterator();
            Iterator<PathStep> pathIterator2 = otherPath.iterator();
            while (pathIterator1.hasNext() && pathIterator2.hasNext()) {
                PathStep pathStep1 = pathIterator1.next();
                PathStep pathStep2 = pathIterator2.next();
                if (!(pathStep1 == null ? pathStep2 != null : !pathStep1.equals(pathStep2))) continue;
                return false;
            }
            return !pathIterator1.hasNext() && !pathIterator2.hasNext();
        }
        return false;
    }

    public int hashCode() {
        return this._pathStack.hashCode();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (PathStep pathStep : this._pathStack) {
            str.append(pathStep.toString());
            str.append('/');
        }
        return str.toString();
    }
}

