/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.highlighting.transformer;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformer;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformerException;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.ParameterSet;
import org.eclipse.smila.search.utils.param.set.DParameterSet;

public class MaxTextLength
extends HighlightingTransformer {
    @Override
    public Annotation transform(Annotation highlight, DParameterSet highlightConfig) throws HighlightingTransformerException, ParameterException {
        ParameterSet parameterSet = this.createParameterSet(highlightConfig);
        String markupPrefix = parameterSet.getStringParameter("MarkupPrefix");
        String markupSuffix = parameterSet.getStringParameter("MarkupSuffix");
        int maxLength = parameterSet.getIntegerParameter("MaxLength");
        String originalText = highlight.getNamedValue("text");
        StringBuffer buffer = new StringBuffer();
        int pos = 0;
        Collection highlightPositions = highlight.getAnnotations("positions");
        for (Annotation highlightPos : highlightPositions) {
            int start = Integer.valueOf(highlightPos.getNamedValue("start"));
            int end = Integer.valueOf(highlightPos.getNamedValue("end"));
            if (start > maxLength) {
                buffer.append(originalText.substring(pos, maxLength));
                pos = maxLength;
                break;
            }
            buffer.append(originalText.substring(pos, start));
            if (end > maxLength) {
                pos = maxLength;
                break;
            }
            buffer.append(markupPrefix);
            buffer.append(originalText.substring(start, end));
            buffer.append(markupSuffix);
            pos = end;
        }
        if (pos < maxLength) {
            if (originalText.length() < maxLength) {
                buffer.append(originalText.substring(pos));
            } else {
                buffer.append(originalText.substring(pos, maxLength));
            }
        }
        highlight.setNamedValue("text", buffer.toString());
        highlight.removeAnnotations("positions");
        return highlight;
    }

    @Override
    public ArrayList<Object> transform(ArrayList<Object> data, ParameterSet parameterSet) throws HighlightingTransformerException {
        return data;
    }
}

