/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.servlet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.record.InvalidTypeException;
import org.eclipse.smila.processing.parameters.SearchAnnotations;
import org.eclipse.smila.processing.parameters.SearchParameters;
import org.eclipse.smila.search.api.helper.ParameterAnnotation;
import org.eclipse.smila.search.api.helper.QueryBuilder;
import org.eclipse.smila.utils.collections.MultiValueMap;

public class ARequestParser {
    public static final String PREFIX_ATTRIBUTE = "A.";
    public static final String PREFIX_ORDERBY = "orderBy.";
    public static final String PREFIX_FILTER = "F.";
    public static final String PREFIX_FILTER_VAL = "Fval.";
    public static final String PREFIX_FILTER_MIN = "Fmin.";
    public static final String PREFIX_FILTER_MAX = "Fmax.";
    public static final String PREFIX_RANKING = "R.";
    public static final String PARAM_PIPELINE = "pipeline";
    protected String _defaultPipeline;
    private Map<String, SearchAnnotations.FilterMode> _filterModes = new HashMap<String, SearchAnnotations.FilterMode>();
    private MultiValueMap<String, String> _filterValues = new MultiValueMap();
    private Map<String, String> _filterMin = new HashMap<String, String>();
    private Map<String, String> _filterMax = new HashMap<String, String>();

    public ARequestParser(String defaultPipeline) {
        this._defaultPipeline = defaultPipeline;
    }

    protected void setupFilters(QueryBuilder builder) {
        for (String attributeName : this._filterValues.keySet()) {
            this.setupEnumFilter(builder, attributeName);
        }
        HashSet<String> rangeFilterAttributes = new HashSet<String>();
        rangeFilterAttributes.addAll(this._filterMin.keySet());
        rangeFilterAttributes.addAll(this._filterMax.keySet());
        for (String attributeName : rangeFilterAttributes) {
            this.setupRangeFilter(builder, attributeName);
        }
    }

    protected void setupEnumFilter(QueryBuilder builder, String attributeName) {
        List values = (List)this._filterValues.get((Object)attributeName);
        if (values != null && values.size() > 0) {
            SearchAnnotations.FilterMode mode = this._filterModes.get(attributeName);
            if (mode == null) {
                mode = SearchAnnotations.FilterMode.ANY;
            }
            try {
                builder.addEnumFilter(attributeName, mode, (Iterable)values);
            }
            catch (Exception exception) {
            }
        }
    }

    protected void setupRangeFilter(QueryBuilder builder, String attributeName) {
        SearchAnnotations.FilterMode mode = this._filterModes.get(attributeName);
        if (mode == null) {
            mode = SearchAnnotations.FilterMode.ANY;
        }
        try {
            builder.addRangeFilter(attributeName, mode, (Object)this._filterMin.get(attributeName), (Object)this._filterMax.get(attributeName));
        }
        catch (Exception exception) {
        }
    }

    protected void setDefaultParameters(QueryBuilder builder) {
        ParameterAnnotation parameters = builder.getParameters();
        if (parameters.getParameter("resultSize") == null) {
            parameters.setIntParameter("resultSize", 10);
        }
        if (parameters.getParameter("resultOffset") == null) {
            parameters.setIntParameter("resultOffset", 0);
        }
    }

    protected void processParameter(QueryBuilder builder, String paramName, String[] paramValues) {
        if (paramName.startsWith(PREFIX_RANKING)) {
            this.processRankingAnnotation(builder, paramName, paramValues);
        } else if (paramName.startsWith(PREFIX_FILTER)) {
            this.processFilterMode(paramName, paramValues);
        } else if (paramName.startsWith(PREFIX_FILTER_VAL)) {
            this.processFilterValue(paramName, paramValues);
        } else if (paramName.startsWith(PREFIX_FILTER_MIN)) {
            this.processFilterMin(paramName, paramValues);
        } else if (paramName.startsWith(PREFIX_FILTER_MAX)) {
            this.processFilterMax(paramName, paramValues);
        } else if (paramName.startsWith(PREFIX_ATTRIBUTE)) {
            String[] pathElements = paramName.substring(PREFIX_ATTRIBUTE.length()).split("\\.");
            if (pathElements != null && pathElements.length > 0) {
                if (pathElements.length == 1) {
                    if (!StringUtils.isEmpty((String)pathElements[0])) {
                        this.setAttributeValues(builder, pathElements[0], paramValues);
                    }
                } else if (pathElements.length > 2) {
                    this.setAttributeAnnotations(builder, pathElements, paramValues);
                }
            }
        } else {
            this.setParameterValues(builder, paramName, paramValues);
        }
    }

    private void processFilterMax(String paramName, String[] paramValues) {
        String attributeName = paramName.substring(PREFIX_FILTER_MAX.length());
        if (!StringUtils.isEmpty((String)attributeName) && !StringUtils.isEmpty((String)paramValues[0])) {
            this._filterMax.put(attributeName, paramValues[0]);
        }
    }

    private void processFilterMin(String paramName, String[] paramValues) {
        String attributeName = paramName.substring(PREFIX_FILTER_MIN.length());
        if (!StringUtils.isEmpty((String)attributeName) && !StringUtils.isEmpty((String)paramValues[0])) {
            this._filterMin.put(attributeName, paramValues[0]);
        }
    }

    private void processFilterValue(String paramName, String[] paramValues) {
        String attributeName = paramName.substring(PREFIX_FILTER_VAL.length());
        if (!StringUtils.isEmpty((String)attributeName)) {
            String[] stringArray = paramValues;
            int n = paramValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!StringUtils.isEmpty((String)value)) {
                    this._filterValues.add((Object)attributeName, (Object)value);
                }
                ++n2;
            }
        }
    }

    private void processFilterMode(String paramName, String[] paramValues) {
        String attributeName = paramName.substring(PREFIX_FILTER.length());
        if (!StringUtils.isEmpty((String)attributeName) && !StringUtils.isEmpty((String)paramValues[0])) {
            try {
                SearchAnnotations.FilterMode mode = SearchAnnotations.FilterMode.valueOf((String)paramValues[0].toUpperCase());
                this._filterModes.put(attributeName, mode);
            }
            catch (Exception exception) {
            }
        }
    }

    private void processRankingAnnotation(QueryBuilder builder, String paramName, String[] paramValues) {
        String valueAndAttributeName = paramName.substring(PREFIX_RANKING.length());
        int dotIndex = valueAndAttributeName.indexOf(46);
        String valueName = null;
        String attributeName = null;
        if (dotIndex < 0) {
            valueName = valueAndAttributeName;
        } else {
            valueName = valueAndAttributeName.substring(0, dotIndex);
            attributeName = valueAndAttributeName.substring(dotIndex + 1);
        }
        if (!StringUtils.isEmpty((String)paramValues[0])) {
            builder.getRankingAnnotation(attributeName).setNamedValue(valueName, paramValues[0]);
        }
    }

    protected void setAttributeValues(QueryBuilder builder, String attributeName, String[] paramValues) {
        String[] stringArray = paramValues;
        int n = paramValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!StringUtils.isEmpty((String)value)) {
                try {
                    builder.addLiteral(attributeName, (Object)value);
                }
                catch (InvalidTypeException invalidTypeException) {
                }
            }
            ++n2;
        }
    }

    protected void setAttributeAnnotations(QueryBuilder builder, String[] pathElements, String[] paramValues) {
        String attributeName = pathElements[0];
        String[] stringArray = paramValues;
        int n = paramValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!StringUtils.isEmpty((String)value)) {
                try {
                    String annotationName = pathElements[pathElements.length - 1];
                    String[] annotationNames = new String[pathElements.length - 2];
                    System.arraycopy(pathElements, 1, annotationNames, 0, pathElements.length - 2);
                    builder.addAnnotationNamedValue(attributeName, annotationNames, annotationName, value);
                }
                catch (InvalidTypeException invalidTypeException) {
                }
            }
            ++n2;
        }
    }

    protected void setParameterValues(QueryBuilder builder, String paramName, String[] paramValues) {
        if (paramName.startsWith(PREFIX_ORDERBY)) {
            String attributeName = paramName.substring(PREFIX_ORDERBY.length());
            if (!StringUtils.isEmpty((String)attributeName) && !StringUtils.isEmpty((String)paramValues[0])) {
                try {
                    SearchParameters.OrderMode orderMode = SearchParameters.OrderMode.valueOf((String)paramValues[0].toUpperCase());
                    builder.addOrderBy(attributeName, orderMode);
                }
                catch (Exception exception) {
                }
            }
        } else if (paramValues.length == 1) {
            if (!StringUtils.isEmpty((String)paramValues[0])) {
                builder.setParameter(paramName, paramValues[0]);
            }
        } else {
            String[] stringArray = paramValues;
            int n = paramValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!StringUtils.isEmpty((String)value)) {
                    builder.addParameter(paramName, value);
                }
                ++n2;
            }
        }
    }
}

