/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.servlet;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.search.api.helper.QueryBuilder;
import org.eclipse.smila.search.servlet.ARequestParser;
import org.eclipse.smila.utils.collections.MultiValueMap;

public class MultiPartRequestParser
extends ARequestParser {
    public MultiPartRequestParser(String defaultPipeline) {
        super(defaultPipeline);
    }

    public QueryBuilder parse(List items) {
        MultiValueMap parameters = new MultiValueMap();
        HashMap<String, byte[]> attachments = new HashMap<String, byte[]>();
        Annotation attachmentFileNames = null;
        int i = 0;
        while (i < items.size()) {
            FileItem item = (FileItem)items.get(i);
            String fieldName = item.getFieldName();
            if (item.isFormField()) {
                parameters.add((Object)fieldName, (Object)item.getString());
            } else if (item.getSize() > 0L) {
                attachments.put(fieldName, item.get());
                if (attachmentFileNames == null) {
                    attachmentFileNames = RecordFactory.DEFAULT_INSTANCE.createAnnotation();
                }
                attachmentFileNames.setNamedValue(fieldName, item.getName());
            }
            ++i;
        }
        String pipeline = this._defaultPipeline;
        if (parameters.containsKey((Object)"pipeline")) {
            pipeline = (String)((List)parameters.get((Object)"pipeline")).get(0);
        }
        QueryBuilder builder = new QueryBuilder(pipeline);
        for (String paramName : parameters.keySet()) {
            List values = (List)parameters.get((Object)paramName);
            if (values == null || values.size() <= 0) continue;
            this.processParameter(builder, paramName, values.toArray(new String[values.size()]));
        }
        for (String attachmentName : attachments.keySet()) {
            byte[] content = (byte[])attachments.get(attachmentName);
            if (content == null || content.length <= 0) continue;
            builder.setAttachment(attachmentName, content);
        }
        if (attachmentFileNames != null) {
            builder.getQuery().getMetadata().setAnnotation("attachmentFileNames", attachmentFileNames);
        }
        this.setupFilters(builder);
        this.setDefaultParameters(builder);
        return builder;
    }
}

