/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.agent.feed;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.HashMapFeedInfoCache;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.AbstractAgent;
import org.eclipse.smila.connectivity.framework.AgentException;
import org.eclipse.smila.connectivity.framework.agent.feed.messages.Attribute;
import org.eclipse.smila.connectivity.framework.agent.feed.messages.Process;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.AgentThreadState;
import org.eclipse.smila.connectivity.framework.util.ConnectivityHashFactory;
import org.eclipse.smila.connectivity.framework.util.ConnectivityIdFactory;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.InvalidTypeException;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;

public class FeedAgent
extends AbstractAgent {
    private static final long MILLI_SECOND_MULTIPLIER = 1000L;
    private final RecordFactory _factory = RecordFactory.DEFAULT_INSTANCE;
    private final Log _log = LogFactory.getLog(FeedAgent.class);
    private long _updateInterval;
    private List<String> _feedUrls;
    private Attribute[] _attributes;

    public FeedAgent() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Creating FeedAgent instance");
        }
    }

    public void run() {
        try {
            try {
                Thread.currentThread().setContextClassLoader(SyndFeed.class.getClassLoader());
                FeedFetcherCache feedInfoCache = HashMapFeedInfoCache.getInstance();
                HttpURLFeedFetcher feedFetcher = new HttpURLFeedFetcher(feedInfoCache);
                while (!this.isStopThread()) {
                    try {
                        for (String feedUrl : this._feedUrls) {
                            this.fetch((FeedFetcher)feedFetcher, feedUrl);
                        }
                        Thread.sleep(this._updateInterval);
                    }
                    catch (InterruptedException e) {
                        if (!this._log.isDebugEnabled()) continue;
                        this._log.debug((Object)"FeedAgent thread was interrupted", (Throwable)e);
                    }
                }
            }
            catch (Throwable t) {
                this.getAgentState().setLastError(t);
                this.getAgentState().setState(AgentThreadState.Aborted);
                throw new RuntimeException(t);
            }
        }
        finally {
            try {
                this.stopThread();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void initialize() throws AgentException {
        this._updateInterval = ((Process)this.getConfig().getProcess()).getUpdateInterval().longValue() * 1000L;
        this._feedUrls = ((Process)this.getConfig().getProcess()).getFeedUrl();
        DataSourceConnectionConfig.Attributes attributes = this.getConfig().getAttributes();
        List attrs = attributes.getAttribute();
        this._attributes = attrs.toArray(new Attribute[attrs.size()]);
    }

    private void fetch(FeedFetcher feedFetcher, String feedUrl) {
        try {
            SyndFeed feed = feedFetcher.retrieveFeed(new URL(feedUrl));
            if (feed != null) {
                List entries;
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Fetched feed " + feedUrl));
                }
                if ((entries = feed.getEntries()) != null) {
                    for (SyndEntryImpl entry : entries) {
                        try {
                            if (entry == null) continue;
                            ArrayList<org.eclipse.smila.datamodel.record.Attribute> idAttributes = new ArrayList<org.eclipse.smila.datamodel.record.Attribute>();
                            ArrayList<org.eclipse.smila.datamodel.record.Attribute> hashAttributes = new ArrayList<org.eclipse.smila.datamodel.record.Attribute>();
                            HashMap<String, byte[]> hashAttachments = new HashMap<String, byte[]>();
                            this.readIdAndHashAttributesAndAttachments(feed, entry, idAttributes, hashAttributes, hashAttachments);
                            String hash = this.createHash(hashAttributes, hashAttachments);
                            Record record = this.createRecord(feed, entry, idAttributes);
                            if (this._log.isTraceEnabled()) {
                                this._log.trace((Object)("created record " + record.getId()));
                            }
                            this.getControllerCallback().add(this.getSessionId(), this.getConfig().getDeltaIndexing(), record, hash);
                        }
                        catch (AgentException e) {
                            this.getAgentState().setLastError((Throwable)e);
                            if (!this._log.isErrorEnabled()) continue;
                            this._log.error((Object)("Error during creation of record for entry " + entry.getUri() + " of feed " + feedUrl), (Throwable)e);
                        }
                        catch (InvalidTypeException e) {
                            this.getAgentState().setLastError((Throwable)e);
                            if (!this._log.isErrorEnabled()) continue;
                            this._log.error((Object)("Error during creation of record for entry " + entry.getUri() + " of feed " + feedUrl), (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (FetcherException e) {
            this.getAgentState().setLastError((Throwable)e);
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)("HTTP error during fetching of feed " + feedUrl), (Throwable)e);
            }
        }
        catch (FeedException e) {
            this.getAgentState().setLastError((Throwable)e);
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)("Error during fetching of feed " + feedUrl + ". The feed is invalid"), (Throwable)e);
            }
        }
        catch (IOException e) {
            this.getAgentState().setLastError((Throwable)e);
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)("TCP error during fetching of feed " + feedUrl), (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            this.getAgentState().setLastError((Throwable)e);
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)("Error during fetching of feed " + feedUrl + ". The URL is invalid"), (Throwable)e);
            }
            throw e;
        }
    }

    private Record createRecord(SyndFeed feed, SyndEntryImpl entry, List<org.eclipse.smila.datamodel.record.Attribute> idAttributes) throws AgentException, InvalidTypeException {
        Id id = ConnectivityIdFactory.getInstance().createId(this.getConfig().getDataSourceID(), idAttributes.toArray(new org.eclipse.smila.datamodel.record.Attribute[idAttributes.size()]));
        Record record = this._factory.createRecord();
        record.setId(id);
        MObject metadata = this._factory.createMetadataObject();
        record.setMetadata(metadata);
        this.fillRecord(feed, entry, record);
        return record;
    }

    private String createHash(List<org.eclipse.smila.datamodel.record.Attribute> hashAttributes, Map<String, byte[]> hashAttachments) {
        return ConnectivityHashFactory.getInstance().createHash(hashAttributes.toArray(new org.eclipse.smila.datamodel.record.Attribute[hashAttributes.size()]), hashAttachments);
    }

    private void readIdAndHashAttributesAndAttachments(SyndFeed feed, SyndEntryImpl entry, List<org.eclipse.smila.datamodel.record.Attribute> idAttributes, List<org.eclipse.smila.datamodel.record.Attribute> hashAttributes, Map<String, byte[]> hashAttachments) throws AgentException, InvalidTypeException {
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attributeDef = attributeArray[n2];
            if (attributeDef.isKeyAttribute() || attributeDef.isHashAttribute()) {
                Object value;
                if (attributeDef.isAttachment()) {
                    value = this.readAttachment(feed, entry, attributeDef);
                    hashAttachments.put(attributeDef.getName(), (byte[])value);
                } else {
                    value = this.readAttribute(feed, entry, attributeDef);
                    if (value != null) {
                        org.eclipse.smila.datamodel.record.Attribute attribute = this.createAttribute(attributeDef, value);
                        if (attributeDef.isKeyAttribute()) {
                            idAttributes.add(attribute);
                        }
                        if (attributeDef.isHashAttribute()) {
                            hashAttributes.add(attribute);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private org.eclipse.smila.datamodel.record.Attribute createAttribute(Attribute attributeDef, Object value) throws InvalidTypeException {
        org.eclipse.smila.datamodel.record.Attribute attribute = this._factory.createAttribute();
        attribute.setName(attributeDef.getName());
        if (value instanceof MObject) {
            attribute.setObject((MObject)value);
        } else if (value instanceof Collection) {
            attribute.setObjects((Collection)value);
        } else if (value instanceof Object[]) {
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                Literal literal = this._factory.createLiteral();
                literal.setValue(element);
                attribute.addLiteral(literal);
                ++n2;
            }
        } else {
            Literal literal = this._factory.createLiteral();
            literal.setValue(value);
            attribute.addLiteral(literal);
        }
        return attribute;
    }

    private void fillRecord(SyndFeed feed, SyndEntryImpl entry, Record record) throws AgentException, InvalidTypeException {
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Object value;
            Attribute attributeDef = attributeArray[n2];
            if (attributeDef.isAttachment()) {
                value = this.readAttachment(feed, entry, attributeDef);
                record.setAttachment(attributeDef.getName(), value);
            } else {
                value = this.readAttribute(feed, entry, attributeDef);
                if (value != null) {
                    org.eclipse.smila.datamodel.record.Attribute attribute = this.createAttribute(attributeDef, value);
                    record.getMetadata().setAttribute(attributeDef.getName(), attribute);
                }
            }
            ++n2;
        }
    }

    private Object readAttribute(SyndFeed feed, SyndEntryImpl entry, Attribute attributeDef) throws AgentException {
        switch (attributeDef.getFeedAttributes()) {
            case FEED_AUTHORS: {
                return this.getPersons(feed.getAuthors(), feed.getAuthor());
            }
            case FEED_CATEGORIES: {
                return this.getCategories(feed.getCategories());
            }
            case FEED_CONTRIBUTORS: {
                return this.getPersons(feed.getContributors(), null);
            }
            case FEED_COPYRIGHT: {
                return feed.getCopyright();
            }
            case FEED_DESCRIPTION: {
                return feed.getDescription();
            }
            case FEED_ENCODING: {
                return feed.getEncoding();
            }
            case FEED_TYPE: {
                return feed.getFeedType();
            }
            case FEED_IMAGE: {
                return this.getImage(feed.getImage());
            }
            case FEED_LANGUAGE: {
                return feed.getLanguage();
            }
            case FEED_LINKS: {
                return this.getLinks(feed.getLinks(), feed.getLink());
            }
            case FEED_PUBLISH_DATE: {
                return feed.getPublishedDate();
            }
            case FEED_TITLE: {
                return feed.getTitle();
            }
            case FEED_URI: {
                return feed.getUri();
            }
            case AUTHORS: {
                return this.getPersons(entry.getAuthors(), entry.getAuthor());
            }
            case CATEGORIES: {
                return this.getCategories(entry.getCategories());
            }
            case CONTENTS: {
                return this.getContents(entry.getContents());
            }
            case CONTRIBUTORS: {
                return this.getPersons(entry.getContributors(), null);
            }
            case DESCRIPTION: {
                return this.getContent(entry.getDescription());
            }
            case ENCLOSURES: {
                return this.getEnclosures(entry.getEnclosures());
            }
            case LINKS: {
                return this.getLinks(entry.getLinks(), entry.getLink());
            }
            case PUBLISH_DATE: {
                return entry.getPublishedDate();
            }
            case TITLE: {
                return entry.getTitle();
            }
            case URI: {
                return entry.getUri();
            }
            case UPDATE_DATE: {
                return entry.getUpdatedDate();
            }
        }
        throw new RuntimeException("Unknown feed attributes type " + (Object)((Object)attributeDef.getFeedAttributes()));
    }

    private MObject getImage(SyndImage feedImage) {
        block3: {
            if (feedImage != null) {
                try {
                    MObject mobject = this._factory.createMetadataObject();
                    this.setAttribute(mobject, this.createSubAttribute("Link", feedImage.getLink()));
                    this.setAttribute(mobject, this.createSubAttribute("Title", feedImage.getTitle()));
                    this.setAttribute(mobject, this.createSubAttribute("Url", feedImage.getUrl()));
                    this.setAttribute(mobject, this.createSubAttribute("Description", feedImage.getDescription()));
                }
                catch (InvalidTypeException e) {
                    if (!this._log.isErrorEnabled()) break block3;
                    this._log.error((Object)"Error while creating MObject ", (Throwable)e);
                }
            }
        }
        return null;
    }

    private List<MObject> getPersons(List<SyndPerson> persons, String fallbackValue) {
        block7: {
            if (persons != null && !persons.isEmpty()) {
                ArrayList<MObject> personList = new ArrayList<MObject>();
                for (SyndPerson person : persons) {
                    try {
                        MObject mobject = this._factory.createMetadataObject();
                        this.setAttribute(mobject, this.createSubAttribute("Email", person.getEmail()));
                        this.setAttribute(mobject, this.createSubAttribute("Name", person.getName()));
                        this.setAttribute(mobject, this.createSubAttribute("Uri", person.getUri()));
                        personList.add(mobject);
                    }
                    catch (InvalidTypeException e) {
                        if (!this._log.isErrorEnabled()) continue;
                        this._log.error((Object)"Error while creating Person MObject ", (Throwable)e);
                    }
                }
                return personList;
            }
            if (fallbackValue != null) {
                ArrayList<MObject> personList = new ArrayList<MObject>();
                try {
                    MObject mobject = this._factory.createMetadataObject();
                    this.setAttribute(mobject, this.createSubAttribute("Name", fallbackValue));
                    personList.add(mobject);
                    return personList;
                }
                catch (InvalidTypeException e) {
                    if (!this._log.isErrorEnabled()) break block7;
                    this._log.error((Object)"Error while creating Person MObject ", (Throwable)e);
                }
            }
        }
        return null;
    }

    private List<MObject> getCategories(List<SyndCategory> categories) {
        if (categories != null) {
            ArrayList<MObject> categoryList = new ArrayList<MObject>();
            for (SyndCategory category : categories) {
                try {
                    MObject mobject = this._factory.createMetadataObject();
                    this.setAttribute(mobject, this.createSubAttribute("Name", category.getName()));
                    this.setAttribute(mobject, this.createSubAttribute("TaxanomyUri", category.getTaxonomyUri()));
                    categoryList.add(mobject);
                }
                catch (InvalidTypeException e) {
                    if (!this._log.isErrorEnabled()) continue;
                    this._log.error((Object)"Error while creating Category MObject ", (Throwable)e);
                }
            }
            return categoryList;
        }
        return null;
    }

    private List<MObject> getEnclosures(List<SyndEnclosure> enclosures) {
        if (enclosures != null) {
            ArrayList<MObject> enclosureList = new ArrayList<MObject>();
            for (SyndEnclosure enclosure : enclosures) {
                try {
                    MObject mobject = this._factory.createMetadataObject();
                    this.setAttribute(mobject, this.createSubAttribute("Type", enclosure.getType()));
                    this.setAttribute(mobject, this.createSubAttribute("Url", enclosure.getUrl()));
                    this.setAttribute(mobject, this.createSubAttribute("Length", enclosure.getLength()));
                    enclosureList.add(mobject);
                }
                catch (InvalidTypeException e) {
                    if (!this._log.isErrorEnabled()) continue;
                    this._log.error((Object)"Error while creating Category MObject ", (Throwable)e);
                }
            }
            return enclosureList;
        }
        return null;
    }

    private List<MObject> getLinks(List<SyndLink> links, String fallbackValue) {
        block7: {
            if (links != null && !links.isEmpty()) {
                ArrayList<MObject> linkList = new ArrayList<MObject>();
                for (SyndLink link : links) {
                    try {
                        MObject mobject = this._factory.createMetadataObject();
                        this.setAttribute(mobject, this.createSubAttribute("Href", link.getHref()));
                        this.setAttribute(mobject, this.createSubAttribute("Hreflang", link.getHreflang()));
                        this.setAttribute(mobject, this.createSubAttribute("Rel", link.getRel()));
                        this.setAttribute(mobject, this.createSubAttribute("Title", link.getTitle()));
                        this.setAttribute(mobject, this.createSubAttribute("Type", link.getType()));
                        this.setAttribute(mobject, this.createSubAttribute("Length", link.getLength()));
                        linkList.add(mobject);
                    }
                    catch (InvalidTypeException e) {
                        if (!this._log.isErrorEnabled()) continue;
                        this._log.error((Object)"Error while creating Link MObject ", (Throwable)e);
                    }
                }
                return linkList;
            }
            if (fallbackValue != null) {
                ArrayList<MObject> linkList = new ArrayList<MObject>();
                try {
                    MObject mobject = this._factory.createMetadataObject();
                    this.setAttribute(mobject, this.createSubAttribute("Href", fallbackValue));
                    linkList.add(mobject);
                    return linkList;
                }
                catch (InvalidTypeException e) {
                    if (!this._log.isErrorEnabled()) break block7;
                    this._log.error((Object)"Error while creating Person MObject ", (Throwable)e);
                }
            }
        }
        return null;
    }

    private List<MObject> getContents(List<SyndContent> contents) {
        if (contents != null) {
            ArrayList<MObject> contentList = new ArrayList<MObject>();
            for (SyndContent content : contents) {
                MObject mobject = this.getContent(content);
                if (mobject == null) continue;
                contentList.add(mobject);
            }
            return contentList;
        }
        return null;
    }

    private MObject getContent(SyndContent content) {
        block8: {
            if (content != null) {
                try {
                    MObject mobject = this._factory.createMetadataObject();
                    this.setAttribute(mobject, this.createSubAttribute("Mode", content.getMode()));
                    this.setAttribute(mobject, this.createSubAttribute("Value", content.getValue()));
                    String type = content.getType();
                    if ("html".equals(type)) {
                        type = "text/html";
                    } else if ("xml".equals(type)) {
                        type = "text/xml";
                    } else if ("text".equals(type)) {
                        type = "text/Plain";
                    }
                    this.setAttribute(mobject, this.createSubAttribute("Type", type));
                    return mobject;
                }
                catch (InvalidTypeException e) {
                    if (!this._log.isErrorEnabled()) break block8;
                    this._log.error((Object)"Error while creating Category MObject ", (Throwable)e);
                }
            }
        }
        return null;
    }

    private org.eclipse.smila.datamodel.record.Attribute createSubAttribute(String name, Object value) throws InvalidTypeException {
        if (value != null) {
            org.eclipse.smila.datamodel.record.Attribute attribute = this._factory.createAttribute();
            attribute.setName(name);
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    Literal literal = this._factory.createLiteral();
                    literal.setValue(element);
                    attribute.addLiteral(literal);
                    ++n2;
                }
            } else {
                Literal literal = this._factory.createLiteral();
                literal.setValue(value);
                attribute.addLiteral(literal);
            }
            return attribute;
        }
        return null;
    }

    private void setAttribute(MObject mobject, org.eclipse.smila.datamodel.record.Attribute attribute) {
        if (mobject != null && attribute != null) {
            mobject.setAttribute(attribute.getName(), attribute);
        }
    }

    private byte[] readAttachment(SyndFeed feed, SyndEntryImpl entry, Attribute attribute) throws AgentException {
        Object value = this.readAttribute(feed, entry, attribute);
        if (value != null) {
            if (value instanceof String) {
                try {
                    return ((String)value).getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new AgentException((Throwable)e);
                }
            }
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("The value type " + value.getClass() + " of attribute " + attribute.getName() + " cannot be used for attachments."));
            }
        }
        return null;
    }
}

