/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.apache.ode.bpel.engine.BpelInstanceWorker;
import org.apache.ode.bpel.engine.ODEProcess;

class BpelInstanceWorkerCache {
    private HashMap<Long, WeakReference<BpelInstanceWorker>> _cache = new HashMap();
    private ReferenceQueue<BpelInstanceWorker> _refQ = new ReferenceQueue();
    private ODEProcess _process;

    public BpelInstanceWorkerCache(ODEProcess oDEProcess) {
        this._process = oDEProcess;
    }

    synchronized BpelInstanceWorker get(long l) {
        BpelInstanceWorker bpelInstanceWorker;
        this.expungeStaleEntries();
        WeakReference<BpelInstanceWorker> weakReference = this._cache.get(l);
        if (weakReference == null) {
            bpelInstanceWorker = new BpelInstanceWorker(this._process, l);
            weakReference = new WeakReference<BpelInstanceWorker>(bpelInstanceWorker, this._refQ);
            this._cache.put(l, weakReference);
        } else {
            bpelInstanceWorker = (BpelInstanceWorker)weakReference.get();
            if (bpelInstanceWorker == null) {
                bpelInstanceWorker = new BpelInstanceWorker(this._process, l);
                weakReference = new WeakReference<BpelInstanceWorker>(bpelInstanceWorker, this._refQ);
                this._cache.put(l, weakReference);
            }
        }
        return bpelInstanceWorker;
    }

    private void expungeStaleEntries() {
        Reference<BpelInstanceWorker> reference;
        while ((reference = this._refQ.poll()) != null) {
            this._cache.values().remove(reference);
        }
    }
}

