/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.filesystem;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.AbstractCrawler;
import org.eclipse.smila.connectivity.framework.CrawlerCallback;
import org.eclipse.smila.connectivity.framework.CrawlerCriticalException;
import org.eclipse.smila.connectivity.framework.CrawlerException;
import org.eclipse.smila.connectivity.framework.DataReference;
import org.eclipse.smila.connectivity.framework.crawler.filesystem.FileSystemCrawlerPerformanceAgent;
import org.eclipse.smila.connectivity.framework.crawler.filesystem.messages.Attribute;
import org.eclipse.smila.connectivity.framework.crawler.filesystem.messages.Process;
import org.eclipse.smila.connectivity.framework.performancecounters.CrawlerPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.schema.config.interfaces.IProcess;
import org.eclipse.smila.connectivity.framework.util.DataReferenceFactory;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.InvalidTypeException;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.datamodel.tools.MObjectHelper;
import org.eclipse.smila.utils.file.EncodingHelper;

public class FileSystemCrawler
extends AbstractCrawler {
    private static final String POC_FOLDERS = "folders";
    private static final String POC_FILES = "files";
    private static final String POC_PRODUCER_EXCEPTIONS = "producerExceptions";
    private static final int QUEUE_POLL_WAITING = 300;
    private static final int HAS_NEXT_WAITING = 50;
    private static final int CAPACITY = 100;
    private static final int STEP = 10;
    private final Log _log = LogFactory.getLog(FileSystemCrawler.class);
    private ArrayBlockingQueue<DataReference> _queue;
    private CrawlingProducerThread _crawlThread;
    private boolean _isProducerRunning = true;
    private boolean _opened;
    private final Object _openedMonitor = new Object();
    private boolean _forceClosing;
    private final RecordFactory _factory = RecordFactory.DEFAULT_INSTANCE;
    private Attribute[] _attributes;
    private String[] _attachmentNames;
    private Map<String, File> _idToPath;
    private CrawlerPerformanceCounterHelper<FileSystemCrawlerPerformanceAgent> _performanceCounters;

    public FileSystemCrawler() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Creating FileSystemCrawler instance");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DataSourceConnectionConfig config) throws CrawlerException, CrawlerCriticalException {
        this._log.info((Object)"Initializing FileSystemCrawler...");
        Object object = this._openedMonitor;
        synchronized (object) {
            if (this._opened) {
                throw new CrawlerCriticalException("Crawler is busy (it should not happen because new instances are created by ComponentFactories)");
            }
            this.checkFolders(config);
            this._opened = true;
        }
        this._forceClosing = false;
        this._isProducerRunning = true;
        this._queue = new ArrayBlockingQueue(100);
        this._idToPath = new HashMap<String, File>();
        DataSourceConnectionConfig.Attributes attributes = config.getAttributes();
        List attrs = attributes.getAttribute();
        this._performanceCounters = new CrawlerPerformanceCounterHelper(config, ((Object)((Object)this)).hashCode(), FileSystemCrawlerPerformanceAgent.class);
        this._attributes = attrs.toArray(new Attribute[attrs.size()]);
        ArrayList<String> attachmentsNames = new ArrayList<String>();
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute a = attributeArray[n2];
            if (a.isAttachment()) {
                attachmentsNames.add(a.getName());
            }
            ++n2;
        }
        this._attachmentNames = attachmentsNames.toArray(new String[attachmentsNames.size()]);
        this._crawlThread = new CrawlingProducerThread((CrawlerCallback)this, config);
        this._crawlThread.start();
    }

    public DataReference[] getNext() throws CrawlerException, CrawlerCriticalException {
        while (this.hasNext()) {
            ArrayList<DataReference> refList = new ArrayList<DataReference>();
            try {
                DataReference ref = this._queue.poll(300L, TimeUnit.MILLISECONDS);
                if (ref == null) continue;
                refList.add(ref);
                int size = this._queue.drainTo(refList, 9);
                return refList.toArray(new DataReference[size + 1]);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Id id) {
        Map<String, File> map = this._idToPath;
        synchronized (map) {
            this._idToPath.remove(id.getIdHash());
        }
    }

    public byte[] getAttachment(Id id, String name) throws CrawlerException, CrawlerCriticalException {
        File file = this.getFileById(id);
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute.getName().equals(name)) {
                return this.readAttachment(file, attribute);
            }
            ++n2;
        }
        throw new CrawlerCriticalException(String.format("Unable to find attachment definition for [%s]", name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileById(Id id) throws CrawlerException {
        File file;
        Map<String, File> map = this._idToPath;
        synchronized (map) {
            file = this._idToPath.get(id.getIdHash());
        }
        this.ensureFileExists(id, file);
        return file;
    }

    public String[] getAttachmentNames(Id id) throws CrawlerException, CrawlerCriticalException {
        return this._attachmentNames;
    }

    public MObject getMObject(Id id) throws CrawlerException, CrawlerCriticalException {
        File file = this.getFileById(id);
        MObject mObject = this._factory.createMetadataObject();
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Serializable value;
            Attribute attribute = attributeArray[n2];
            if (!attribute.isAttachment() && (value = this.readAttribute(file, attribute, true)) != null) {
                try {
                    MObjectHelper.addSimpleLiteralAttribute((RecordFactory)this._factory, (MObject)mObject, (String)attribute.getName(), (Object)value);
                }
                catch (Throwable e) {
                    throw new CrawlerException(e);
                }
            }
            ++n2;
        }
        return mObject;
    }

    private void ensureFileExists(Id id, File file) throws CrawlerException {
        if (file == null) {
            throw new CrawlerException(String.format("Unable to find file for hash [%s]", id.getIdHash()));
        }
        if (file == null || !file.exists()) {
            throw new CrawlerException(String.format("Unable to find file [%s]", file.getPath()));
        }
    }

    private void checkFolders(DataSourceConnectionConfig config) throws CrawlerCriticalException {
        Process process = (Process)config.getProcess();
        int processingLength = process.getBaseDirAndFilter().size();
        for (int i = 0; i < processingLength; ++i) {
            String path = (String)process.getBaseDirAndFilter().get(i++);
            File file = new File(path);
            if (file.exists() && file.isDirectory()) continue;
            throw new CrawlerCriticalException(String.format("Folder \"%s\" is not found", path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CrawlerException {
        Object object = this._openedMonitor;
        synchronized (object) {
            this._opened = false;
            this._log.info((Object)"Closing FileSystemCrawler...");
            this._forceClosing = true;
            this._isProducerRunning = false;
            this._crawlThread = null;
            this._queue = null;
            this._idToPath = null;
            this._attachmentNames = null;
            this._performanceCounters = null;
        }
    }

    private boolean hasNext() {
        while (this._isProducerRunning && this._queue.isEmpty()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return !this._queue.isEmpty();
    }

    private Serializable readAttribute(File file, Attribute attribute, boolean forceByteToString) throws CrawlerException {
        switch (attribute.getFileAttributes()) {
            case NAME: {
                return file.getName();
            }
            case FILE_EXTENSION: {
                return FilenameUtils.getExtension((String)file.getName());
            }
            case PATH: {
                return file.getAbsolutePath();
            }
            case LAST_MODIFIED_DATE: {
                return new Date(file.lastModified());
            }
            case SIZE: {
                return new Long(file.length());
            }
            case CONTENT: {
                try {
                    byte[] bytes = FileUtils.readFileToByteArray((File)file);
                    if (forceByteToString) {
                        try {
                            return EncodingHelper.convertToString((byte[])bytes);
                        }
                        catch (Exception e) {
                            throw new CrawlerException("Error decoding content from file " + file.getAbsolutePath(), (Throwable)e);
                        }
                    }
                    return bytes;
                }
                catch (IOException e) {
                    throw new CrawlerException("Error reading attribute from file " + file.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        throw new RuntimeException("Unknown file attributes type " + (Object)((Object)attribute.getFileAttributes()));
    }

    private byte[] readAttachment(File file, Attribute attribute) throws CrawlerException {
        Serializable value = this.readAttribute(file, attribute, false);
        if (value != null) {
            if (value instanceof String) {
                try {
                    return ((String)((Object)value)).getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new CrawlerException((Throwable)e);
                }
            }
            if (value instanceof byte[]) {
                return (byte[])value;
            }
        }
        return null;
    }

    private class CrawlingProducerThread
    extends Thread {
        private final CrawlerCallback _crawlerCallback;
        private final String _dataSourceID;
        private final Process _process;
        private final int _processingLength;

        public CrawlingProducerThread(CrawlerCallback crawlerCallback, DataSourceConnectionConfig configuration) {
            IProcess process = configuration.getProcess();
            this._crawlerCallback = crawlerCallback;
            this._dataSourceID = configuration.getDataSourceID();
            this._process = (Process)process;
            this._processingLength = this._process.getBaseDirAndFilter().size();
        }

        @Override
        public void run() {
            block10: {
                try {
                    try {
                        int i = 0;
                        while (i < this._processingLength) {
                            String path = (String)this._process.getBaseDirAndFilter().get(i++);
                            Process.Filter filter = (Process.Filter)this._process.getBaseDirAndFilter().get(i++);
                            File file = new File(path);
                            if (!file.exists() || !file.isDirectory()) {
                                FileSystemCrawler.this._log.error((Object)("Folder " + path + " is not found"));
                                continue;
                            }
                            this.processFolder(file, filter);
                        }
                    }
                    catch (Throwable ex) {
                        FileSystemCrawler.this._performanceCounters.addException(ex);
                        FileSystemCrawler.this._log.error((Object)"Producer error", ex);
                        FileSystemCrawler.this._isProducerRunning = false;
                        if (FileSystemCrawler.this._forceClosing) {
                            FileSystemCrawler.this._log.info((Object)"Producer finished by forcing close procedure");
                            break block10;
                        }
                        FileSystemCrawler.this._log.info((Object)"Producer finished!");
                    }
                }
                finally {
                    FileSystemCrawler.this._isProducerRunning = false;
                    if (FileSystemCrawler.this._forceClosing) {
                        FileSystemCrawler.this._log.info((Object)"Producer finished by forcing close procedure");
                    } else {
                        FileSystemCrawler.this._log.info((Object)"Producer finished!");
                    }
                }
            }
        }

        private void processFolder(File dir, Process.Filter filter) throws InvalidTypeException, CrawlerException {
            if (FileSystemCrawler.this._forceClosing) {
                return;
            }
            CrawlerFileFilter fileFilter = new CrawlerFileFilter(filter);
            this.treeWalk(dir, fileFilter, filter.isRecursive());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void treeWalk(File dir, CrawlerFileFilter fileFilter, boolean isRecursive) throws InvalidTypeException, CrawlerException {
            if (FileSystemCrawler.this._forceClosing) {
                return;
            }
            File[] entries = dir.listFiles(fileFilter);
            if (entries == null) {
                FileSystemCrawler.this._log.warn((Object)("Unknown IO error while listing directory " + dir + ", skipping."));
            } else {
                int i = 0;
                while (i < entries.length) {
                    File file = entries[i];
                    if (file.isFile()) {
                        boolean waiting = true;
                        DataReference reference = null;
                        while (waiting) {
                            try {
                                if (reference == null) {
                                    reference = this.initializeDataReference(entries[i]);
                                }
                                Map map = FileSystemCrawler.this._idToPath;
                                synchronized (map) {
                                    FileSystemCrawler.this._idToPath.put(reference.getId().getIdHash(), file);
                                }
                                FileSystemCrawler.this._queue.put(reference);
                                waiting = false;
                                FileSystemCrawler.this._performanceCounters.increment(FileSystemCrawler.POC_FILES);
                            }
                            catch (Throwable e) {
                                FileSystemCrawler.this._performanceCounters.increment(FileSystemCrawler.POC_PRODUCER_EXCEPTIONS);
                                FileSystemCrawler.this._performanceCounters.addException(e);
                                FileSystemCrawler.this._log.error((Object)e);
                            }
                        }
                    } else if (isRecursive && file.isDirectory()) {
                        this.treeWalk(file, fileFilter, true);
                    } else {
                        FileSystemCrawler.this._log.warn((Object)("Path " + file + " is neither file nor directory, skipping."));
                    }
                    ++i;
                }
            }
            FileSystemCrawler.this._performanceCounters.increment(FileSystemCrawler.POC_FOLDERS);
        }

        private DataReference initializeDataReference(File file) throws CrawlerException, InvalidTypeException {
            ArrayList<org.eclipse.smila.datamodel.record.Attribute> idAttributes = new ArrayList<org.eclipse.smila.datamodel.record.Attribute>();
            ArrayList<org.eclipse.smila.datamodel.record.Attribute> hashAttributes = new ArrayList<org.eclipse.smila.datamodel.record.Attribute>();
            HashMap<String, byte[]> hashAttachments = new HashMap<String, byte[]>();
            this.readIdAndHashAttributesAndAttachments(file, idAttributes, hashAttributes, hashAttachments);
            return DataReferenceFactory.getInstance().createDataReference(this._crawlerCallback, this._dataSourceID, idAttributes.toArray(new org.eclipse.smila.datamodel.record.Attribute[idAttributes.size()]), hashAttributes.toArray(new org.eclipse.smila.datamodel.record.Attribute[hashAttributes.size()]), hashAttachments);
        }

        private void readIdAndHashAttributesAndAttachments(File file, List<org.eclipse.smila.datamodel.record.Attribute> idAttributes, List<org.eclipse.smila.datamodel.record.Attribute> hashAttributes, Map<String, byte[]> hashAttachments) throws CrawlerException, InvalidTypeException {
            Attribute[] attributeArray = FileSystemCrawler.this._attributes;
            int n = attributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attributeDef = attributeArray[n2];
                if (attributeDef.isKeyAttribute() || attributeDef.isHashAttribute()) {
                    Object value;
                    if (attributeDef.isAttachment()) {
                        value = FileSystemCrawler.this.readAttachment(file, attributeDef);
                        hashAttachments.put(attributeDef.getName(), (byte[])value);
                    } else {
                        value = FileSystemCrawler.this.readAttribute(file, attributeDef, true);
                        if (value != null) {
                            org.eclipse.smila.datamodel.record.Attribute attribute = FileSystemCrawler.this._factory.createAttribute();
                            attribute.setName(attributeDef.getName());
                            Literal literal = FileSystemCrawler.this._factory.createLiteral();
                            literal.setValue(value);
                            attribute.addLiteral(literal);
                            if (attributeDef.isKeyAttribute()) {
                                idAttributes.add(attribute);
                            }
                            if (attributeDef.isHashAttribute()) {
                                hashAttributes.add(attribute);
                            }
                        }
                    }
                }
                ++n2;
            }
        }

        private class CrawlerFileFilter
        implements FileFilter {
            private final Process.Filter _filter;
            private final IOCase _case;

            public CrawlerFileFilter(Process.Filter filter) {
                this._filter = filter;
                this._case = filter.isCaseSensitive() ? IOCase.SENSITIVE : IOCase.INSENSITIVE;
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (this._filter.getInclude() != null && this._filter.getInclude().size() > 0) {
                    long dateLong = file.lastModified();
                    boolean acceptedByInclude = false;
                    for (Process.Filter.Include include : this._filter.getInclude()) {
                        if (include.getDateFrom() != null && dateLong < include.getDateFrom().getTime() || include.getDateTo() != null && dateLong > include.getDateTo().getTime() || !FilenameUtils.wildcardMatch((String)file.getName(), (String)include.getName(), (IOCase)this._case)) continue;
                        acceptedByInclude = true;
                        break;
                    }
                    if (!acceptedByInclude) {
                        return false;
                    }
                }
                for (Process.Filter.Exclude exclude : this._filter.getExclude()) {
                    if (!FilenameUtils.wildcardMatch((String)file.getName(), (String)exclude.getName(), (IOCase)this._case)) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

