/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.lucene;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.lucene.ILuceneSchemaResolver;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.xml.SchemaResolver;

public class LuceneSchemaResolver
implements SchemaResolver,
ILuceneSchemaResolver {
    private static final String[] KNOWN_SCHEMAS = new String[]{"IndexStructure.xsd", "DataDictionaryConnection.xsd", "AnyFinderSearchDateFieldParameter.xsd", "AnyFinderSearchNumberFieldParameter.xsd", "AnyFinderSearchTextFieldParameter.xsd", "AnyFinderAdvancedSearch.xsd"};

    public byte[] getSchemaByName(String schemaName) {
        byte[] byArray;
        Log log = LogFactory.getLog(this.getClass());
        HashSet<String> schemas = new HashSet<String>();
        String[] stringArray = KNOWN_SCHEMAS;
        int n = KNOWN_SCHEMAS.length;
        int n2 = 0;
        while (n2 < n) {
            String schema = stringArray[n2];
            schemas.add("../xml/" + schema);
            ++n2;
        }
        if (!schemas.contains(schemaName)) {
            return null;
        }
        File folder = ConfigUtils.getConfigFolder((String)"org.eclipse.smila.lucene", (String)"xml");
        if (folder == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"unable to locate configuration folder [org.eclipse.smila.lucene/xml]");
            }
            return null;
        }
        FileInputStream fis = null;
        String fileName = String.valueOf(folder.getPath()) + "/" + schemaName;
        try {
            byte[] schema;
            fis = new FileInputStream(fileName);
            byArray = schema = IOUtils.toByteArray((InputStream)fis);
        }
        catch (Exception exception) {
            block8: {
                try {
                    if (!log.isErrorEnabled()) break block8;
                    log.error((Object)("unable to read schema file [" + fileName + "]"), (Throwable)exception);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
            return null;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return byArray;
    }
}

