/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.lucene;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.lucene.LuceneServie;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.SearchMessage;
import org.eclipse.smila.processing.SearchProcessingService;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.parameters.SearchAnnotations;
import org.eclipse.smila.search.datadictionary.DataDictionaryController;
import org.eclipse.smila.search.datadictionary.DataDictionaryException;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DAnyFinderDataDictionary;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConfig;
import org.eclipse.smila.search.index.IndexConnection;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.index.IndexManager;
import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameter;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.utils.search.DDateField;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DNumberField;
import org.eclipse.smila.search.utils.search.DQuery;
import org.eclipse.smila.search.utils.search.DTextField;
import org.eclipse.smila.search.utils.search.ITFParameter;
import org.eclipse.smila.search.utils.searchresult.DHit;
import org.eclipse.smila.search.utils.searchresult.LuceneSearchResult;
import org.osgi.service.component.ComponentContext;

public class LuceneSearchService
extends LuceneServie
implements SearchProcessingService {
    public static final String SEARCH_ANNOTATION_QUERY_ATTRIBUTE = "QueryAttribute";
    public static final String SEARCH_ANNOTATION_TEMPLATE_SELECTOR_NAME = "TemplateSelectorName";
    public static final String RANKING_OPERATOR = "Operator";
    public static final String RANKING_TOLERANCE = "Tolerance";
    public static final String MAPPINGS_ATTRIBUTES = "attributes";
    public static final String MAPPINGS_ATTACHMENTS = "attachments";
    public static final String DEFAULT_DATE_FORMAT = "dd.MM.yyyy";
    public static final String DEFAULT_DATE_TIME_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private final Log _log = LogFactory.getLog(LuceneSearchService.class);
    private HashMap<String, HashMap<String, HashMap<Integer, String>>> _reverseMappings = new HashMap();
    private DAnyFinderDataDictionary _dataDictionary;

    protected void activate(ComponentContext context) throws Exception {
        try {
            this.loadMappings();
            this.loadReverseMappings();
            this._dataDictionary = DataDictionaryController.getDataDictionary();
        }
        catch (Exception e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"error initializing LuceneSearchService", (Throwable)e);
            }
            throw e;
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        try {
            this.unloadReverseMappings();
            this.unloadMappings();
            this._dataDictionary = null;
        }
        catch (Exception e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"error deactivating LuceneSearchService", (Throwable)e);
            }
            throw e;
        }
    }

    public SearchMessage process(Blackboard blackboard, SearchMessage message) throws ProcessingException {
        if (message.hasQuery()) {
            try {
                this.search(blackboard, message);
            }
            catch (Exception ex) {
                String msg = "Error processing message " + message.getQuery();
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)msg, (Throwable)ex);
                }
                throw new ProcessingException(msg, (Throwable)ex);
            }
        }
        return message;
    }

    private void search(Blackboard blackboard, SearchMessage message) throws BlackboardAccessException, IndexException, DataDictionaryException, NodeTransformerException, ProcessingException {
        IndexConnection indexConnection;
        block12: {
            indexConnection = null;
            try {
                ParameterAccessor parameters = new ParameterAccessor(blackboard, message.getQuery());
                String indexName = this.getIndexname(blackboard, message.getQuery(), parameters);
                indexConnection = IndexManager.getInstance((String)indexName);
                if (indexConnection != null) {
                    DQuery dQuery = null;
                    if (this.hasQueryString(parameters)) {
                        dQuery = this.createSimpleQuery(parameters, indexName);
                    } else if (this.hasAttributeQuery(blackboard, message.getQuery(), parameters, indexName)) {
                        dQuery = this.createFieldedQuery(blackboard, message.getQuery(), parameters, indexName);
                    }
                    dQuery = this.appendFilter(dQuery, blackboard, message.getQuery(), parameters, indexName);
                    if (dQuery != null) {
                        dQuery = this.appendResultFields(dQuery, parameters, indexName);
                        dQuery = this.appendHiglightingFields(dQuery, blackboard, message.getQuery(), indexName);
                        LuceneSearchResult result = indexConnection.doQuery(dQuery);
                        this.processResult(blackboard, message, result);
                    } else {
                        message.setRecords(new Id[0]);
                        try {
                            this.setTotalHits(blackboard, message.getQuery(), 0);
                        }
                        catch (BlackboardAccessException ex) {
                            this._log.error((Object)ex);
                        }
                    }
                    break block12;
                }
                throw new IndexException("Could not open connection to index " + indexName);
            }
            catch (Throwable throwable) {
                if (indexConnection != null) {
                    IndexManager.releaseInstance(indexConnection, (boolean)false);
                }
                throw throwable;
            }
        }
        if (indexConnection != null) {
            IndexManager.releaseInstance((IndexConnection)indexConnection, (boolean)false);
        }
    }

    private boolean hasQueryString(ParameterAccessor parameters) {
        String queryString = parameters.getQuery();
        return queryString != null && queryString.trim().length() != 0;
    }

    private boolean hasAttributeQuery(Blackboard blackboard, Id id, ParameterAccessor parameters, String indexName) throws BlackboardAccessException {
        DIndex dIndex = this._dataDictionary.getIndex(indexName);
        Iterator fieldIt = dIndex.getConfiguration().getDefaultConfig().getFields();
        while (fieldIt.hasNext()) {
            org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field = (org.eclipse.smila.search.datadictionary.messages.ddconfig.DField)fieldIt.next();
            String attributeName = this.getAttributeName(indexName, field.getFieldNo());
            if (!blackboard.getRecord(id).getMetadata().hasAttribute(attributeName) || !blackboard.getRecord(id).getMetadata().getAttribute(attributeName).hasLiterals()) continue;
            return true;
        }
        return false;
    }

    private DQuery createSimpleQuery(ParameterAccessor parameters, String indexName) throws ProcessingException {
        String queryAttribute = parameters.getRequiredParameter(SEARCH_ANNOTATION_QUERY_ATTRIBUTE);
        int fieldNo = this.getFieldNo(indexName, queryAttribute);
        org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field = this._dataDictionary.getIndex(indexName).getConfiguration().getDefaultConfig().getField(fieldNo);
        DFieldConfig fieldConfig = field.getFieldConfig();
        DTextField textField = new DTextField();
        textField.setFieldNo(field.getFieldNo());
        textField.setType(fieldConfig.getType());
        textField.setText(parameters.getQuery());
        DQuery dQuery = this.createDQuery(parameters, indexName);
        dQuery.addField((DField)textField);
        return dQuery;
    }

    private DQuery createFieldedQuery(Blackboard blackboard, Id id, ParameterAccessor parameters, String indexName) throws BlackboardAccessException, ProcessingException {
        DQuery dQuery = this.createDQuery(parameters, indexName);
        DIndex dIndex = this._dataDictionary.getIndex(indexName);
        Iterator fieldIt = dIndex.getConfiguration().getDefaultConfig().getFields();
        while (fieldIt.hasNext()) {
            org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field = (org.eclipse.smila.search.datadictionary.messages.ddconfig.DField)fieldIt.next();
            String attributeName = this.getAttributeName(indexName, field.getFieldNo());
            if (!blackboard.getRecord(id).getMetadata().hasAttribute(attributeName) || !blackboard.getRecord(id).getMetadata().getAttribute(attributeName).hasLiterals()) continue;
            Attribute attribute = blackboard.getRecord(id).getMetadata().getAttribute(attributeName);
            DField searchField = this.createSearchField(field, attribute);
            dQuery.addField(searchField);
        }
        return dQuery;
    }

    private DQuery appendFilter(DQuery dQuery, Blackboard blackboard, Id id, ParameterAccessor parameters, String indexName) throws BlackboardAccessException, ProcessingException {
        DIndex dIndex = this._dataDictionary.getIndex(indexName);
        Iterator fieldIt = dIndex.getConfiguration().getDefaultConfig().getFields();
        while (fieldIt.hasNext()) {
            org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field = (org.eclipse.smila.search.datadictionary.messages.ddconfig.DField)fieldIt.next();
            String attributeName = this.getAttributeName(indexName, field.getFieldNo());
            if (!blackboard.getRecord(id).getMetadata().hasAttribute(attributeName) || !blackboard.getRecord(id).getMetadata().getAttribute(attributeName).hasAnnotation("filter")) continue;
            if (dQuery == null) {
                dQuery = this.createDQuery(parameters, indexName);
            }
            Annotation filter = blackboard.getRecord(id).getMetadata().getAttribute(attributeName).getAnnotation("filter");
            DField searchField = this.createSearchFilter(field, filter);
            dQuery.addField(searchField);
        }
        return dQuery;
    }

    private DQuery appendResultFields(DQuery dQuery, ParameterAccessor parameters, String indexName) throws BlackboardAccessException {
        List resultAttributes = parameters.getResultAttributes();
        if (resultAttributes != null) {
            ArrayList<Integer> resultFields = new ArrayList<Integer>(resultAttributes.size());
            for (String attributeName : resultAttributes) {
                try {
                    resultFields.add(this.getFieldNo(indexName, attributeName));
                }
                catch (Exception e) {
                    if (!this._log.isWarnEnabled()) continue;
                    this._log.warn((Object)("error appending result fieldNo for attribute " + attributeName), (Throwable)e);
                }
            }
            if (!resultFields.isEmpty()) {
                dQuery.setResultFields(resultFields);
            }
        }
        return dQuery;
    }

    private DQuery appendHiglightingFields(DQuery dQuery, Blackboard blackboard, Id id, String indexName) throws BlackboardAccessException {
        ArrayList<Integer> highlightFields = new ArrayList<Integer>();
        Iterator attributeNames = blackboard.getAttributeNames(id);
        while (attributeNames.hasNext()) {
            String attributeName = (String)attributeNames.next();
            Path path = new Path().add(attributeName, -1);
            if (!blackboard.hasAnnotation(id, path, "highlight")) continue;
            try {
                highlightFields.add(this.getFieldNo(indexName, attributeName));
            }
            catch (Exception e) {
                if (!this._log.isWarnEnabled()) continue;
                this._log.warn((Object)("error appending highlight fieldNo for attribute " + attributeName), (Throwable)e);
            }
        }
        if (!highlightFields.isEmpty()) {
            dQuery.setHighlightFields(highlightFields);
        }
        return dQuery;
    }

    private DQuery createDQuery(ParameterAccessor parameters, String indexName) {
        DQuery dQuery = new DQuery();
        dQuery.setIndexName(indexName);
        dQuery.setMaxHits(parameters.getResultSize());
        dQuery.setStartHits(Integer.valueOf(parameters.getResultOffset()));
        dQuery.setMinSimilarity((int)(parameters.getThreshold() * 100.0));
        dQuery.setShowHitDistribution(true);
        dQuery.setTemplateSelectorName(parameters.getParameter(SEARCH_ANNOTATION_TEMPLATE_SELECTOR_NAME, ""));
        return dQuery;
    }

    private DField createSearchField(org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field, Attribute attribute) throws ProcessingException {
        DTextField searchField;
        DFieldConfig fieldConfig = field.getFieldConfig();
        String type = fieldConfig.getType();
        if ("FTText".equals(type)) {
            searchField = this.createTextField(attribute);
        } else if ("FTDate".equals(type)) {
            searchField = this.createDateField(attribute);
        } else if ("FTNumber".equals(type)) {
            searchField = this.createNumberField(attribute);
        } else {
            throw new ProcessingException("unknown FieldConfig type " + type);
        }
        searchField.setFieldNo(field.getFieldNo());
        searchField.setType(fieldConfig.getType());
        return searchField;
    }

    private DTextField createTextField(Attribute attribute) {
        Annotation fieldParam;
        DTextField textField = new DTextField();
        textField.setText(attribute.getLiteral().getStringValue());
        if (attribute.hasAnnotation("ranking") && (fieldParam = attribute.getAnnotation("ranking")).hasNamedValues()) {
            DTextFieldParameter parameter = new DTextFieldParameter();
            String operator = fieldParam.getNamedValue(RANKING_OPERATOR);
            if (operator != null) {
                parameter.setOperator(DTextFieldParameter.DOperator.getInstance(operator));
            }
            String tolerance = fieldParam.getNamedValue(RANKING_TOLERANCE);
            if (operator != null) {
                parameter.setTolerance(DTextFieldParameter.DTolerance.getInstance(tolerance));
            }
            textField.setParameter((ITFParameter)parameter);
        }
        return textField;
    }

    private DDateField createDateField(Attribute attribute) throws ProcessingException {
        DDateField dateField = new DDateField();
        try {
            if (attribute.literalSize() != 2) {
                Date date = this.parseDate(attribute.getLiteral().getStringValue());
                Calendar value = Calendar.getInstance();
                value.setTime(date);
                dateField.setDateMin(value);
                dateField.setDateMax(value);
            }
        }
        catch (ParseException e) {
            throw new ProcessingException("error parsing date object of attribute " + attribute.getName(), (Throwable)e);
        }
        return dateField;
    }

    private DNumberField createNumberField(Attribute attribute) {
        DNumberField numberField = new DNumberField();
        Long value = Long.parseLong(attribute.getLiteral().getStringValue());
        numberField.setMin(value);
        numberField.setMax(value);
        return numberField;
    }

    private DField createSearchFilter(org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field, Annotation annotation) throws ProcessingException {
        DDateField searchField;
        DFieldConfig fieldConfig = field.getFieldConfig();
        String type = fieldConfig.getType();
        if ("FTText".equals(type)) {
            throw new ProcessingException("FTText does not support filter annotations");
        }
        if ("FTDate".equals(type)) {
            searchField = this.createDateFilter(annotation);
        } else if ("FTNumber".equals(type)) {
            searchField = this.createNumberFilter(annotation);
        } else {
            throw new ProcessingException("unknown FieldConfig type " + type);
        }
        searchField.setFieldNo(field.getFieldNo());
        searchField.setType(fieldConfig.getType());
        return searchField;
    }

    private DDateField createDateFilter(Annotation annotation) throws ProcessingException {
        DDateField dateField = new DDateField();
        if (SearchAnnotations.FilterType.RANGE.name().equals(annotation.getNamedValue("type"))) {
            try {
                Calendar minValue = Calendar.getInstance();
                String minStringValue = annotation.getNamedValue("min");
                if (minStringValue != null) {
                    Date minDate = this.parseDate(minStringValue);
                    minValue.setTime(minDate);
                } else {
                    minValue.setTimeInMillis(0L);
                }
                Calendar maxValue = Calendar.getInstance();
                String maxStringValue = annotation.getNamedValue("max");
                if (maxStringValue != null) {
                    Date maxDate = this.parseDate(maxStringValue);
                    maxValue.setTime(maxDate);
                } else {
                    maxValue.setTimeInMillis(Long.MAX_VALUE);
                }
                dateField.setDateMin(minValue);
                dateField.setDateMax(maxValue);
            }
            catch (ParseException e) {
                throw new ProcessingException("error parsing date object of annotation " + annotation, (Throwable)e);
            }
        } else {
            throw new ProcessingException("");
        }
        return dateField;
    }

    private DNumberField createNumberFilter(Annotation annotation) throws ProcessingException {
        long maxValue;
        long minValue;
        DNumberField numberField = new DNumberField();
        if (SearchAnnotations.FilterType.RANGE.name().equals(annotation.getNamedValue("type"))) {
            minValue = Long.MIN_VALUE;
            String minStringValue = annotation.getNamedValue("min");
            if (minStringValue != null) {
                minValue = Long.parseLong(minStringValue);
            }
            maxValue = Long.MAX_VALUE;
            String maxStringValue = annotation.getNamedValue("max");
            if (maxStringValue != null) {
                maxValue = Long.parseLong(maxStringValue);
            }
        } else {
            throw new ProcessingException("");
        }
        numberField.setMin(Long.valueOf(minValue));
        numberField.setMax(Long.valueOf(maxValue));
        return numberField;
    }

    private void processResult(Blackboard blackboard, SearchMessage message, LuceneSearchResult luceneResult) throws BlackboardAccessException, IndexException {
        if (luceneResult != null && !luceneResult.getResultList().isEmpty()) {
            int[] hitStatistic = this.getHitStatistics(luceneResult);
            this.setTotalHits(blackboard, message.getQuery(), hitStatistic[0]);
            this.setIndexSize(blackboard, message.getQuery(), hitStatistic[1]);
            ArrayList<Id> resultIds = new ArrayList<Id>(luceneResult.getResultList().size());
            for (Record record : luceneResult.getResultList()) {
                blackboard.setRecord(record);
                resultIds.add(record.getId());
            }
            message.setRecords(resultIds);
        } else {
            this.setTotalHits(blackboard, message.getQuery(), 0);
        }
    }

    private int[] getHitStatistics(LuceneSearchResult luceneResult) {
        int resultCount = 0;
        int docsIndexed = 0;
        Enumeration hitEnum = luceneResult.getHitDistribution().getHits();
        while (hitEnum.hasMoreElements()) {
            DHit hit = (DHit)hitEnum.nextElement();
            if (hit.getScore() > 0) {
                resultCount += hit.getHits();
            }
            docsIndexed += hit.getHits();
        }
        return new int[]{resultCount, docsIndexed};
    }

    private String getIndexname(Blackboard blackboard, Id id, ParameterAccessor parameters) throws BlackboardAccessException {
        Annotation pipeletAnnotation;
        String indexName = parameters.getIndexName();
        if (indexName == null && (pipeletAnnotation = blackboard.getAnnotation(id, null, this.getClass().getName())) != null) {
            indexName = pipeletAnnotation.getNamedValue("indexName");
        }
        return indexName;
    }

    private String getAttributeName(String indexName, int fieldNo) {
        HashMap<Integer, String> attachMap;
        HashMap<Integer, String> attMap;
        String attributeName = null;
        HashMap<String, HashMap<Integer, String>> indexMap = this._reverseMappings.get(indexName);
        if (indexMap != null && (attMap = indexMap.get(MAPPINGS_ATTRIBUTES)) != null && (attributeName = attMap.get(fieldNo)) == null && (attachMap = indexMap.get(MAPPINGS_ATTACHMENTS)) != null) {
            attributeName = attachMap.get(fieldNo);
        }
        return attributeName;
    }

    private int getFieldNo(String indexName, String name) throws ProcessingException {
        if (this.getMappings().get(indexName).get(MAPPINGS_ATTRIBUTES).containsKey(name)) {
            return this.getMappings().get(indexName).get(MAPPINGS_ATTRIBUTES).get(name);
        }
        if (this.getMappings().get(indexName).get(MAPPINGS_ATTACHMENTS).containsKey(name)) {
            return this.getMappings().get(indexName).get(MAPPINGS_ATTACHMENTS).get(name);
        }
        throw new ProcessingException("Could not find fieldNo for attribute/attachment named " + name);
    }

    private void loadReverseMappings() {
        if (this.getMappings() != null) {
            Iterator<String> indexNames = this.getMappings().keySet().iterator();
            while (indexNames.hasNext()) {
                HashMap reverseMap = new HashMap();
                String indexName = indexNames.next();
                HashMap<String, HashMap<String, Integer>> indexMap = this.getMappings().get(indexName);
                Iterator<String> mapNames = indexMap.keySet().iterator();
                while (mapNames.hasNext()) {
                    HashMap<Integer, String> reverseAttMap = new HashMap<Integer, String>();
                    String mapName = mapNames.next();
                    HashMap<String, Integer> attMap = indexMap.get(mapName);
                    for (String attName : attMap.keySet()) {
                        Integer fieldNo = attMap.get(attName);
                        reverseAttMap.put(fieldNo, attName);
                    }
                    reverseMap.put(mapName, reverseAttMap);
                }
                this._reverseMappings.put(indexName, reverseMap);
            }
        }
    }

    private void unloadReverseMappings() {
        if (this._reverseMappings != null) {
            Collection<HashMap<String, HashMap<Integer, String>>> collection = this._reverseMappings.values();
            for (HashMap<String, HashMap<Integer, String>> map : collection) {
                if (map == null) continue;
                Collection<HashMap<Integer, String>> values = map.values();
                for (HashMap<Integer, String> submap : values) {
                    if (submap == null) continue;
                    submap.clear();
                }
                map.clear();
            }
            this._reverseMappings.clear();
            this._reverseMappings = null;
        }
    }

    private Date parseDate(String dateString) throws ParseException {
        try {
            return new SimpleDateFormat(DEFAULT_DATE_TIME_FORMAT).parse(dateString);
        }
        catch (ParseException parseException) {
            return new SimpleDateFormat(DEFAULT_DATE_FORMAT).parse(dateString);
        }
    }

    private void setTotalHits(Blackboard blackboard, Id record, int noOfHits) throws BlackboardAccessException {
        Annotation resultAnno = this.ensureRecordAnnotation(blackboard, record, "result");
        resultAnno.setNamedValue("totalHits", Integer.toString(noOfHits));
    }

    private void setIndexSize(Blackboard blackboard, Id record, int indexSize) throws BlackboardAccessException {
        Annotation resultAnno = this.ensureRecordAnnotation(blackboard, record, "result");
        resultAnno.setNamedValue("indexSize", Integer.toString(indexSize));
    }

    private Annotation ensureRecordAnnotation(Blackboard blackboard, Id record, String name) throws BlackboardAccessException {
        Annotation annotation = blackboard.getAnnotation(record, null, name);
        if (annotation == null) {
            annotation = blackboard.createAnnotation(record);
            blackboard.setAnnotation(record, null, name, annotation);
        }
        return annotation;
    }
}

