/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.TokenGroup;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.RecordFactory;

public class AnnotationFormatter
implements Formatter {
    private String _originalText;
    private ArrayList<Annotation> _highlightPositions;
    private RecordFactory _factory;

    public AnnotationFormatter(RecordFactory factory) {
        this._factory = factory;
    }

    public String highlightTerm(String originalText, TokenGroup tokenGroup) {
        int index = 0;
        while (index < tokenGroup.getNumTokens()) {
            Token token = tokenGroup.getToken(index);
            float score = tokenGroup.getScore(index);
            int startOffset = token.startOffset();
            int endOffset = token.endOffset();
            if (score > 0.0f) {
                Annotation highlightPos = this._factory.createAnnotation();
                highlightPos.setNamedValue("start", Integer.toString(startOffset));
                highlightPos.setNamedValue("end", Integer.toString(endOffset));
                highlightPos.setNamedValue("quality", Integer.toString(AnnotationFormatter.mapScore(score)));
                this._highlightPositions.add(highlightPos);
            }
            ++index;
        }
        return originalText;
    }

    public void reset(String originalText) {
        this._originalText = originalText;
        if (this._highlightPositions != null) {
            this._highlightPositions.clear();
        }
        this._highlightPositions = new ArrayList();
    }

    public List<Annotation> getHighlightPositions() {
        return this._highlightPositions;
    }

    public String getOriginalText() {
        return this._originalText;
    }

    private static int mapScore(float score) {
        return Math.round(score * 250.0f);
    }
}

