/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index.access;

import org.apache.lucene.search.IndexSearcher;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedCondition;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedOperation;
import org.eclipse.smila.search.lucene.index.access.SynchronizedAbstractExecutor;

public class SynchronizedIndexSearcherExecutor<ReturnedType>
extends SynchronizedAbstractExecutor<IndexSearcher, ReturnedType> {
    private final String _storage;
    private final IndexSearcherCondition _condition;

    public SynchronizedIndexSearcherExecutor(Object monitored, String storage) {
        super(monitored);
        this._storage = storage;
        this._condition = new IndexSearcherCondition();
    }

    @Override
    protected void close(IndexSearcher object) throws IndexException {
        try {
            object.close();
        }
        catch (Throwable e) {
            throw new IndexException("Unable to close IndexSearcher", e);
        }
    }

    @Override
    public ReturnedType execute(ISynchronizedOperation<IndexSearcher, ReturnedType> operation) throws IndexException {
        return this.execute(this._condition, operation);
    }

    private class IndexSearcherCondition
    implements ISynchronizedCondition<IndexSearcher> {
        private IndexSearcherCondition() {
        }

        @Override
        public IndexSearcher initialize() throws IndexException {
            try {
                return new IndexSearcher(SynchronizedIndexSearcherExecutor.this._storage);
            }
            catch (Exception e) {
                throw new IndexException((Throwable)e);
            }
        }
    }
}

