/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.indexstructure;

import org.eclipse.smila.search.lucene.messages.indexstructure.DAnalyzerCodec;
import org.eclipse.smila.search.lucene.messages.indexstructure.DIndexField;
import org.eclipse.smila.search.utils.indexstructure.ISException;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DIndexFieldCodec {
    private DIndexFieldCodec() {
    }

    protected static Element encode(DIndexField dIndexField, Element parent) throws ISException {
        if (parent == null) {
            throw new ISException("parameter must not be null [parent]");
        }
        if (dIndexField == null) {
            throw new ISException("parameter must not be null [dIndexField]");
        }
        Document doc = parent.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/IndexStructure", "IndexField");
        el.setAttribute("Name", dIndexField.getName());
        el.setAttribute("Type", dIndexField.getType());
        el.setAttribute("FieldNo", String.valueOf(dIndexField.getFieldNo()));
        el.setAttribute("StoreText", XMLUtils.encodeBoolean((boolean)dIndexField.getStoreText()));
        el.setAttribute("Tokenize", XMLUtils.encodeBoolean((boolean)dIndexField.getTokenize()));
        el.setAttribute("IndexValue", XMLUtils.encodeBoolean((boolean)dIndexField.getIndexValue()));
        if (dIndexField.getAnalyzer() != null) {
            DAnalyzerCodec.encode(dIndexField.getAnalyzer(), el);
        }
        parent.appendChild(el);
        return el;
    }

    public static DIndexField decode(Element element) throws ISException {
        if (element == null) {
            throw new ISException("parameter must not be null [element]");
        }
        DIndexField dIndexField = new DIndexField();
        dIndexField.setFieldNo(Integer.parseInt(element.getAttribute("FieldNo")));
        dIndexField.setName(element.getAttribute("Name"));
        dIndexField.setType(element.getAttribute("Type"));
        dIndexField.setTokenize(XMLUtils.decodeBoolean((String)element.getAttribute("Tokenize")));
        dIndexField.setIndexValue(XMLUtils.decodeBoolean((String)element.getAttribute("IndexValue")));
        dIndexField.setStoreText(XMLUtils.decodeBoolean((String)element.getAttribute("StoreText")));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element el;
            if (nl.item(i) instanceof Element && "Analyzer".equals((el = (Element)nl.item(i)).getLocalName())) {
                dIndexField.setAnalyzer(DAnalyzerCodec.decode(el));
            }
            ++i;
        }
        return dIndexField;
    }
}

