/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.integration.helloworld;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.SimplePipelet;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;

public class HelloWorldPipelet
implements SimplePipelet {
    private final String SOURCE_ATT = "source_attribute_name";
    private final String TARGET_ATT = "target_attribute_name";
    private String _sourceAttr = "";
    private String _targetAttr = "";
    private Log _log = LogFactory.getLog(HelloWorldPipelet.class);

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        Id[] idArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            Id id = idArray[n2];
            try {
                String inValue = "";
                String outValue = "";
                Path inPath = new Path(this._sourceAttr);
                Path outPath = new Path(this._targetAttr);
                if (blackboard.hasAttribute(id, inPath)) {
                    Literal inLiteral = blackboard.getLiteral(id, inPath);
                    inValue = inLiteral.getStringValue();
                }
                Literal outLiteral = RecordFactory.DEFAULT_INSTANCE.createLiteral();
                outValue = String.valueOf(inValue) + " --- Hello world!!!";
                outLiteral.setStringValue(outValue);
                blackboard.setLiteral(id, outPath, outLiteral);
            }
            catch (Exception e) {
                this._log.error((Object)("Error while calling HelloWorldPipelet for record: '" + id + "':" + e.getMessage()), (Throwable)e);
                throw new ProcessingException((Throwable)e);
            }
            ++n2;
        }
        return recordIds;
    }

    public void configure(PipeletConfiguration config) throws ProcessingException {
        this._sourceAttr = (String)config.getPropertyFirstValueNotNull("source_attribute_name");
        this._targetAttr = (String)config.getPropertyFirstValueNotNull("target_attribute_name");
    }
}

