/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.search.api.helper.RecordAccessor;

public class AnnotationListAccessor {
    private String _attributeName;
    private List<Annotation> _annotations;

    public AnnotationListAccessor(String attributeName, List<Annotation> annotations) {
        this._attributeName = attributeName;
        this._annotations = annotations;
    }

    public AnnotationListAccessor(String attributeName, Collection<Annotation> annotations) {
        this._attributeName = attributeName;
        this._annotations = RecordAccessor.unmodifiableList(annotations);
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public int length() {
        if (this._annotations == null) {
            return 0;
        }
        return this._annotations.size();
    }

    public Annotation getAnnotation(int index, String name) {
        if (index >= 0 && index < this.length()) {
            return this._annotations.get(index).getAnnotation(name);
        }
        return null;
    }

    public List<Annotation> getAnnotations(int index, String name) {
        if (index >= 0 && index < this.length()) {
            Collection subAnnotations = this._annotations.get(index).getAnnotations(name);
            return RecordAccessor.unmodifiableList(subAnnotations);
        }
        return Collections.EMPTY_LIST;
    }

    public String getProperty(int index, String name) {
        if (index >= 0 && index < this.length()) {
            return this._annotations.get(index).getNamedValue(name);
        }
        return null;
    }

    public Integer getIntProperty(int index, String name) {
        String value = this.getProperty(index, name);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Double getFloatProperty(int index, String name) {
        String value = this.getProperty(index, name);
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public List<Annotation> getSource() {
        return this._annotations;
    }
}

