/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.search.api.helper.Terms;

public class RecordAccessor {
    private Record _record;

    public RecordAccessor(Record record) {
        this._record = record;
    }

    public boolean hasAttribute(String attributeName) {
        return this._record.getMetadata().hasAttribute(attributeName);
    }

    public boolean hasLiterals(String attributeName) {
        if (this.hasAttribute(attributeName)) {
            return this._record.getMetadata().getAttribute(attributeName).hasLiterals();
        }
        return false;
    }

    public int literalSize(String attributeName) {
        if (this.hasAttribute(attributeName)) {
            return this._record.getMetadata().getAttribute(attributeName).literalSize();
        }
        return 0;
    }

    public Literal getLiteral(String attributeName) {
        if (this.hasAttribute(attributeName)) {
            return this._record.getMetadata().getAttribute(attributeName).getLiteral();
        }
        return null;
    }

    public List<Literal> getLiterals(String attributeName) {
        if (this.hasAttribute(attributeName)) {
            return Collections.unmodifiableList(this._record.getMetadata().getAttribute(attributeName).getLiterals());
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasAnnotation(String annotationName) {
        return this._record.getMetadata().hasAnnotation(annotationName);
    }

    public int annotationSize(String annotationName) {
        if (this.hasAnnotation(annotationName)) {
            return this._record.getMetadata().getAnnotations(annotationName).size();
        }
        return 0;
    }

    public Annotation getAnnotation(String annotationName) {
        return this._record.getMetadata().getAnnotation(annotationName);
    }

    public List<Annotation> getAnnotations(String annotationName) {
        Collection annotations = this._record.getMetadata().getAnnotations(annotationName);
        return RecordAccessor.unmodifiableList(annotations);
    }

    public String getAnnotationValue(String annotationName, String valueName) {
        Annotation annotation = this._record.getMetadata().getAnnotation(annotationName);
        if (annotation != null) {
            return annotation.getNamedValue(valueName);
        }
        return null;
    }

    public List<String> getAnnotationValues(String annotationName) {
        Annotation annotation = this._record.getMetadata().getAnnotation(annotationName);
        if (annotation != null) {
            Collection values = annotation.getAnonValues();
            return RecordAccessor.unmodifiableList(values);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasAnnotation(String attributeName, String annotationName) {
        if (this.hasAttribute(attributeName)) {
            return this._record.getMetadata().getAttribute(attributeName).hasAnnotation(annotationName);
        }
        return false;
    }

    public int annotationSize(String attributeName, String annotationName) {
        if (this.hasAnnotation(attributeName, annotationName)) {
            return this._record.getMetadata().getAttribute(attributeName).getAnnotations(annotationName).size();
        }
        return 0;
    }

    public Annotation getAnnotation(String attributeName, String annotationName) {
        if (this.hasAttribute(attributeName)) {
            return this._record.getMetadata().getAttribute(attributeName).getAnnotation(annotationName);
        }
        return null;
    }

    public List<Annotation> getAnnotations(String attributeName, String annotationName) {
        if (this.hasAnnotation(attributeName, annotationName)) {
            Collection annotations = this._record.getMetadata().getAttribute(attributeName).getAnnotations(annotationName);
            return RecordAccessor.unmodifiableList(annotations);
        }
        return Collections.EMPTY_LIST;
    }

    public Terms getTerms(String attributeName) {
        return new Terms(attributeName, this.getAnnotations(attributeName, "terms"));
    }

    public Record getRecord() {
        return this._record;
    }

    public String getResultAnnotationValue(String valueName) {
        return this.getAnnotationValue("result", valueName);
    }

    public Integer getResultAnnotationIntValue(String valueName) {
        String value = this.getResultAnnotationValue(valueName);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Double getResultAnnotationFloatValue(String valueName) {
        String value = this.getResultAnnotationValue(valueName);
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static <T> List<T> unmodifiableList(Collection<? extends T> collection) {
        ArrayList<T> list = null;
        if (collection == null) {
            return Collections.EMPTY_LIST;
        }
        list = collection instanceof List ? (ArrayList<T>)collection : new ArrayList<T>(collection);
        return Collections.unmodifiableList(list);
    }
}

