/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import org.eclipse.smila.search.api.SearchResult;
import org.eclipse.smila.search.api.helper.QueryBuilder;
import org.eclipse.smila.search.api.helper.QueryRecordAccessor;
import org.eclipse.smila.search.api.helper.ResultRecordAccessor;

public class ResultAccessor {
    private SearchResult _result;

    public ResultAccessor(SearchResult result) {
        this._result = result;
    }

    public SearchResult getResult() {
        return this._result;
    }

    public String getWorkflowName() {
        return this._result.getWorkflowName();
    }

    public boolean hasQuery() {
        return this._result.getQuery() != null;
    }

    public QueryRecordAccessor getQuery() {
        if (this.hasQuery()) {
            return new QueryRecordAccessor(this._result.getQuery());
        }
        return null;
    }

    public boolean hasRecords() {
        return this._result.getRecords() != null;
    }

    public int recordsSize() {
        if (this.hasRecords()) {
            return this._result.getRecords().length;
        }
        return 0;
    }

    public ResultRecordAccessor getResultRecord(int index) {
        if (index >= 0 && index < this.recordsSize()) {
            return new ResultRecordAccessor(this._result.getRecords()[index]);
        }
        return null;
    }

    public QueryBuilder newQueryBuilder() {
        QueryBuilder builder = new QueryBuilder(this.getWorkflowName(), this._result.getQuery());
        return builder;
    }

    public QueryBuilder newQueryBuilder(String recordFilterName) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

