/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.internal;

import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.IdFactory;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.SearchMessage;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.search.api.SearchResult;
import org.eclipse.smila.search.api.SearchService;
import org.eclipse.smila.search.api.internal.ResultDocumentBuilder;
import org.eclipse.smila.search.api.internal.SearchResultImpl;
import org.eclipse.smila.utils.xml.XmlHelper;
import org.osgi.service.component.ComponentContext;
import org.w3c.dom.Document;

public class SearchServiceImpl
implements SearchService {
    private static final long NANO_TO_MILLIS = 1000000L;
    private final Log _log = LogFactory.getLog(this.getClass());
    private WorkflowProcessor _processor;
    private BlackboardFactory _blackboardFactory;
    private ResultDocumentBuilder _resultBuilder = new ResultDocumentBuilder();

    public SearchServiceImpl() {
        this._log.debug((Object)"instance created.");
    }

    @Override
    public SearchResult search(String workflowName, Record query) throws ProcessingException {
        try {
            long starttime = System.nanoTime();
            this.ensureQueryId(workflowName, query);
            SearchResultImpl result = new SearchResultImpl(workflowName, query);
            Blackboard blackboard = this._blackboardFactory.createTransientBlackboard();
            blackboard.setRecord(query);
            SearchMessage message = new SearchMessage(query.getId(), null);
            message = this._processor.process(workflowName, blackboard, message);
            if (message.hasQuery()) {
                result.setQuery(blackboard.getRecord(message.getQuery()));
            }
            if (message.hasRecords()) {
                Id[] ids = message.getRecords();
                Record[] records = new Record[ids.length];
                int i = 0;
                while (i < ids.length) {
                    records[i] = blackboard.getRecord(ids[i]);
                    ++i;
                }
                result.setRecords(records);
            }
            long endtime = System.nanoTime();
            this.setRuntime(blackboard, message.getQuery(), endtime - starttime);
            blackboard.invalidate();
            return result;
        }
        catch (BlackboardAccessException ex) {
            throw new ProcessingException("Blackboard error: ", (Throwable)ex);
        }
    }

    @Override
    public Document searchAsXml(String workflowName, Record query) throws ParserConfigurationException {
        Document resultDoc = null;
        try {
            SearchResult result = this.search(workflowName, query);
            resultDoc = this._resultBuilder.buildResult(result);
        }
        catch (ProcessingException ex) {
            resultDoc = this._resultBuilder.buildError((Exception)((Object)ex));
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"XML result:");
            this._log.debug((Object)XmlHelper.toString((Document)resultDoc));
        }
        return resultDoc;
    }

    @Override
    public String searchAsXmlString(String workflowName, Record query) throws ParserConfigurationException {
        Document result = this.searchAsXml(workflowName, query);
        return XmlHelper.toString((Document)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureQueryId(String workflowName, Record query) {
        if (query.getId() == null) {
            UUID uuid = null;
            SearchServiceImpl searchServiceImpl = this;
            synchronized (searchServiceImpl) {
                uuid = UUID.randomUUID();
            }
            Id id = IdFactory.DEFAULT_INSTANCE.createId(workflowName, uuid.toString());
            query.setId(id);
        }
    }

    protected void activate(ComponentContext context) {
        this._log.debug((Object)"activating");
        this._log.info((Object)"active!");
    }

    protected void deactivate(ComponentContext context) {
        this._log.debug((Object)"deactivating");
        this._log.info((Object)"inactive!");
    }

    public void setProcessor(WorkflowProcessor processor) {
        this._log.debug((Object)"setting processor reference.");
        this._processor = processor;
    }

    public void unsetProcessor(WorkflowProcessor processor) {
        if (this._processor == processor) {
            this._log.debug((Object)"unsetting processor reference.");
            this._processor = null;
        }
    }

    public void setBlackboardFactory(BlackboardFactory factory) {
        this._log.debug((Object)"setting blackboard factory.");
        this._blackboardFactory = factory;
    }

    public void unsetBlackboardFactory(BlackboardFactory factory) {
        if (this._blackboardFactory == factory) {
            this._log.debug((Object)"unsetting blackboard factory.");
            this._blackboardFactory = null;
        }
    }

    private void setRuntime(Blackboard blackboard, Id record, long runtime) throws BlackboardAccessException {
        long msRuntime = runtime / 1000000L;
        Annotation resultAnno = this.ensureResultAnnotation(blackboard, record);
        resultAnno.setNamedValue("runtime", Long.toString(msRuntime));
    }

    private Annotation ensureResultAnnotation(Blackboard blackboard, Id record) throws BlackboardAccessException {
        Annotation annotation = blackboard.getAnnotation(record, null, "result");
        if (annotation == null) {
            annotation = blackboard.createAnnotation(record);
            blackboard.setAnnotation(record, null, "result", annotation);
        }
        return annotation;
    }
}

