/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import java.util.List;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.ontology.pipelets.ASesameRecordPipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class CreateResourcePipelet
extends ASesameRecordPipelet {
    public static final String PARAM_LABELATTRIBUTE = "labelAttribute";
    public static final String PARAM_URIATTRIBUTE = "uriAttribute";
    public static final String PARAM_LABELPREDICATE = "labelPredicate";
    public static final String PARAM_TYPEURI = "typeUri";
    public static final String PARAM_URIPREFIX = "uriPrefix";

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null && recordIds.length > 0) {
            try {
                ParameterAccessor parameters = this.getParameters(blackboard);
                Id[] idArray = recordIds;
                int n = recordIds.length;
                int n2 = 0;
                while (n2 < n) {
                    Id id = idArray[n2];
                    parameters.setCurrentRecord(id);
                    RepositoryConnection connection = this.getRepositoryConnection(parameters);
                    try {
                        try {
                            String labelAttribute = parameters.getRequiredParameter(PARAM_LABELATTRIBUTE);
                            Path labelPath = new Path().add(labelAttribute);
                            String uriAttribute = parameters.getRequiredParameter(PARAM_URIATTRIBUTE);
                            Path uriPath = new Path().add(uriAttribute);
                            String typeUriString = parameters.getRequiredParameter(PARAM_TYPEURI);
                            URI typeUri = this.createUri(connection, typeUriString);
                            String labelPredicateString = parameters.getParameter(PARAM_LABELPREDICATE, RDFS.LABEL.stringValue());
                            URI labelPredicate = this.createUri(connection, labelPredicateString);
                            String uriPrefix = parameters.getParameter(PARAM_URIPREFIX, "urn:");
                            if (blackboard.getLiteralsSize(id, labelPath) > 0) {
                                List labels = blackboard.getLiterals(id, labelPath);
                                for (Literal literal : labels) {
                                    String value = literal.getStringValue();
                                    URI resource = this.findExistingResource(value, labelPredicate, typeUri, connection);
                                    if (resource == null) {
                                        resource = this.createResource(value, labelPredicate, typeUri, uriPrefix, connection);
                                    }
                                    this.writeUriToAttribute(blackboard, id, uriPath, resource);
                                }
                            }
                            connection.commit();
                        }
                        catch (Exception ex) {
                            throw new ProcessingException("error creating a resourse", (Throwable)ex);
                        }
                    }
                    finally {
                        connection.close();
                    }
                    ++n2;
                }
            }
            catch (RepositoryException ex) {
                throw new ProcessingException("could not get connection to sesame repository", (Throwable)ex);
            }
        }
        return recordIds;
    }

    private URI findExistingResource(String value, URI labelPredicate, URI typeUri, RepositoryConnection connection) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String sparql = this.createSparql(value, labelPredicate, typeUri);
        TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, sparql);
        TupleQueryResult result = query.evaluate();
        URI resource = null;
        if (result.hasNext()) {
            BindingSet binding = (BindingSet)result.next();
            String varName = (String)binding.getBindingNames().iterator().next();
            resource = (URI)binding.getValue(varName);
        }
        result.close();
        return resource;
    }

    private String createSparql(String value, URI labelPredicate, URI typeUri) {
        StringBuilder sparql = new StringBuilder("SELECT ?r ");
        sparql.append("{?r <").append(RDF.TYPE).append("> <").append(typeUri.stringValue()).append("> . ");
        sparql.append("?r <").append(labelPredicate.stringValue()).append("> \"").append(value).append("\" }");
        return sparql.toString();
    }

    private URI createResource(String value, URI labelPredicate, URI typeUri, String uriPrefix, RepositoryConnection connection) throws RepositoryException {
        String uriName = value.replaceAll("\\W", "");
        String uriString = String.valueOf(uriPrefix) + uriName;
        URI uri = this._valueHelper.createUri(connection, uriString);
        connection.add((Resource)uri, RDF.TYPE, (Value)typeUri, new Resource[0]);
        connection.add((Resource)uri, labelPredicate, (Value)connection.getValueFactory().createLiteral(value), new Resource[0]);
        connection.commit();
        return uri;
    }

    private Literal writeUriToAttribute(Blackboard blackboard, Id id, Path uriPath, URI resource) throws BlackboardAccessException {
        Literal uriLiteral = blackboard.createLiteral(id);
        uriLiteral.setStringValue(resource.stringValue());
        uriLiteral.setSemanticType("rdfs:Resource");
        blackboard.addLiteral(id, uriPath, uriLiteral);
        return uriLiteral;
    }
}

