/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.records;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.ontology.records.SesameRecordHelper;
import org.eclipse.smila.ontology.records.SesameValueHelper;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class SesameRecordWriter {
    private final Log _log = LogFactory.getLog(this.getClass());
    private RepositoryConnection _repoConn;
    private Collection<Statement> _addStmts;
    private Collection<Statement> _clearStmts;
    private SesameValueHelper _valueHelper = SesameValueHelper.INSTANCE;

    public SesameRecordWriter(RepositoryConnection repoConn) {
        this._repoConn = repoConn;
    }

    public URI writeBlackboardRecord(Blackboard blackboard, Id id, String defaultTypeUri) throws BlackboardAccessException, RepositoryException {
        Record record = blackboard.getRecord(id);
        return this.writeRecord(record, defaultTypeUri);
    }

    public URI writeRecord(Record record, String defaultTypeUri) throws RepositoryException {
        boolean commit = false;
        try {
            Annotation annotation;
            this._repoConn.setAutoCommit(false);
            URI uri = this.findUri(record);
            MObject metadata = record.getMetadata();
            if (metadata.hasAnnotation("org.eclipse.smila.ontology") && (annotation = SesameRecordHelper.getModeAnnotation((Annotatable)metadata)).getNamedValue("clear") != null) {
                this.clearResource(uri);
                commit = true;
                URI uRI = uri;
                return uRI;
            }
            this._addStmts = new ArrayList<Statement>();
            this._clearStmts = new ArrayList<Statement>();
            Iterator attributeNames = metadata.getAttributeNames();
            while (attributeNames.hasNext()) {
                String attributeName = (String)attributeNames.next();
                if ("rdf:about".equals(attributeName)) continue;
                this.createStatements(uri, metadata, attributeName, defaultTypeUri);
            }
            if (!this._addStmts.isEmpty()) {
                for (Statement stmt : this._clearStmts) {
                    this._repoConn.remove(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), new Resource[0]);
                }
                for (Statement stmt : this._addStmts) {
                    try {
                        this._log.debug((Object)("adding stmt: " + stmt));
                        this._repoConn.add(stmt, new Resource[0]);
                    }
                    catch (Exception ex) {
                        this._log.error((Object)"failed to add a stmt", (Throwable)ex);
                    }
                }
                commit = true;
            }
            URI uRI = uri;
            return uRI;
        }
        finally {
            this._addStmts = null;
            this._clearStmts = null;
            if (commit) {
                this._repoConn.commit();
            } else {
                this._repoConn.rollback();
            }
        }
    }

    private void clearResource(URI uri) throws RepositoryException {
        this._repoConn.remove(null, null, (Value)uri, new Resource[0]);
        this._repoConn.remove((Resource)uri, null, null, new Resource[0]);
    }

    private void createStatements(URI uri, MObject metadata, String attributeName, String defaultTypeUri) {
        Attribute attribute = metadata.getAttribute(attributeName);
        URI predicate = this._valueHelper.createUri(this._repoConn, attributeName);
        Annotation annotation = null;
        boolean isReverse = false;
        boolean haveTypeStatement = false;
        if (attribute.hasAnnotation("org.eclipse.smila.ontology") && (annotation = SesameRecordHelper.getModeAnnotation((Annotatable)attribute)).hasAnonValues()) {
            isReverse = annotation.getAnonValues().contains("reverse");
        }
        this.addClearStatement((Resource)uri, predicate, annotation, isReverse);
        if (attribute.hasLiterals()) {
            List literals = attribute.getLiterals();
            int position = 0;
            for (Literal literal : literals) {
                URI value = null;
                if (RDF.TYPE.equals((Object)predicate)) {
                    value = this._valueHelper.createUri(this._repoConn, literal);
                    haveTypeStatement = true;
                } else {
                    value = this._valueHelper.createValue(this._repoConn, literal);
                }
                if (isReverse && value instanceof URI) {
                    this._addStmts.add(this._repoConn.getValueFactory().createStatement((Resource)value, predicate, (Value)uri));
                } else {
                    this._addStmts.add(this._repoConn.getValueFactory().createStatement((Resource)uri, predicate, (Value)value));
                }
                ++position;
            }
        }
        if (!haveTypeStatement && defaultTypeUri != null) {
            URI defaultType = this._valueHelper.createUri(this._repoConn, defaultTypeUri);
            this._addStmts.add(this._repoConn.getValueFactory().createStatement((Resource)uri, RDF.TYPE, (Value)defaultType));
        }
    }

    private void addClearStatement(Resource uri, URI predicate, Annotation annotation, boolean isReverse) {
        String clearLocale;
        if (annotation != null && (clearLocale = annotation.getNamedValue("clear")) != null) {
            if (isReverse) {
                this._clearStmts.add(this._repoConn.getValueFactory().createStatement(null, predicate, (Value)uri));
            } else {
                this._clearStmts.add(this._repoConn.getValueFactory().createStatement(uri, predicate, null));
            }
        }
    }

    private URI findUri(Record record) throws RepositoryException {
        URI uri = null;
        if (record.getMetadata().hasAttribute("rdf:about")) {
            Literal uriLiteral = record.getMetadata().getAttribute("rdf:about").getLiteral();
            if (uriLiteral != null) {
                uri = this._valueHelper.createUri(this._repoConn, uriLiteral);
            }
        } else {
            Id id = record.getId();
            uri = this._valueHelper.createUri(this._repoConn, id.getKey().getKey());
        }
        if (uri == null) {
            throw new RepositoryException("did not find a resource URI for record.");
        }
        return uri;
    }
}

