/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evar.IncompleteKeyException;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStartedEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.extension.ExtensionOperation;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.rapi.CorrelationSet;
import org.apache.ode.bpel.rapi.FaultInfo;
import org.apache.ode.bpel.rapi.NoSuchOperationException;
import org.apache.ode.bpel.rapi.OdeRTInstance;
import org.apache.ode.bpel.rapi.OdeRTInstanceContext;
import org.apache.ode.bpel.rapi.PartnerLink;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.bpel.rapi.UninitializedPartnerEPR;
import org.apache.ode.bpel.rapi.UninitializedVariableException;
import org.apache.ode.bpel.rapi.Variable;
import org.apache.ode.bpel.rapi.VariableContext;
import org.apache.ode.bpel.rtrep.v1.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v1.CorrelationSetInstance;
import org.apache.ode.bpel.rtrep.v1.ExpressionLanguageRuntimeRegistry;
import org.apache.ode.bpel.rtrep.v1.Messages;
import org.apache.ode.bpel.rtrep.v1.OElementVarType;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OPartnerLink;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v1.OutstandingRequestManager;
import org.apache.ode.bpel.rtrep.v1.PROCESS;
import org.apache.ode.bpel.rtrep.v1.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v1.PropertyAliasEvaluationContext;
import org.apache.ode.bpel.rtrep.v1.RuntimeImpl;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.Selector;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.ActivityRecoveryChannel;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.bpel.rtrep.v1.channels.InvokeResponseChannel;
import org.apache.ode.bpel.rtrep.v1.channels.PickResponseChannel;
import org.apache.ode.bpel.rtrep.v1.channels.TimerResponseChannel;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.soup.ExecutionQueue;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeInstanceImpl
implements OdeInternalInstance,
OdeRTInstance {
    private static final Log __log = LogFactory.getLog(RuntimeInstanceImpl.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private OdeRTInstanceContext _brc;
    protected JacobVPU _vpu;
    protected ExecutionQueueImpl _soup;
    private RuntimeImpl _runtime;

    public RuntimeInstanceImpl(RuntimeImpl runtimeImpl, ExecutionQueueImpl executionQueueImpl) {
        this._runtime = runtimeImpl;
        this._vpu = new JacobVPU();
        this._vpu.registerExtension(OdeRTInstanceContext.class, (Object)this);
        if (executionQueueImpl == null) {
            this._soup = new ExecutionQueueImpl(this.getClass().getClassLoader());
            this._soup.setGlobalData((Serializable)new OutstandingRequestManager());
        } else {
            this._soup = executionQueueImpl;
        }
        this._soup.setReplacementMap(this._runtime._replacementMap);
        this._vpu.setContext((ExecutionQueue)this._soup);
    }

    public ProcessModel getProcessModel() {
        return this._runtime._oprocess;
    }

    @Override
    public boolean isCorrelationInitialized(CorrelationSetInstance correlationSetInstance) {
        return this._brc.isCorrelationInitialized((CorrelationSet)correlationSetInstance);
    }

    @Override
    public boolean isVariableInitialized(VariableInstance variableInstance) {
        return this._brc.isVariableInitialized((Variable)variableInstance);
    }

    @Override
    public boolean isPartnerRoleEndpointInitialized(PartnerLinkInstance partnerLinkInstance) {
        return this._brc.isPartnerRoleEndpointInitialized((PartnerLink)partnerLinkInstance);
    }

    @Override
    public void completedFault(FaultData faultData) {
        this.cleanupOutstandingMyRoleExchanges(faultData);
        this._brc.completedFault((FaultInfo)faultData);
    }

    @Override
    public void completedOk() {
        this.cleanupOutstandingMyRoleExchanges(null);
        this._brc.completedOk();
    }

    public Long createScopeInstance(Long l, String string, int n) {
        return this._brc.createScopeInstance(l, string, n);
    }

    @Override
    public void initializePartnerLinks(Long l, Collection<OPartnerLink> collection) {
        this._brc.initializePartnerLinks(l, collection);
    }

    @Override
    public void cancelOutstandingRequests(String string) {
        this.getORM().cancel(string);
    }

    @Override
    public void select(PickResponseChannel pickResponseChannel, Date date, boolean bl, Selector[] selectorArray) throws FaultException {
        String string = pickResponseChannel.export();
        int n = this.getORM().findConflict(selectorArray);
        if (n != -1) {
            throw new FaultException(this._runtime._oprocess.constants.qnConflictingReceive, selectorArray[n].toString());
        }
        this.getORM().register(string, selectorArray);
        this._brc.select(string, date, (org.apache.ode.bpel.rapi.Selector[])selectorArray);
    }

    @Override
    public CorrelationKey readCorrelation(CorrelationSetInstance correlationSetInstance) {
        return this._brc.readCorrelation((CorrelationSet)correlationSetInstance);
    }

    @Override
    public Node fetchVariableData(VariableInstance variableInstance, ScopeFrame scopeFrame, boolean bl) throws FaultException {
        if (variableInstance.declaration.extVar != null) {
            Element element = (Element)this._brc.fetchVariableData((Variable)scopeFrame.resolve(variableInstance.declaration.extVar.related), false);
            try {
                Node node = this._brc.readExtVar((Variable)variableInstance, (Node)element);
                if (node == null) {
                    throw new FaultException(this._runtime._oprocess.constants.qnUninitializedVariable, "The external variable \"" + variableInstance.declaration.name + "\" has not been initialized.");
                }
                return node;
            }
            catch (IncompleteKeyException incompleteKeyException) {
                __log.error((Object)("External variable could not be read due to incomplete key; the following key components were missing: " + incompleteKeyException.getMissing()));
                throw new FaultException(this._runtime._oprocess.constants.qnUninitializedVariable, "The extenral variable \"" + variableInstance.declaration.name + "\" has not been properly initialized;" + "the following key compoenents were missing:" + incompleteKeyException.getMissing());
            }
            catch (ExternalVariableModuleException externalVariableModuleException) {
                throw new BpelEngineException((Throwable)externalVariableModuleException);
            }
        }
        Node node = this._brc.fetchVariableData((Variable)variableInstance, bl);
        if (node == null) {
            if (variableInstance.declaration.type instanceof OMessageVarType) {
                OMessageVarType oMessageVarType = (OMessageVarType)variableInstance.declaration.type;
                if (oMessageVarType.parts.size() == 0) {
                    Document document = DOMUtils.newDocument();
                    Element element = document.createElement("message");
                    document.appendChild(element);
                    return element;
                }
            }
            throw new FaultException(this._runtime._oprocess.constants.qnUninitializedVariable, "The variable " + variableInstance.declaration.name + " isn't properly initialized.");
        }
        return node;
    }

    @Override
    public Node fetchVariableData(VariableInstance variableInstance, ScopeFrame scopeFrame, OMessageVarType.Part part, boolean bl) throws FaultException {
        Node node = this.fetchVariableData(variableInstance, scopeFrame, bl);
        if (part != null) {
            return this.getPartData((Element)node, part);
        }
        return node;
    }

    @Override
    public void writeCorrelation(CorrelationSetInstance correlationSetInstance, CorrelationKey correlationKey) throws FaultException {
        OScope.CorrelationSet correlationSet = correlationSetInstance.declaration;
        QName[] qNameArray = new QName[correlationSet.properties.size()];
        for (int i = 0; i < correlationSet.properties.size(); ++i) {
            OProcess.OProperty oProperty = correlationSet.properties.get(i);
            qNameArray[i] = oProperty.name;
        }
        correlationKey.setUnique(correlationSetInstance.declaration.isUnique());
        this._brc.writeCorrelation((CorrelationSet)correlationSetInstance, qNameArray, correlationKey);
    }

    @Override
    public void sendEvent(ScopeEvent scopeEvent) {
        this._brc.sendEvent((ProcessInstanceEvent)scopeEvent);
    }

    @Override
    public void unregisterActivityForRecovery(ActivityRecoveryChannel activityRecoveryChannel) {
        this._brc.unregisterActivityForRecovery(activityRecoveryChannel.export());
    }

    @Override
    public void registerActivityForRecovery(ActivityRecoveryChannel activityRecoveryChannel, long l, String string, Date date, Element element, String[] stringArray, int n) {
        this._brc.registerActivityForRecovery(activityRecoveryChannel.export(), l, string, date, element, stringArray, n);
    }

    @Override
    public void registerTimer(TimerResponseChannel timerResponseChannel, Date date) {
        this._brc.registerTimer(timerResponseChannel.export(), date);
    }

    @Override
    public String readProperty(VariableInstance variableInstance, OProcess.OProperty oProperty) throws FaultException {
        try {
            return this._brc.readVariableProperty((Variable)variableInstance, oProperty.name);
        }
        catch (UninitializedVariableException uninitializedVariableException) {
            throw new FaultException(this._runtime._oprocess.constants.qnUninitializedVariable);
        }
    }

    @Override
    public long genId() {
        return this._brc.genId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node initializeVariable(VariableInstance variableInstance, ScopeFrame scopeFrame, Node node) throws ExternalVariableModuleException {
        try {
            if (variableInstance.declaration.extVar != null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Initialize external variable: name=" + variableInstance.declaration + " value=" + DOMUtils.domToString((Node)node)));
                }
                Node node2 = null;
                try {
                    node2 = this.fetchVariableData(variableInstance, scopeFrame, true);
                }
                catch (FaultException faultException) {
                    // empty catch block
                }
                if (node2 != null) {
                    node = this._brc.readExtVar((Variable)variableInstance, node2);
                }
                Node node3 = node;
                return node3;
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Initialize variable: name=" + variableInstance.declaration + " value=" + DOMUtils.domToString((Node)node)));
            }
            Node node4 = this._brc.initializeVariable((Variable)variableInstance, node);
            return node4;
        }
        finally {
            this.writeProperties(variableInstance, node);
        }
    }

    @Override
    public Node fetchMyRoleEndpointReferenceData(PartnerLinkInstance partnerLinkInstance) {
        return this._brc.fetchMyRoleEndpointReferenceData((PartnerLink)partnerLinkInstance);
    }

    @Override
    public Node fetchPartnerRoleEndpointReferenceData(PartnerLinkInstance partnerLinkInstance) throws FaultException {
        Element element = this._brc.fetchPartnerRoleEndpointReferenceData((PartnerLink)partnerLinkInstance);
        if (element == null) {
            throw new FaultException(this._runtime._oprocess.constants.qnUninitializedPartnerRole);
        }
        return element;
    }

    @Override
    public Node convertEndpointReference(Element element, Node node) {
        return this._brc.convertEndpointReference(element, node);
    }

    @Override
    public void commitChanges(VariableInstance variableInstance, ScopeFrame scopeFrame, Node node) throws ExternalVariableModuleException {
        if (variableInstance.declaration.extVar != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Write external variable: name=" + variableInstance.declaration + " value=" + DOMUtils.domToString((Node)node)));
            }
            VariableInstance variableInstance2 = scopeFrame.resolve(variableInstance.declaration.extVar.related);
            Node node2 = null;
            try {
                node2 = this.fetchVariableData(variableInstance, scopeFrame, true);
            }
            catch (FaultException faultException) {
                // empty catch block
            }
            VariableContext.ValueReferencePair valueReferencePair = this._brc.writeExtVar((Variable)variableInstance, node2, node);
            this.commitChanges(variableInstance2, scopeFrame, valueReferencePair.reference);
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Write variable: name=" + variableInstance.declaration + " value=" + DOMUtils.domToString((Node)node)));
            }
            this._brc.commitChanges((Variable)variableInstance, node);
        }
        this.writeProperties(variableInstance, node);
    }

    @Override
    public void writeEndpointReference(PartnerLinkInstance partnerLinkInstance, Element element) {
        this._brc.writeEndpointReference((PartnerLink)partnerLinkInstance, element);
    }

    @Override
    public Long createScopeInstance(Long l, OScope oScope) {
        return this._brc.createScopeInstance(l, oScope.name, oScope.getId());
    }

    @Override
    public String fetchMySessionId(PartnerLinkInstance partnerLinkInstance) {
        return this._brc.fetchMySessionId((PartnerLink)partnerLinkInstance);
    }

    @Override
    public void cancel(PickResponseChannel pickResponseChannel) {
        final String string = pickResponseChannel.export();
        this._brc.cancelSelect(string);
        this.getORM().cancel(string);
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 6157913683737696396L;

            public void run() {
                TimerResponseChannel timerResponseChannel = (TimerResponseChannel)1.importChannel((String)string, TimerResponseChannel.class);
                timerResponseChannel.onCancel();
            }
        });
    }

    @Override
    public Element getMyRequest(String string) {
        return this._brc.getMyRequest(string);
    }

    @Override
    public void initializePartnersSessionId(PartnerLinkInstance partnerLinkInstance, String string) {
        this._brc.initializePartnersSessionId((PartnerLink)partnerLinkInstance, string);
    }

    @Override
    public String getSourceSessionId(String string) {
        return this._brc.getSourceSessionId(string);
    }

    @Override
    public Node getSourceEPR(String string) {
        return this._brc.getSourceEPR(string);
    }

    @Override
    public ExtensionOperation createExtensionActivityImplementation(QName qName) {
        if (qName == null) {
            return null;
        }
        ExtensionBundleRuntime extensionBundleRuntime = this._runtime._extensionRegistry.get(qName.getNamespaceURI());
        if (extensionBundleRuntime == null) {
            return null;
        }
        try {
            return extensionBundleRuntime.getExtensionOperationInstance(qName.getLocalPart());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Long getPid() {
        return this._brc.getPid();
    }

    @Override
    public Element getPartnerResponse(String string) {
        return this._brc.getPartnerResponse(string);
    }

    @Override
    public void releasePartnerMex(String string) {
        this._brc.releasePartnerMex(string);
    }

    @Override
    public QName getPartnerFault(String string) {
        return this._brc.getPartnerFault(string);
    }

    @Override
    public QName getPartnerResponseType(String string) {
        return this._brc.getPartnerResponseType(string);
    }

    @Override
    public String getPartnerFaultExplanation(String string) {
        return this._brc.getPartnerFaultExplanation(string);
    }

    @Override
    public void sendEvent(ProcessInstanceStartedEvent processInstanceStartedEvent) {
        this._brc.sendEvent((ProcessInstanceEvent)processInstanceStartedEvent);
    }

    @Override
    public void reply(PartnerLinkInstance partnerLinkInstance, String string, String string2, Element element, QName qName) throws FaultException {
        String string3 = this.getORM().release(partnerLinkInstance, string, string2);
        if (string3 == null) {
            throw new FaultException(this._runtime._oprocess.constants.qnMissingRequest);
        }
        try {
            this._brc.reply(string3, (PartnerLink)partnerLinkInstance, string, element, qName);
        }
        catch (NoSuchOperationException noSuchOperationException) {
            throw new FaultException(this._runtime._oprocess.constants.qnMissingRequest, "Undefined two-way operation \"" + string + "\".");
        }
    }

    @Override
    public void forceFlush() {
        this._brc.forceFlush();
    }

    @Override
    public void terminate() {
        this.cleanupOutstandingMyRoleExchanges(null);
        this._brc.terminate();
    }

    private void writeProperties(VariableInstance variableInstance, Node node) {
        if (variableInstance.declaration.type instanceof OMessageVarType) {
            for (OProcess.OProperty oProperty : variableInstance.declaration.getOwner().properties) {
                OProcess.OPropertyAlias oPropertyAlias = oProperty.getAlias(variableInstance.declaration.type);
                if (oPropertyAlias == null) continue;
                try {
                    String string = this.extractProperty((Element)node, oPropertyAlias, variableInstance.declaration.getDescription());
                    if (string == null) continue;
                    this._brc.writeVariableProperty((Variable)variableInstance, oProperty.name, string);
                }
                catch (UninitializedVariableException uninitializedVariableException) {
                    __log.fatal((Object)("Couldn't extract property '" + oProperty.toString() + "' in property pre-extraction: " + (Object)((Object)uninitializedVariableException)));
                    throw new RuntimeException(uninitializedVariableException);
                }
                catch (FaultException faultException) {
                    if (!__log.isDebugEnabled()) continue;
                    __log.debug((Object)("Couldn't extract property '" + oProperty.toString() + "' in property pre-extraction: " + faultException.toString()));
                }
            }
        }
    }

    String extractProperty(Element element, OProcess.OPropertyAlias oPropertyAlias, String string) throws FaultException {
        PropertyAliasEvaluationContext propertyAliasEvaluationContext = new PropertyAliasEvaluationContext(element, oPropertyAlias);
        Node node = propertyAliasEvaluationContext.getRootNode();
        if (oPropertyAlias.location != null) {
            node = this._runtime._expLangRuntimeRegistry.evaluateNode(oPropertyAlias.location, propertyAliasEvaluationContext);
        }
        if (node == null) {
            String string2 = __msgs.msgPropertyAliasReturnedNullSet(oPropertyAlias.getDescription(), string);
            if (__log.isErrorEnabled()) {
                __log.error((Object)string2);
            }
            throw new FaultException(this._runtime._oprocess.constants.qnSelectionFailure, string2);
        }
        if (node.getNodeType() == 1) {
            StringBuffer stringBuffer = new StringBuffer();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                stringBuffer.append(node2.getNodeValue());
            }
            return stringBuffer.toString();
        }
        if (node.getNodeType() == 3) {
            return ((Text)node).getWholeText();
        }
        return null;
    }

    @Override
    public Node getPartData(Element element, OMessageVarType.Part part) {
        Element element2 = DOMUtils.findChildByName((Element)element, (QName)new QName(null, part.name));
        if (part.type instanceof OElementVarType) {
            QName qName = ((OElementVarType)part.type).elementType;
            element2 = DOMUtils.findChildByName((Element)element2, (QName)qName);
        } else if (part.type == null) {
            if (element2 != null && element2.getNodeType() == 1 && element2.getAttribute("headerPart") != null && DOMUtils.getTextContent((Node)element2) == null) {
                element2 = DOMUtils.getFirstChildElement((Element)element2);
            }
            if (element2 == null) {
                element2 = element.getOwnerDocument().createElementNS(null, part.name);
                element2.setAttribute("headerPart", "true");
                element.appendChild(element2);
            }
        }
        return element2;
    }

    @Override
    public String invoke(String string, PartnerLinkInstance partnerLinkInstance, Operation operation, Element element, Object object) throws FaultException {
        try {
            return this._brc.invoke(string, (PartnerLink)partnerLinkInstance, operation, element);
        }
        catch (UninitializedPartnerEPR uninitializedPartnerEPR) {
            throw new FaultException(this._runtime._oprocess.constants.qnUninitializedPartnerRole);
        }
    }

    @Override
    public ExpressionLanguageRuntimeRegistry getExpLangRuntime() {
        return this._runtime._expLangRuntimeRegistry;
    }

    public void onSelectEvent(final String string, final String string2, final int n) {
        this.getORM().associate(string, string2);
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 3168964409165899533L;

            public void run() {
                PickResponseChannel pickResponseChannel = (PickResponseChannel)2.importChannel((String)string, PickResponseChannel.class);
                pickResponseChannel.onRequestRcvd(n, string2);
            }
        });
    }

    public void onTimerEvent(final String string) {
        this.getORM().cancel(string);
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = -7767141033611036745L;

            public void run() {
                TimerResponseChannel timerResponseChannel = (TimerResponseChannel)3.importChannel((String)string, TimerResponseChannel.class);
                timerResponseChannel.onTimeout();
            }
        });
    }

    public boolean execute() {
        return this._vpu.execute();
    }

    public void onInvokeResponse(final String string, OdeRTInstance.InvokeResponseType invokeResponseType, String string2) {
        switch (invokeResponseType) {
            case REPLY: {
                this._vpu.inject((JacobRunnable)new BpelJacobRunnable(){
                    private static final long serialVersionUID = -1095444335740879981L;

                    public void run() {
                        ((InvokeResponseChannel)4.importChannel((String)string, InvokeResponseChannel.class)).onResponse();
                    }
                });
                break;
            }
            case FAULT: {
                this._vpu.inject((JacobRunnable)new BpelJacobRunnable(){
                    private static final long serialVersionUID = -1095444335740879981L;

                    public void run() {
                        ((InvokeResponseChannel)5.importChannel((String)string, InvokeResponseChannel.class)).onFault();
                    }
                });
                break;
            }
            case FAILURE: {
                this._vpu.inject((JacobRunnable)new BpelJacobRunnable(){
                    private static final long serialVersionUID = -1095444335740879981L;

                    public void run() {
                        ((InvokeResponseChannel)6.importChannel((String)string, InvokeResponseChannel.class)).onFailure();
                    }
                });
            }
        }
    }

    public void recoverActivity(final String string, final long l, final String string2, FaultInfo faultInfo) {
        final FaultData faultData = faultInfo != null ? new FaultData(faultInfo.getFaultName(), null, faultInfo.getExplanation()) : null;
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 3168964409165899533L;

            public void run() {
                ActivityRecoveryChannel activityRecoveryChannel = (ActivityRecoveryChannel)7.importChannel((String)string, ActivityRecoveryChannel.class);
                __log.info((Object)("ActivityRecovery: Recovering activity " + l + " with action " + string2 + " on channel " + activityRecoveryChannel));
                if (activityRecoveryChannel != null) {
                    if ("cancel".equals(string2)) {
                        activityRecoveryChannel.cancel();
                    } else if ("retry".equals(string2)) {
                        activityRecoveryChannel.retry();
                    } else if ("fault".equals(string2)) {
                        activityRecoveryChannel.fault(faultData);
                    }
                }
            }
        });
    }

    private OutstandingRequestManager getORM() {
        return (OutstandingRequestManager)this._soup.getGlobalData();
    }

    private void cleanupOutstandingMyRoleExchanges(FaultInfo faultInfo) {
        String[] stringArray;
        for (String string : stringArray = this.getORM().releaseAll()) {
            this._brc.noreply(string, faultInfo);
        }
    }

    public Object saveState(OutputStream outputStream) throws IOException {
        this._soup.write(outputStream);
        return this._soup;
    }

    public void onCreateInstance(String string) {
        this._vpu.inject((JacobRunnable)new PROCESS(this._runtime._oprocess));
    }

    public void setContext(OdeRTInstanceContext odeRTInstanceContext) {
        this._brc = odeRTInstanceContext;
    }

    @Override
    public URI getBaseResourceURI() {
        return this._runtime._pconf.getBaseURI();
    }

    @Override
    public Node getProcessProperty(QName qName) {
        return this._brc.getProcessProperty(qName);
    }
}

