/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.ExprEvaluationContextImpl;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.OEventHandler;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.channels.EventHandlerControlChannel;
import org.apache.ode.bpel.rtrep.v2.channels.EventHandlerControlChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.TerminationChannel;
import org.apache.ode.bpel.rtrep.v2.channels.TerminationChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.TimerResponseChannel;
import org.apache.ode.bpel.rtrep.v2.channels.TimerResponseChannelListener;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

class EH_ALARM
extends BpelJacobRunnable {
    private static final Log __log = LogFactory.getLog(EH_ALARM.class);
    private static final long serialVersionUID = 1L;
    private ParentScopeChannel _psc;
    private TerminationChannel _tc;
    private OEventHandler.OAlarm _oalarm;
    private ScopeFrame _scopeFrame;
    private EventHandlerControlChannel _cc;
    private Set<CompensationHandler> _comps = new HashSet<CompensationHandler>();

    EH_ALARM(ParentScopeChannel parentScopeChannel, TerminationChannel terminationChannel, EventHandlerControlChannel eventHandlerControlChannel, OEventHandler.OAlarm oAlarm, ScopeFrame scopeFrame) {
        this._psc = parentScopeChannel;
        this._tc = terminationChannel;
        this._cc = eventHandlerControlChannel;
        this._scopeFrame = scopeFrame;
        this._oalarm = oAlarm;
    }

    public void run() {
        Calendar calendar = Calendar.getInstance();
        if (this._oalarm.forExpr != null) {
            try {
                this.getBpelRuntime().getExpLangRuntime().evaluateAsDuration(this._oalarm.forExpr, this.getEvaluationContext()).addTo(calendar);
            }
            catch (FaultException faultException) {
                __log.error((Object)faultException);
                this._psc.completed(this.createFault(faultException.getQName(), this._oalarm.forExpr), this._comps);
                return;
            }
        }
        if (this._oalarm.untilExpr != null) {
            try {
                calendar.setTime(this.getBpelRuntime().getExpLangRuntime().evaluateAsDate(this._oalarm.untilExpr, this.getEvaluationContext()).getTime());
            }
            catch (FaultException faultException) {
                __log.error((Object)faultException);
                this._psc.completed(this.createFault(faultException.getQName(), this._oalarm.untilExpr), this._comps);
                return;
            }
        }
        EH_ALARM.instance((JacobRunnable)new WAIT(calendar, this._scopeFrame));
    }

    protected EvaluationContext getEvaluationContext() {
        return new ExprEvaluationContextImpl(this._scopeFrame, this.getBpelRuntime());
    }

    private class ACTIVE
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -2166253425722769701L;
        private ActivityInfo _activity;
        private boolean _stopped = false;

        ACTIVE(ActivityInfo activityInfo, ScopeFrame scopeFrame) {
            this._activity = activityInfo;
            this._scopeFrame = scopeFrame;
        }

        public void run() {
            ACTIVE.object((boolean)false, (Set)new ParentScopeChannelListener(this._activity.parent){
                private static final long serialVersionUID = -3357030137175178040L;

                @Override
                public void compensate(OScope oScope, SynchChannel synchChannel) {
                    EH_ALARM.this._psc.compensate(oScope, synchChannel);
                    3.instance((JacobRunnable)ACTIVE.this);
                }

                @Override
                public void completed(FaultData faultData, Set<CompensationHandler> set) {
                    EH_ALARM.this._comps.addAll(set);
                    if (!ACTIVE.this._stopped && ((EH_ALARM)EH_ALARM.this)._oalarm.repeatExpr != null) {
                        Calendar calendar = Calendar.getInstance();
                        try {
                            ACTIVE.this.getBpelRuntime().getExpLangRuntime().evaluateAsDuration(((EH_ALARM)EH_ALARM.this)._oalarm.forExpr, EH_ALARM.this.getEvaluationContext()).addTo(calendar);
                        }
                        catch (FaultException faultException) {
                            __log.error((Object)faultException);
                            EH_ALARM.this._psc.completed(ACTIVE.this.createFault(faultException.getQName(), ((EH_ALARM)EH_ALARM.this)._oalarm.forExpr), EH_ALARM.this._comps);
                            return;
                        }
                        3.instance((JacobRunnable)new WAIT(calendar, ACTIVE.this._scopeFrame));
                    } else {
                        EH_ALARM.this._psc.completed(faultData, EH_ALARM.this._comps);
                    }
                }

                @Override
                public void cancelled() {
                    this.completed(null, CompensationHandler.emptySet());
                }

                @Override
                public void failure(String string, Element element) {
                    this.completed(null, CompensationHandler.emptySet());
                }
            }.or(new EventHandlerControlChannelListener(EH_ALARM.this._cc){
                private static final long serialVersionUID = -3873619538789039424L;

                public void stop() {
                    ACTIVE.this._stopped = true;
                    2.instance((JacobRunnable)ACTIVE.this);
                }
            }.or(new TerminationChannelListener(EH_ALARM.this._tc){
                private static final long serialVersionUID = -4566956567870652885L;

                public void terminate() {
                    ((TerminationChannel)1.replication((Channel)((ACTIVE)ACTIVE.this)._activity.self)).terminate();
                    ACTIVE.this._stopped = true;
                    1.instance((JacobRunnable)ACTIVE.this);
                }
            })));
        }
    }

    private class FIRE
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -7261315204412433250L;

        public FIRE(ScopeFrame scopeFrame) {
            this._scopeFrame = scopeFrame;
        }

        public void run() {
            ActivityInfo activityInfo = new ActivityInfo(this.genMonotonic(), ((EH_ALARM)EH_ALARM.this)._oalarm.activity, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
            FIRE.instance((JacobRunnable)this.createChild(activityInfo, this._scopeFrame, new LinkFrame(null)));
            FIRE.instance((JacobRunnable)new ACTIVE(activityInfo, this._scopeFrame));
        }
    }

    private class WAIT
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -1426724996925898213L;
        Calendar _alarm;

        WAIT(Calendar calendar, ScopeFrame scopeFrame) {
            this._alarm = calendar;
            this._scopeFrame = scopeFrame;
        }

        public void run() {
            Calendar calendar = Calendar.getInstance();
            if (calendar.before(this._alarm)) {
                TimerResponseChannel timerResponseChannel = (TimerResponseChannel)this.newChannel(TimerResponseChannel.class);
                this.getBpelRuntime().registerTimer(timerResponseChannel, this._alarm.getTime());
                WAIT.object((boolean)false, (Set)new TimerResponseChannelListener(timerResponseChannel){
                    private static final long serialVersionUID = 1110683632756756017L;

                    public void onTimeout() {
                        3.instance((JacobRunnable)new FIRE(WAIT.this._scopeFrame));
                    }

                    public void onCancel() {
                        EH_ALARM.this._psc.completed(null, EH_ALARM.this._comps);
                    }
                }.or(new EventHandlerControlChannelListener(EH_ALARM.this._cc){
                    private static final long serialVersionUID = -7750428941445331236L;

                    public void stop() {
                        EH_ALARM.this._psc.completed(null, EH_ALARM.this._comps);
                    }
                }.or(new TerminationChannelListener(EH_ALARM.this._tc){
                    private static final long serialVersionUID = 6100105997983514609L;

                    public void terminate() {
                        EH_ALARM.this._psc.completed(null, EH_ALARM.this._comps);
                    }
                })));
            } else {
                WAIT.instance((JacobRunnable)new FIRE(this._scopeFrame));
            }
        }
    }
}

