/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.id.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.IdHandlingException;
import org.eclipse.smila.datamodel.id.Key;
import org.eclipse.smila.datamodel.id.impl.KeyImpl;
import org.eclipse.smila.utils.digest.DigestHelper;

public class IdImpl
implements Id {
    private static final long serialVersionUID = 2L;
    private final String _source;
    private final Key _key;
    private List<KeyImpl> _elementKeys;
    private List<String> _fragmentNames;
    private int _hashCode;
    private String _idHash;
    private String _toString;

    public IdImpl(String sourceName, Key sourceKey) {
        this._source = sourceName;
        this._key = sourceKey;
    }

    public IdImpl(String sourceName, Key sourceKey, List<KeyImpl> newElementKeys, List<String> newFragmentNames) {
        this._source = sourceName;
        this._key = sourceKey;
        if (newElementKeys != null && !newElementKeys.isEmpty()) {
            this._elementKeys = Collections.unmodifiableList(new ArrayList<KeyImpl>(newElementKeys));
        }
        if (newFragmentNames != null && !newFragmentNames.isEmpty()) {
            this._fragmentNames = Collections.unmodifiableList(new ArrayList<String>(newFragmentNames));
        }
    }

    @Override
    public String getSource() {
        return this._source;
    }

    @Override
    public Key getKey() {
        return this._key;
    }

    @Override
    public boolean hasElementKeys() {
        return this._elementKeys != null && !this._elementKeys.isEmpty();
    }

    @Override
    public List<? extends Key> getElementKeys() {
        if (this._elementKeys == null) {
            return Collections.emptyList();
        }
        return this._elementKeys;
    }

    @Override
    public boolean hasFragmentNames() {
        return this._fragmentNames != null && !this._fragmentNames.isEmpty();
    }

    @Override
    public List<String> getFragmentNames() {
        if (this._fragmentNames == null) {
            return Collections.emptyList();
        }
        return this._fragmentNames;
    }

    @Override
    public Id createElementId(String elementName) throws IdHandlingException {
        KeyImpl elementKey = new KeyImpl(elementName);
        return this.createElementId(elementKey);
    }

    @Override
    public Id createElementId(Key elementKey) throws IdHandlingException {
        if (this.hasFragmentNames()) {
            throw new IdHandlingException("Cannot create an element Id from a fragment Id.");
        }
        KeyImpl elementKeyImpl = KeyImpl.ensureImpl(elementKey);
        ArrayList<KeyImpl> subElementKeys = null;
        if (this.hasElementKeys()) {
            subElementKeys = new ArrayList(this._elementKeys.size() + 1);
            subElementKeys.addAll(this._elementKeys);
        } else {
            subElementKeys = new ArrayList<KeyImpl>(1);
        }
        subElementKeys.add(elementKeyImpl);
        return new IdImpl(this._source, this._key, subElementKeys, null);
    }

    @Override
    public Id createFragmentId(String fragmentName) {
        ArrayList<String> subFragmentsNames = null;
        if (this.hasFragmentNames()) {
            subFragmentsNames = new ArrayList(this._fragmentNames.size() + 1);
            subFragmentsNames.addAll(this._fragmentNames);
        } else {
            subFragmentsNames = new ArrayList<String>(1);
        }
        subFragmentsNames.add(fragmentName);
        return new IdImpl(this._source, this._key, this._elementKeys, subFragmentsNames);
    }

    @Override
    public Id createCompoundId() throws IdHandlingException {
        if (!this.hasFragmentNames() && !this.hasElementKeys()) {
            throw new IdHandlingException("Cannot create a compound Id from a source object Id.");
        }
        List<KeyImpl> compoundElementKeys = null;
        List<String> compoundFragmentNames = null;
        if (this.hasFragmentNames()) {
            compoundElementKeys = this._elementKeys;
            if (this._fragmentNames.size() > 1) {
                compoundFragmentNames = this._fragmentNames.subList(0, this._fragmentNames.size() - 1);
            }
        } else if (this._elementKeys.size() > 1) {
            compoundElementKeys = this._elementKeys.subList(0, this._elementKeys.size() - 1);
        }
        return new IdImpl(this._source, this._key, compoundElementKeys, compoundFragmentNames);
    }

    @Override
    public String getIdHash() {
        if (this._idHash == null) {
            String idString = this.toString();
            this._idHash = DigestHelper.calculateDigest((String)idString);
        }
        return this._idHash;
    }

    public String toString() {
        if (this._toString == null) {
            StringBuilder str = new StringBuilder("src:").append(this._source).append("|");
            str.append("key:").append(this._key);
            if (this._elementKeys != null) {
                for (Key key : this._elementKeys) {
                    str.append("|elem:").append(key);
                }
            }
            if (this._fragmentNames != null) {
                str.append("|frag:[");
                Iterator<String> iterator = this._fragmentNames.iterator();
                while (iterator.hasNext()) {
                    str.append(iterator.next());
                    if (iterator.hasNext()) {
                        str.append(";");
                        continue;
                    }
                    str.append("]");
                }
            }
            this._toString = str.toString();
        }
        return this._toString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IdImpl) {
            IdImpl otherId = (IdImpl)obj;
            if (!this._source.equals(otherId._source)) {
                return false;
            }
            if (!this._key.equals(otherId._key)) {
                return false;
            }
            if (this._elementKeys == null ? otherId._elementKeys != null : !this._elementKeys.equals(otherId._elementKeys)) {
                return false;
            }
            return !(this._fragmentNames == null ? otherId._fragmentNames != null : !this._fragmentNames.equals(otherId._fragmentNames));
        }
        return false;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int hashCode = this._source.hashCode() + this._key.hashCode();
            if (this._elementKeys != null) {
                for (Key key : this._elementKeys) {
                    hashCode += key.hashCode();
                }
            }
            if (this._fragmentNames != null) {
                for (String string : this._fragmentNames) {
                    hashCode += string.hashCode();
                }
            }
            this._hashCode = hashCode;
        }
        return this._hashCode;
    }
}

