/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.id.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.eclipse.smila.datamodel.id.Key;

public class KeyImpl
implements Key {
    private static final long serialVersionUID = 1L;
    private String _simpleKey;
    private String _simpleKeyName;
    private Map<String, String> _compositeKey;
    private int _hashCode;

    public KeyImpl(Map<String, String> keyValues) {
        if (keyValues.size() == 1) {
            this._simpleKeyName = keyValues.keySet().iterator().next();
            this._simpleKey = keyValues.get(this._simpleKeyName);
        } else {
            this._compositeKey = Collections.unmodifiableMap(new TreeMap<String, String>(keyValues));
        }
    }

    public KeyImpl(String name, String keyValue) {
        this._simpleKeyName = name;
        this._simpleKey = keyValue;
    }

    public KeyImpl(String key) {
        this(null, key);
    }

    public static KeyImpl ensureImpl(Key someKey) {
        if (someKey instanceof KeyImpl) {
            return (KeyImpl)someKey;
        }
        return new KeyImpl(someKey.getKeyValues());
    }

    @Override
    public String getKey() {
        return this._simpleKey;
    }

    @Override
    public String getKeyName() {
        return this._simpleKeyName;
    }

    @Override
    public boolean isCompositeKey() {
        return this._compositeKey != null;
    }

    @Override
    public Iterator<String> getKeyNames() {
        if (this._compositeKey == null) {
            if (this._simpleKeyName == null) {
                return EmptyIterator.INSTANCE;
            }
            return new SingletonIterator((Object)this._simpleKeyName, false);
        }
        return this._compositeKey.keySet().iterator();
    }

    @Override
    public String getKey(String name) {
        if (this._compositeKey == null) {
            if (this._simpleKeyName == name || name != null && name.equals(this._simpleKeyName)) {
                return this._simpleKey;
            }
            return null;
        }
        return this._compositeKey.get(name);
    }

    @Override
    public Map<String, String> getKeyValues() {
        if (this.isCompositeKey()) {
            return this._compositeKey;
        }
        return Collections.singletonMap(this._simpleKeyName, this._simpleKey);
    }

    public String toString() {
        if (this._simpleKey == null && this._compositeKey == null) {
            return null;
        }
        StringBuilder str = new StringBuilder("<");
        if (this._simpleKey != null) {
            if (this._simpleKeyName != null) {
                str.append(this._simpleKeyName).append('=');
            }
            str.append(this._simpleKey).append('>');
        } else {
            for (Map.Entry<String, String> entry : this._compositeKey.entrySet()) {
                str.append(entry.getKey()).append('=');
                str.append(entry.getValue()).append(';');
            }
            if (str.length() > 0) {
                str.setCharAt(str.length() - 1, '>');
            } else {
                str.append('>');
            }
        }
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof KeyImpl) {
            KeyImpl otherKey = (KeyImpl)obj;
            if (this._simpleKey == null) {
                if (otherKey._simpleKey != null) {
                    return false;
                }
                return this._compositeKey.equals(otherKey._compositeKey);
            }
            if (!this._simpleKey.equals(otherKey._simpleKey)) {
                return false;
            }
            if (this._simpleKeyName == null) {
                return otherKey._simpleKeyName == null;
            }
            return this._simpleKeyName.equals(otherKey._simpleKeyName);
        }
        return false;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int hashCode = 0;
            if (this._simpleKey == null) {
                for (Map.Entry<String, String> entry : this._compositeKey.entrySet()) {
                    hashCode += entry.getKey().hashCode() + entry.getValue().hashCode();
                }
            } else {
                hashCode += this._simpleKey.hashCode();
                if (this._simpleKeyName != null) {
                    hashCode += this._simpleKeyName.hashCode();
                }
            }
            this._hashCode = hashCode;
        }
        return this._hashCode;
    }
}

