/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.id.stax;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.Key;

public class IdWriter {
    private boolean _printPretty;

    public IdWriter() {
    }

    public IdWriter(boolean printPretty) {
        this();
        this._printPretty = printPretty;
    }

    /*
     * WARNING - void declaration
     */
    public void writeId(XMLStreamWriter staxWriter, Id id) throws XMLStreamException {
        staxWriter.setDefaultNamespace("http://www.eclipse.org/smila/id");
        this.writeStartElement(staxWriter, "Id");
        staxWriter.writeDefaultNamespace("http://www.eclipse.org/smila/id");
        staxWriter.writeAttribute("version", "1.0");
        this.newline(staxWriter);
        this.writeSource(staxWriter, id);
        this.writeKey(staxWriter, id.getKey());
        if (id.hasElementKeys()) {
            void var4_8;
            int elementCount = 0;
            for (Key key : id.getElementKeys()) {
                this.writeStartElement(staxWriter, "Element");
                ++elementCount;
                this.newline(staxWriter);
                this.writeKey(staxWriter, key);
            }
            boolean bl = false;
            while (var4_8 < elementCount) {
                this.writeEndElement(staxWriter);
                ++var4_8;
            }
        }
        if (id.hasFragmentNames()) {
            for (String fragment : id.getFragmentNames()) {
                this.writeTextElement(staxWriter, "Fragment", fragment);
            }
        }
        this.writeEndElement(staxWriter);
    }

    private void writeSource(XMLStreamWriter staxWriter, Id id) throws XMLStreamException {
        this.writeTextElement(staxWriter, "Source", id.getSource());
    }

    private void writeKey(XMLStreamWriter staxWriter, Key key) throws XMLStreamException {
        if (key.isCompositeKey()) {
            Iterator<String> keyNames = key.getKeyNames();
            while (keyNames.hasNext()) {
                String keyName = keyNames.next();
                this.writeKeyValue(staxWriter, keyName, key.getKey(keyName));
            }
        } else {
            this.writeKeyValue(staxWriter, key.getKeyName(), key.getKey());
        }
    }

    private void writeKeyValue(XMLStreamWriter staxWriter, String keyName, String keyValue) throws XMLStreamException {
        this.writeStartElement(staxWriter, "Key");
        if (keyName != null) {
            staxWriter.writeAttribute("name", keyName);
        }
        staxWriter.writeCharacters(keyValue);
        this.writeEndElement(staxWriter);
    }

    private void writeTextElement(XMLStreamWriter staxWriter, String tagName, String value) throws XMLStreamException {
        this.writeStartElement(staxWriter, tagName);
        staxWriter.writeCharacters(value);
        this.writeEndElement(staxWriter);
    }

    private void writeStartElement(XMLStreamWriter staxWriter, String tagName) throws XMLStreamException {
        staxWriter.writeStartElement("http://www.eclipse.org/smila/id", tagName);
    }

    private void writeEndElement(XMLStreamWriter staxWriter) throws XMLStreamException {
        staxWriter.writeEndElement();
        this.newline(staxWriter);
    }

    private void newline(XMLStreamWriter staxWriter) throws XMLStreamException {
        if (this._printPretty) {
            staxWriter.writeCharacters("\n");
        }
    }
}

