/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.record.dom;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.id.dom.IdBuilder;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RecordBuilder {
    public static final String NAMESPACE_RECORD = "http://www.eclipse.org/smila/record";
    public static final String ATTRIBUTE_XMLNSREC = "xmlns";
    public static final String PREFIX_REC = "";
    public static final String TAG_RECORD = "Record";
    public static final String TAG_RECORDLIST = "RecordList";
    public static final String TAG_ATTRIBUTE = "A";
    public static final String TAG_ANNOTATION = "An";
    public static final String TAG_VALUE = "V";
    public static final String TAG_LITERAL = "L";
    public static final String TAG_OBJECT = "O";
    public static final String TAG_ATTACHMENT = "Attachment";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String ATTRIBUTE_NAME = "n";
    public static final String ATTRIBUTE_TYPE = "t";
    public static final String ATTRIBUTE_SEMANTICTYPE = "st";
    public static final String SCHEMA_VERSION_RECORD = "1.0";
    private final IdBuilder _idBuilder;
    private final boolean _printPretty;

    public RecordBuilder() {
        this(false);
    }

    public RecordBuilder(boolean printPretty) {
        this._printPretty = printPretty;
        this._idBuilder = new IdBuilder(printPretty);
    }

    public Element appendRecord(Element parent, Record record) {
        Document factory = parent.getOwnerDocument();
        this.newline(factory, parent);
        Element recordElement = this.buildRecord(factory, record);
        recordElement.setAttribute(ATTRIBUTE_XMLNSREC, NAMESPACE_RECORD);
        parent.appendChild(recordElement);
        this.newline(factory, parent);
        return recordElement;
    }

    public Element appendRecordList(Element parent, Iterable<Record> records) {
        Document factory = parent.getOwnerDocument();
        this.newline(factory, parent);
        Element recordListElement = this.appendElement(factory, parent, TAG_RECORDLIST);
        for (Record record : records) {
            Element recordElement = this.buildRecord(factory, record);
            recordListElement.appendChild(recordElement);
            this.newline(factory, parent);
        }
        return recordListElement;
    }

    public Element appendRecordList(Element parent, Record[] records) {
        Document factory = parent.getOwnerDocument();
        this.newline(factory, parent);
        Element recordListElement = this.appendElement(factory, parent, TAG_RECORDLIST);
        Record[] recordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            Record record = recordArray[n2];
            Element recordElement = this.buildRecord(factory, record);
            recordListElement.appendChild(recordElement);
            this.newline(factory, parent);
            ++n2;
        }
        return recordListElement;
    }

    public Element buildRecord(Document factory, Record record) {
        Element recordElement = factory.createElementNS(NAMESPACE_RECORD, TAG_RECORD);
        recordElement.setAttribute(ATTRIBUTE_VERSION, SCHEMA_VERSION_RECORD);
        if (record.getId() != null) {
            this._idBuilder.appendId(recordElement, record.getId());
        }
        if (record.getMetadata() != null) {
            this.appendMetadata(factory, recordElement, record.getMetadata());
        }
        if (record.hasAttachments()) {
            Iterator<String> attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = attachmentNames.next();
                this.appendTextElement(factory, recordElement, TAG_ATTACHMENT, attachmentName);
            }
        }
        return recordElement;
    }

    public void buildRecordAsDocumentElement(Document factory, Record record) {
        Element recordElement = this.buildRecord(factory, record);
        recordElement.setAttribute(ATTRIBUTE_VERSION, SCHEMA_VERSION_RECORD);
        recordElement.setAttributeNS("http://www.w3.org/2000/xmlns/", ATTRIBUTE_XMLNSREC, NAMESPACE_RECORD);
        factory.appendChild(recordElement);
    }

    private void appendMetadata(Document factory, Element parentElement, MObject metadata) {
        if (metadata.hasAttributes()) {
            Iterator<String> names = metadata.getAttributeNames();
            while (names.hasNext()) {
                String name = names.next();
                Attribute attribute = metadata.getAttribute(name);
                this.appendAttribute(factory, parentElement, attribute);
            }
        }
        this.appendAnnotations(factory, parentElement, metadata);
    }

    private void appendAttribute(Document factory, Element parentElement, Attribute attribute) {
        Element attributeElement = this.appendElement(factory, parentElement, TAG_ATTRIBUTE);
        attributeElement.setAttribute(ATTRIBUTE_NAME, attribute.getName());
        if (attribute.hasAnnotations()) {
            this.appendAnnotations(factory, attributeElement, attribute);
        }
        if (attribute.hasLiterals()) {
            Element unannotatedValuesElement = null;
            if (attribute.hasLiterals()) {
                for (Literal literal : attribute.getLiterals()) {
                    if (literal.hasAnnotations()) {
                        Element valueElement = this.appendElement(factory, attributeElement, TAG_LITERAL);
                        this.appendLiteral(factory, valueElement, literal);
                        continue;
                    }
                    if (unannotatedValuesElement == null) {
                        unannotatedValuesElement = this.appendElement(factory, attributeElement, TAG_LITERAL);
                    }
                    this.appendLiteral(factory, unannotatedValuesElement, literal);
                }
            }
        }
        if (attribute.hasObjects()) {
            for (MObject object : attribute.getObjects()) {
                Element objectElement = this.appendElement(factory, attributeElement, TAG_OBJECT);
                if (object.getSemanticType() != null) {
                    objectElement.setAttribute(ATTRIBUTE_SEMANTICTYPE, object.getSemanticType());
                }
                this.appendMetadata(factory, objectElement, object);
            }
        }
    }

    private void appendLiteral(Document factory, Element parentElement, Literal literal) {
        if (literal.getValue() != null) {
            Element valueElement = this.appendTextElement(factory, parentElement, TAG_VALUE, literal.getStringValue());
            switch (literal.getDataType()) {
                case INT: {
                    valueElement.setAttribute(ATTRIBUTE_TYPE, "int");
                    break;
                }
                case FP: {
                    valueElement.setAttribute(ATTRIBUTE_TYPE, "fp");
                    break;
                }
                case BOOL: {
                    valueElement.setAttribute(ATTRIBUTE_TYPE, "bool");
                    break;
                }
                case DATE: {
                    valueElement.setAttribute(ATTRIBUTE_TYPE, "date");
                    break;
                }
                case TIME: {
                    valueElement.setAttribute(ATTRIBUTE_TYPE, "time");
                    break;
                }
                case DATETIME: {
                    valueElement.setAttribute(ATTRIBUTE_TYPE, "datetime");
                }
            }
            if (literal.getSemanticType() != null) {
                valueElement.setAttribute(ATTRIBUTE_SEMANTICTYPE, literal.getSemanticType());
            }
            this.appendAnnotations(factory, parentElement, literal);
        }
    }

    private void appendAnnotations(Document factory, Element parentElement, Annotatable annotated) {
        if (annotated.hasAnnotations()) {
            Iterator<String> names = annotated.getAnnotationNames();
            while (names.hasNext()) {
                String name = names.next();
                Collection<Annotation> annotations = annotated.getAnnotations(name);
                for (Annotation annotation : annotations) {
                    this.appendAnnotation(factory, parentElement, name, annotation);
                }
            }
        }
    }

    private void appendAnnotation(Document factory, Element parentElement, String name, Annotation annotation) {
        Element annotationElement = this.appendElement(factory, parentElement, TAG_ANNOTATION);
        annotationElement.setAttribute(ATTRIBUTE_NAME, name);
        if (annotation.hasAnonValues()) {
            for (String value : annotation.getAnonValues()) {
                this.appendTextElement(factory, annotationElement, TAG_VALUE, value);
            }
        }
        if (annotation.hasNamedValues()) {
            Iterator<String> valueNames = annotation.getValueNames();
            while (valueNames.hasNext()) {
                String valueName = valueNames.next();
                Element valueElement = this.appendTextElement(factory, annotationElement, TAG_VALUE, annotation.getNamedValue(valueName));
                valueElement.setAttribute(ATTRIBUTE_NAME, valueName);
            }
        }
        this.appendAnnotations(factory, annotationElement, annotation);
    }

    private Element appendElement(Document factory, Element parentElement, String tag) {
        Element element = factory.createElementNS(NAMESPACE_RECORD, tag);
        this.newline(factory, element);
        parentElement.appendChild(element);
        this.newline(factory, parentElement);
        return element;
    }

    private Element appendTextElement(Document factory, Element element, String name, String text) {
        Element textElement = factory.createElementNS(NAMESPACE_RECORD, name);
        textElement.appendChild(factory.createTextNode(RecordBuilder.cleanText(text)));
        element.appendChild(textElement);
        this.newline(factory, element);
        return textElement;
    }

    private void newline(Document factory, Element element) {
        if (this._printPretty) {
            element.appendChild(factory.createTextNode("\n"));
        }
    }

    protected static String cleanText(String text) {
        return StringUtils.replace((String)text, (String)"\u0000", (String)" ");
    }
}

