/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.record.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.impl.AnnotationImpl;
import org.eclipse.smila.utils.collections.MultiValueMap;

public abstract class AnnotatableImpl
implements Annotatable,
Serializable {
    private static final long serialVersionUID = 1L;
    private MultiValueMap<String, Annotation> _annotationMap;

    @Override
    public void addAnnotation(String name, Annotation annotation) {
        if (!(annotation instanceof AnnotationImpl)) {
            throw new IllegalArgumentException("cannot add annotations of class " + annotation.getClass().getName());
        }
        this.getAnnotationMap().add((Object)name, (Object)annotation);
    }

    @Override
    public Annotation getAnnotation(String name) {
        if (this.hasAnnotation(name)) {
            return (Annotation)this._annotationMap.getValues((Object)name).iterator().next();
        }
        return null;
    }

    @Override
    public Iterator<String> getAnnotationNames() {
        if (this.hasAnnotations()) {
            return this._annotationMap.keySet().iterator();
        }
        return EmptyIterator.INSTANCE;
    }

    @Override
    public Collection<Annotation> getAnnotations(String name) {
        if (this.hasAnnotations() && this._annotationMap.containsKey((Object)name)) {
            return this._annotationMap.getValues((Object)name);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasAnnotation(String name) {
        return this.hasAnnotations() && this._annotationMap.containsKey((Object)name);
    }

    @Override
    public boolean hasAnnotations() {
        return this._annotationMap != null && !this._annotationMap.isEmpty();
    }

    @Override
    public void removeAnnotations(String name) {
        if (this._annotationMap != null) {
            this._annotationMap.remove((Object)name);
        }
    }

    @Override
    public void removeAnnotations() {
        this._annotationMap = null;
    }

    @Override
    public void setAnnotation(String name, Annotation annotation) {
        this.removeAnnotations(name);
        this.addAnnotation(name, annotation);
    }

    @Override
    public void setAnnotations(String name, Collection<? extends Annotation> annotations) {
        this.removeAnnotations(name);
        for (Annotation annotation : annotations) {
            this.addAnnotation(name, annotation);
        }
    }

    @Override
    public int annotationsSize() {
        if (this.hasAnnotations()) {
            return this._annotationMap.size();
        }
        return 0;
    }

    private MultiValueMap<String, Annotation> getAnnotationMap() {
        if (this._annotationMap == null) {
            this._annotationMap = new MultiValueMap();
        }
        return this._annotationMap;
    }
}

