/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.record.stax;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.id.IdFactory;
import org.eclipse.smila.datamodel.id.stax.IdReader;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.LiteralFormatHelper;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;

public class RecordReader {
    private RecordFactory _recordFactory;
    private IdReader _idReader;
    private final LiteralFormatHelper _literalHelper = new LiteralFormatHelper();

    public RecordReader() {
        this(RecordFactory.DEFAULT_INSTANCE, IdFactory.DEFAULT_INSTANCE);
    }

    public RecordReader(RecordFactory recordFactory, IdFactory idFactory) {
        this._recordFactory = recordFactory;
        this._idReader = new IdReader(idFactory);
    }

    public List<Record> readRecords(XMLStreamReader staxReader) throws XMLStreamException {
        ArrayList<Record> records = new ArrayList<Record>();
        if (this.isStartTag(staxReader, "RecordList")) {
            staxReader.nextTag();
            while (this.isStartTag(staxReader, "Record")) {
                records.add(this.readRecord(staxReader));
                staxReader.nextTag();
            }
        }
        return records;
    }

    public Record readRecord(XMLStreamReader staxReader) throws XMLStreamException {
        Record record = null;
        if (this.isStartTag(staxReader, "Record")) {
            record = this._recordFactory.createRecord();
            staxReader.nextTag();
            if (this.isStartTag(staxReader, "Id")) {
                record.setId(this._idReader.readId(staxReader));
                staxReader.nextTag();
            }
            record.setMetadata(this.readMetadata(staxReader));
            this.readAttachments(staxReader, record);
        }
        return record;
    }

    private MObject readMetadata(XMLStreamReader staxReader) throws XMLStreamException {
        MObject mobject = this._recordFactory.createMetadataObject();
        while (this.isStartTag(staxReader, "A")) {
            this.readAttribute(staxReader, mobject);
            staxReader.nextTag();
        }
        this.readAnnotations(staxReader, mobject);
        return mobject;
    }

    private void readAttribute(XMLStreamReader staxReader, MObject mobject) throws XMLStreamException {
        Attribute attribute = this._recordFactory.createAttribute();
        String attributeName = staxReader.getAttributeValue(null, "n");
        attribute.setName(attributeName);
        mobject.setAttribute(attributeName, attribute);
        staxReader.nextTag();
        this.readAnnotations(staxReader, attribute);
        while (this.isStartTag(staxReader, "L")) {
            this.readLiteralElement(staxReader, attribute);
            staxReader.nextTag();
        }
        while (this.isStartTag(staxReader, "O")) {
            staxReader.nextTag();
            attribute.addObject(this.readMetadata(staxReader));
            staxReader.nextTag();
        }
    }

    private void readLiteralElement(XMLStreamReader staxReader, Attribute attribute) throws XMLStreamException {
        String defaultSemanticType = staxReader.getAttributeValue(null, "st");
        staxReader.nextTag();
        Literal literal = null;
        while (this.isStartTag(staxReader, "V")) {
            literal = this._recordFactory.createLiteral();
            String semanticType = staxReader.getAttributeValue(null, "st");
            if (semanticType == null) {
                semanticType = defaultSemanticType;
            }
            literal.setSemanticType(semanticType);
            String dataType = staxReader.getAttributeValue(null, "t");
            String stringValue = staxReader.getElementText();
            this.setLiteralValue(literal, dataType, stringValue);
            attribute.addLiteral(literal);
            staxReader.nextTag();
        }
        if (this.isStartTag(staxReader, "An")) {
            if (literal == null) {
                literal = this._recordFactory.createLiteral();
            }
            this.readAnnotations(staxReader, attribute);
        }
    }

    private void readAnnotations(XMLStreamReader staxReader, Annotatable annotatable) throws XMLStreamException {
        while (this.isStartTag(staxReader, "An")) {
            this.readAnnotation(staxReader, annotatable);
            staxReader.nextTag();
        }
    }

    private void readAnnotation(XMLStreamReader staxReader, Annotatable annotatable) throws XMLStreamException {
        Annotation annotation = this._recordFactory.createAnnotation();
        String annotationName = staxReader.getAttributeValue(null, "n");
        staxReader.nextTag();
        while (this.isStartTag(staxReader, "V")) {
            String valueName = staxReader.getAttributeValue(null, "n");
            String value = staxReader.getElementText();
            if (valueName == null) {
                annotation.addAnonValue(value);
            } else {
                annotation.setNamedValue(valueName, value);
            }
            staxReader.nextTag();
        }
        while (this.isStartTag(staxReader, "An")) {
            this.readAnnotation(staxReader, annotation);
            staxReader.nextTag();
        }
        annotatable.addAnnotation(annotationName, annotation);
    }

    private void readAttachments(XMLStreamReader staxReader, Record record) throws XMLStreamException {
        while (this.isStartTag(staxReader, "Attachment")) {
            String attachmentName = staxReader.getElementText();
            if (attachmentName != null && attachmentName.length() > 0) {
                record.setAttachment(attachmentName, null);
            }
            staxReader.nextTag();
        }
    }

    private void setLiteralValue(Literal literal, String dataType, String stringValue) {
        if (StringUtils.isBlank((String)dataType)) {
            literal.setStringValue(stringValue);
        } else {
            try {
                if ("int".equals(dataType)) {
                    literal.setIntValue(Long.valueOf(stringValue));
                } else if ("fp".equals(dataType)) {
                    literal.setFpValue(Double.valueOf(stringValue));
                } else if ("bool".equals(dataType)) {
                    literal.setBoolValue(Boolean.valueOf(stringValue));
                } else if ("date".equals(dataType)) {
                    literal.setDateValue(this._literalHelper.parseDate(stringValue));
                } else if ("time".equals(dataType)) {
                    literal.setTimeValue(this._literalHelper.parseTime(stringValue));
                } else if ("datetime".equals(dataType)) {
                    literal.setDateTimeValue(this._literalHelper.parseDateTime(stringValue));
                }
            }
            catch (ParseException parseException) {
                literal.setStringValue(stringValue);
            }
        }
    }

    private boolean isStartTag(XMLStreamReader staxReader, String tagName) {
        return staxReader.isStartElement() && tagName.equals(staxReader.getLocalName());
    }
}

