/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.record.stax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.id.stax.IdWriter;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;

public class RecordWriter {
    private boolean _printPretty;
    private IdWriter _idWriter;

    public RecordWriter() {
        this(false);
    }

    public RecordWriter(boolean printPretty) {
        this._printPretty = printPretty;
        this._idWriter = new IdWriter(printPretty);
    }

    public void writeRecord(XMLStreamWriter staxWriter, Record record) throws XMLStreamException {
        this.writeRecord(staxWriter, record, true);
    }

    public void writeRecordList(XMLStreamWriter staxWriter, Iterable<Record> records) throws XMLStreamException {
        staxWriter.setDefaultNamespace("http://www.eclipse.org/smila/record");
        this.writeStartElement(staxWriter, "RecordList");
        staxWriter.writeDefaultNamespace("http://www.eclipse.org/smila/record");
        this.newline(staxWriter);
        for (Record record : records) {
            this.writeRecord(staxWriter, record, false);
        }
        this.writeEndElement(staxWriter);
    }

    private void writeRecord(XMLStreamWriter staxWriter, Record record, boolean addNamespace) throws XMLStreamException {
        staxWriter.setDefaultNamespace("http://www.eclipse.org/smila/record");
        this.writeStartElement(staxWriter, "Record");
        if (addNamespace) {
            staxWriter.writeDefaultNamespace("http://www.eclipse.org/smila/record");
        }
        staxWriter.writeAttribute("version", "1.0");
        this.newline(staxWriter);
        if (record.getId() != null) {
            this._idWriter.writeId(staxWriter, record.getId());
            staxWriter.setDefaultNamespace("http://www.eclipse.org/smila/record");
        }
        if (record.getMetadata() != null) {
            this.writeMetadata(staxWriter, record.getMetadata());
        }
        if (record.hasAttachments()) {
            Iterator<String> attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = attachmentNames.next();
                this.writeTextElement(staxWriter, "Attachment", attachmentName);
            }
        }
        this.writeEndElement(staxWriter);
    }

    private void writeMetadata(XMLStreamWriter staxWriter, MObject metadata) throws XMLStreamException {
        if (metadata.hasAttributes()) {
            Iterator<String> names = metadata.getAttributeNames();
            while (names.hasNext()) {
                String name = names.next();
                Attribute attribute = metadata.getAttribute(name);
                this.writeAttribute(staxWriter, attribute);
            }
        }
        this.writeAnnotations(staxWriter, metadata);
    }

    private void writeAttribute(XMLStreamWriter staxWriter, Attribute attribute) throws XMLStreamException {
        this.writeStartElement(staxWriter, "A");
        staxWriter.writeAttribute("n", attribute.getName());
        this.newline(staxWriter);
        if (attribute.hasAnnotations()) {
            this.writeAnnotations(staxWriter, attribute);
        }
        if (attribute.hasLiterals()) {
            ArrayList<Literal> annotatedLiterals = null;
            boolean unnanotatedLiteralsStarted = false;
            if (attribute.hasLiterals()) {
                for (Literal literal : attribute.getLiterals()) {
                    if (literal.hasAnnotations()) {
                        if (annotatedLiterals == null) {
                            annotatedLiterals = new ArrayList<Literal>();
                        }
                        annotatedLiterals.add(literal);
                        continue;
                    }
                    if (!unnanotatedLiteralsStarted) {
                        this.writeStartElement(staxWriter, "L");
                        this.newline(staxWriter);
                        unnanotatedLiteralsStarted = true;
                    }
                    this.writeLiteral(staxWriter, literal);
                }
            }
            if (unnanotatedLiteralsStarted) {
                this.writeEndElement(staxWriter);
            }
            if (annotatedLiterals != null) {
                for (Literal literal : attribute.getLiterals()) {
                    this.writeStartElement(staxWriter, "L");
                    this.newline(staxWriter);
                    this.writeLiteral(staxWriter, literal);
                    this.writeEndElement(staxWriter);
                }
            }
        }
        if (attribute.hasObjects()) {
            for (MObject object : attribute.getObjects()) {
                this.writeStartElement(staxWriter, "O");
                if (object.getSemanticType() != null) {
                    staxWriter.writeAttribute("st", object.getSemanticType());
                }
                this.writeMetadata(staxWriter, object);
                this.writeEndElement(staxWriter);
            }
        }
        this.writeEndElement(staxWriter);
    }

    private void writeLiteral(XMLStreamWriter staxWriter, Literal literal) throws XMLStreamException {
        if (literal.getValue() != null) {
            this.writeStartElement(staxWriter, "V");
            switch (literal.getDataType()) {
                case INT: {
                    staxWriter.writeAttribute("t", "int");
                    break;
                }
                case FP: {
                    staxWriter.writeAttribute("t", "fp");
                    break;
                }
                case BOOL: {
                    staxWriter.writeAttribute("t", "bool");
                    break;
                }
                case DATE: {
                    staxWriter.writeAttribute("t", "date");
                    break;
                }
                case TIME: {
                    staxWriter.writeAttribute("t", "time");
                    break;
                }
                case DATETIME: {
                    staxWriter.writeAttribute("t", "datetime");
                }
            }
            if (literal.getSemanticType() != null) {
                staxWriter.writeAttribute("st", literal.getSemanticType());
            }
            this.writeText(staxWriter, literal.getStringValue());
            this.writeEndElement(staxWriter);
            this.writeAnnotations(staxWriter, literal);
        }
    }

    private void writeAnnotations(XMLStreamWriter staxWriter, Annotatable annotated) throws XMLStreamException {
        if (annotated.hasAnnotations()) {
            Iterator<String> names = annotated.getAnnotationNames();
            while (names.hasNext()) {
                String name = names.next();
                Collection<Annotation> annotations = annotated.getAnnotations(name);
                for (Annotation annotation : annotations) {
                    this.writeAnnotation(staxWriter, name, annotation);
                }
            }
        }
    }

    private void writeAnnotation(XMLStreamWriter staxWriter, String name, Annotation annotation) throws XMLStreamException {
        this.writeStartElement(staxWriter, "An");
        staxWriter.writeAttribute("n", name);
        this.newline(staxWriter);
        if (annotation.hasAnonValues()) {
            for (String value : annotation.getAnonValues()) {
                this.writeTextElement(staxWriter, "V", value);
            }
        }
        if (annotation.hasNamedValues()) {
            Iterator<String> valueNames = annotation.getValueNames();
            while (valueNames.hasNext()) {
                String valueName = valueNames.next();
                this.writeStartElement(staxWriter, "V");
                staxWriter.writeAttribute("n", valueName);
                this.writeText(staxWriter, annotation.getNamedValue(valueName));
                this.writeEndElement(staxWriter);
            }
        }
        this.writeAnnotations(staxWriter, annotation);
        this.writeEndElement(staxWriter);
    }

    private void writeTextElement(XMLStreamWriter staxWriter, String tagName, String value) throws XMLStreamException {
        this.writeStartElement(staxWriter, tagName);
        this.writeText(staxWriter, value);
        this.writeEndElement(staxWriter);
    }

    private void writeText(XMLStreamWriter staxWriter, String value) throws XMLStreamException {
        staxWriter.writeCharacters(RecordWriter.cleanText(value));
    }

    private void writeStartElement(XMLStreamWriter staxWriter, String tagName) throws XMLStreamException {
        staxWriter.writeStartElement("http://www.eclipse.org/smila/record", tagName);
    }

    private void writeEndElement(XMLStreamWriter staxWriter) throws XMLStreamException {
        staxWriter.writeEndElement();
        this.newline(staxWriter);
    }

    private void newline(XMLStreamWriter staxWriter) throws XMLStreamException {
        if (this._printPretty) {
            staxWriter.writeCharacters("\n");
        }
    }

    protected static String cleanText(String text) {
        return StringUtils.replace((String)text, (String)"\u0000", (String)" ");
    }
}

