/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store.hib;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.store.ConfStoreConnectionFactory;
import org.apache.ode.store.Messages;
import org.apache.ode.store.hib.ConfStoreConnectionHib;
import org.apache.ode.store.hib.DeploymentUnitDaoImpl;
import org.apache.ode.store.hib.ProcessConfDaoImpl;
import org.apache.ode.store.hib.VersionTrackerDAOImpl;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.msg.MessageBundle;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;

public class DbConfStoreConnectionFactory
implements ConfStoreConnectionFactory {
    private static final Log __log = LogFactory.getLog(DbConfStoreConnectionFactory.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private static final String DEFAULT_HIBERNATE_DIALECT = "org.hibernate.dialect.DerbyDialect";
    private static final HashMap<String, DialectFactory.VersionInsensitiveMapper> HIBERNATE_DIALECTS = new HashMap();
    private static final String _guid = new GUID().toString();
    private static final Map<String, DataSource> _dataSources = new ConcurrentHashMap<String, DataSource>();
    private final DataSource _ds;
    final SessionFactory _sessionFactory;

    public DbConfStoreConnectionFactory(DataSource dataSource, Properties properties, boolean bl) {
        this._ds = dataSource;
        Properties properties2 = new Properties();
        for (Object object : properties.keySet()) {
            properties2.put(object, properties.get(object));
        }
        __log.debug((Object)("using data source: " + dataSource));
        _dataSources.put(_guid, dataSource);
        properties2.put("guid", _guid);
        properties2.put("hibernate.connection.provider_class", DataSourceConnectionProvider.class.getName());
        if (properties2.get("hibernate.dialect") == null) {
            try {
                properties2.put("hibernate.dialect", this.guessDialect(this._ds));
            }
            catch (Exception exception) {
                Object object;
                object = __msgs.msgOdeInitHibernateDialectDetectFailed();
                __log.error(object, (Throwable)exception);
                throw new BpelEngineException((String)object, (Throwable)exception);
            }
        }
        if (bl) {
            properties2.put("hibernate.hbm2ddl.auto", "create-drop");
        }
        this._sessionFactory = DbConfStoreConnectionFactory.getDefaultConfiguration().setProperties(properties2).buildSessionFactory();
    }

    public ConfStoreConnectionHib getConnection() {
        return new ConfStoreConnectionHib((Session)this._sessionFactory.openSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessDialect(DataSource dataSource) throws Exception {
        String string = null;
        Connection connection = dataSource.getConnection();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData != null) {
                String string2 = databaseMetaData.getDatabaseProductName();
                int n = databaseMetaData.getDatabaseMajorVersion();
                __log.info((Object)("Using database " + string2 + " major version " + n));
                DialectFactory.DatabaseDialectMapper databaseDialectMapper = (DialectFactory.DatabaseDialectMapper)HIBERNATE_DIALECTS.get(string2);
                if (databaseDialectMapper != null) {
                    string = databaseDialectMapper.getDialectClass(n);
                } else {
                    Dialect dialect = DialectFactory.determineDialect((String)string2, (int)n);
                    if (dialect != null) {
                        string = dialect.getClass().getName();
                    }
                }
            }
        }
        finally {
            connection.close();
        }
        if (string == null) {
            __log.info((Object)"Cannot determine hibernate dialect for this database: using the default one.");
            string = DEFAULT_HIBERNATE_DIALECT;
        }
        return string;
    }

    static Configuration getDefaultConfiguration() throws MappingException {
        return new Configuration().addClass(ProcessConfDaoImpl.class).addClass(DeploymentUnitDaoImpl.class).addClass(VersionTrackerDAOImpl.class);
    }

    static {
        HIBERNATE_DIALECTS.put("Apache Derby", new DialectFactory.VersionInsensitiveMapper(DEFAULT_HIBERNATE_DIALECT));
    }

    public static class DataSourceConnectionProvider
    implements ConnectionProvider {
        private String _guid;

        public void configure(Properties properties) throws HibernateException {
            this._guid = properties.getProperty("guid");
        }

        public Connection getConnection() throws SQLException {
            return ((DataSource)_dataSources.get(this._guid)).getConnection();
        }

        public void closeConnection(Connection connection) throws SQLException {
            connection.close();
        }

        public void close() throws HibernateException {
        }

        public boolean supportsAggressiveRelease() {
            return true;
        }
    }
}

