/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.extension.ExtensibleElement;
import org.apache.ode.bpel.rtrep.common.extension.ExtensionContext;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OExtensionActivity;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.utils.DOMUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.dom.RecordParser;
import org.eclipse.smila.datamodel.record.impl.AnnotatableImpl;
import org.eclipse.smila.ode.ODEServer;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.ProcessorMessage;
import org.eclipse.smila.processing.SearchMessage;
import org.eclipse.smila.processing.bpel.ExtensionAdapter;
import org.eclipse.smila.processing.bpel.MessageHelper;
import org.eclipse.smila.processing.bpel.ODEWorkflowProcessor;
import org.eclipse.smila.processing.bpel.ProcessingPerformanceCounter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ExtensionManager {
    private static final String TAG_SETANNOTATIONS = "setAnnotations";
    private static final RecordParser RECORD_PARSER = new RecordParser();
    private final Map<QName, ODEWorkflowProcessor> _ownerMap = new HashMap<QName, ODEWorkflowProcessor>();
    private final Map<String, ExtensionAdapter> _adapterMap = new HashMap<String, ExtensionAdapter>();
    private final Log _log = LogFactory.getLog(this.getClass());

    public void registerActivity(OExtensionActivity activity, ExtensibleElement element) {
        OProcess process = activity.getOwner();
        String key = this.getActivityKey((OActivity)activity);
        Element content = element.getNestedElement();
        ExtensionAdapter adapter = this.doRegisterActivity(process, activity, content, key);
        if (adapter != null) {
            adapter.setKey(key);
            adapter.setInputVariable(this.getAttributeOfElement(content, "variables", "input"));
            adapter.setOutputVariable(this.getAttributeOfElement(content, "variables", "output"));
            this.parseAnnotations(content, adapter);
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)(String.valueOf(key) + ": found " + adapter.getPrintName() + ", processing " + adapter.getInputVariable() + " -> " + adapter.getOutputVariable()));
            }
            this._adapterMap.put(key, adapter);
        }
    }

    public abstract ExtensionAdapter doRegisterActivity(OProcess var1, OExtensionActivity var2, Element var3, String var4);

    public void registerPipeline(ODEWorkflowProcessor processor, QName processName) {
        this._ownerMap.put(processName, processor);
    }

    public abstract String getExtensionName();

    public void invokeActivity(ExtensionContext context, Element element) {
        long startTime = System.nanoTime();
        ProcessingPerformanceCounter counter = null;
        boolean success = false;
        try {
            try {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("activity name = " + context.getActivityName()));
                    this._log.debug((Object)("process id = " + context.getProcessId()));
                }
                OActivity activity = context.getOActivity();
                String key = this.getActivityKey(activity);
                ExtensionAdapter adapter = this.getExtensionAdapter(key);
                ODEWorkflowProcessor processor = this.getProcessor(activity);
                counter = adapter.getCounter();
                this.invokeAdapter(context, key, adapter, processor);
                context.complete();
                success = true;
            }
            catch (Exception ex) {
                if (counter != null) {
                    counter.addError(ex, false);
                }
                context.completeWithFault((Throwable)ex);
                if (counter != null) {
                    counter.countInvocationNanos(System.nanoTime() - startTime, success, 0, 0);
                }
            }
        }
        finally {
            if (counter != null) {
                counter.countInvocationNanos(System.nanoTime() - startTime, success, 0, 0);
            }
        }
    }

    private void invokeAdapter(ExtensionContext context, String key, ExtensionAdapter adapter, ODEWorkflowProcessor processor) throws ProcessingException {
        String requestId = null;
        String inputVariableName = adapter.getInputVariable();
        String outputVariableName = adapter.getOutputVariable();
        if (outputVariableName == null) {
            outputVariableName = inputVariableName;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(String.valueOf(key) + ": invoking " + adapter.getPrintName() + ", processing " + inputVariableName + " -> " + outputVariableName));
        }
        ClassLoader tcclBackup = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ODEServer.class.getClassLoader());
        try {
            try {
                Element inputVariable = (Element)context.readVariable(inputVariableName);
                QName varType = this.getVariableType(context, inputVariableName);
                if (this._log.isDebugEnabled()) {
                    String inputVariableString = DOMUtils.domToString((Node)inputVariable);
                    this._log.debug((Object)(String.valueOf(key) + ": input = " + inputVariableString));
                }
                MessageHelper messageHelper = processor.getMessageHelper();
                requestId = messageHelper.parseRequestId(inputVariable);
                this.checkAvailability(adapter, processor);
                Blackboard blackboard = processor.getBlackboard(requestId);
                ProcessorMessage request = this.parseMessage(blackboard, inputVariable, varType, messageHelper);
                this.copyAnnotations(blackboard, request, (Annotatable)adapter);
                ProcessorMessage result = this.doInvoke(adapter, processor, blackboard, request);
                Element outputVariable = inputVariable;
                outputVariable = this.createMessage(blackboard, result, messageHelper);
                messageHelper.addRequestId(outputVariable, requestId, varType);
                if (this._log.isDebugEnabled()) {
                    String outputVariableString = DOMUtils.domToString((Node)outputVariable);
                    this._log.debug((Object)(String.valueOf(key) + ": output = " + outputVariableString));
                }
                context.writeVariable(outputVariableName, (Node)outputVariable);
            }
            catch (ProcessingException ex) {
                throw this.newProcessingException("processing", (Exception)((Object)ex), key, requestId, processor);
            }
            catch (BlackboardAccessException ex) {
                throw this.newProcessingException("blackboard access", (Exception)((Object)ex), key, requestId, processor);
            }
            catch (FaultException ex) {
                throw this.newProcessingException("BPEL variable access", (Exception)((Object)ex), key, requestId, processor);
            }
            catch (ExternalVariableModuleException ex) {
                throw this.newProcessingException("BPEL variable access", (Exception)((Object)ex), key, requestId, processor);
            }
            catch (RuntimeException ex) {
                throw this.newProcessingException("runtime", ex, key, requestId, processor);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcclBackup);
        }
    }

    private ProcessingException newProcessingException(String description, Exception cause, String key, String requestId, ODEWorkflowProcessor processor) {
        String message = null;
        ProcessingException procEx = null;
        if (cause instanceof ProcessingException) {
            message = "Invocation of pipeline element " + key + " failed: " + cause.getMessage();
            procEx = new ProcessingException(message, cause.getCause());
        } else {
            message = "Invocation of pipeline element " + key + " failed due to " + description + " error.";
            procEx = new ProcessingException(message, (Throwable)cause);
        }
        if (requestId != null) {
            processor.setPipeletException(requestId, (Exception)((Object)procEx));
        }
        return procEx;
    }

    public abstract void checkAvailability(ExtensionAdapter var1, ODEWorkflowProcessor var2) throws ProcessingException;

    public abstract ProcessorMessage doInvoke(ExtensionAdapter var1, ODEWorkflowProcessor var2, Blackboard var3, ProcessorMessage var4) throws ProcessingException;

    public String getActivityKey(OActivity activity) {
        return String.valueOf(activity.getOwner().getName()) + "/" + activity.name;
    }

    public Collection<ExtensionAdapter> getAdapters() {
        return Collections.unmodifiableCollection(this._adapterMap.values());
    }

    public ExtensionAdapter getExtensionAdapter(String key) throws ProcessingException {
        ExtensionAdapter adapter = this._adapterMap.get(key);
        if (adapter == null) {
            throw new ProcessingException("no registration found for activity " + key);
        }
        return adapter;
    }

    public ODEWorkflowProcessor getProcessor(OActivity activity) throws ProcessingException {
        QName processName = activity.getOwner().getQName();
        ODEWorkflowProcessor processor = this._ownerMap.get(processName);
        if (processor == null) {
            throw new ProcessingException("no owning processor found for " + this.getActivityKey(activity));
        }
        return processor;
    }

    public String getAttributeOfElement(Element content, String localName, String attribute) {
        String attributeValue = null;
        NodeList nodes = content.getElementsByTagNameNS("http://www.eclipse.org/smila/processor", localName);
        if (nodes.getLength() > 0 && StringUtils.isBlank((String)(attributeValue = ((Element)nodes.item(0)).getAttribute(attribute)))) {
            attributeValue = null;
        }
        return attributeValue;
    }

    public void parseAnnotations(Element content, AnnotatableImpl annotatable) {
        NodeList annotations = content.getElementsByTagNameNS("http://www.eclipse.org/smila/processor", TAG_SETANNOTATIONS);
        if (annotations != null && annotations.getLength() > 0) {
            int j = 0;
            while (j < annotations.getLength()) {
                Element setAnnotations = (Element)annotations.item(j);
                NodeList childs = setAnnotations.getChildNodes();
                int i = 0;
                while (i < childs.getLength()) {
                    Element element;
                    Node child = childs.item(i);
                    if (child instanceof Element && "An".equals((element = (Element)child).getLocalName())) {
                        RECORD_PARSER.parseAnnotation((Annotatable)annotatable, element);
                    }
                    ++i;
                }
                ++j;
            }
        }
    }

    public void copyAnnotations(Blackboard blackboard, ProcessorMessage message, Annotatable annotatable) throws BlackboardAccessException {
        if (annotatable.hasAnnotations()) {
            SearchMessage searchMessage;
            if (message instanceof SearchMessage && (searchMessage = (SearchMessage)message).hasQuery()) {
                this.copyAnnotations(blackboard, annotatable, searchMessage.getQuery());
            }
            if (message.hasRecords()) {
                Id[] idArray = message.getRecords();
                int n = idArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Id id = idArray[n2];
                    this.copyAnnotations(blackboard, annotatable, id);
                    ++n2;
                }
            }
        }
    }

    protected CompilationMessage createErrorCompilationMessage(String key, String message) {
        CompilationMessage msg = new CompilationMessage();
        msg.severity = (short)2;
        msg.phase = 0;
        msg.code = key;
        msg.messageText = message;
        return msg;
    }

    protected int getRecordCount(Id[] recordIds) {
        if (recordIds != null) {
            return recordIds.length;
        }
        return 0;
    }

    private QName getVariableType(ExtensionContext context, String variableName) {
        QName varType = MessageHelper.TYPE_PROCESSORMESSAGE;
        try {
            QName type;
            OScope.Variable variable = (OScope.Variable)context.getVisibleVariables().get(variableName);
            if (variable.type instanceof OMessageVarType && (type = ((OMessageVarType)variable.type).messageType) != null) {
                varType = type;
            }
        }
        catch (Exception exception) {
        }
        return varType;
    }

    private ProcessorMessage parseMessage(Blackboard blackboard, Element variable, QName varType, MessageHelper helper) {
        if (MessageHelper.TYPE_SEARCHMESSAGE.equals(varType)) {
            return helper.parseSearchMessage(blackboard, variable);
        }
        return helper.parseMessage(blackboard, variable);
    }

    private void copyAnnotations(Blackboard blackboard, Annotatable annotatable, Id id) throws BlackboardAccessException {
        Iterator names = annotatable.getAnnotationNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            blackboard.removeAnnotation(id, null, name);
            Collection annotations = annotatable.getAnnotations(name);
            for (Annotation annotation : annotations) {
                Annotation target = this.copyAnnotation(blackboard, id, annotation);
                blackboard.addAnnotation(id, null, name, target);
            }
        }
    }

    private Annotation copyAnnotation(Blackboard blackboard, Id id, Annotation annotation) throws BlackboardAccessException {
        Annotation target = blackboard.createAnnotation(id);
        if (annotation.hasAnonValues()) {
            target.setAnonValues(annotation.getAnonValues());
        }
        if (annotation.hasNamedValues()) {
            Iterator valueNames = annotation.getValueNames();
            while (valueNames.hasNext()) {
                String valueName = (String)valueNames.next();
                target.setNamedValue(valueName, annotation.getNamedValue(valueName));
            }
        }
        if (annotation.hasAnnotations()) {
            Iterator names = annotation.getAnnotationNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                Collection annotations = annotation.getAnnotations(name);
                for (Annotation subAnnotation : annotations) {
                    Annotation subTarget = this.copyAnnotation(blackboard, id, subAnnotation);
                    target.addAnnotation(name, subTarget);
                }
            }
        }
        return target;
    }

    private Element createMessage(Blackboard blackboard, ProcessorMessage message, MessageHelper helper) throws ProcessingException {
        if (message instanceof SearchMessage) {
            return helper.createSearchMessage(blackboard, (SearchMessage)message);
        }
        return helper.createMessage(blackboard, message);
    }
}

