/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.DOMUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.datamodel.record.dom.RecordBuilder;
import org.eclipse.smila.datamodel.record.dom.RecordParser;
import org.eclipse.smila.datamodel.tools.record.filter.RecordFilterNotFoundException;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.ProcessorMessage;
import org.eclipse.smila.processing.SearchMessage;
import org.eclipse.smila.processing.bpel.ODEWorkflowProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class MessageHelper {
    public static final QName TYPE_SEARCHMESSAGE = new QName("http://www.eclipse.org/smila/processor", "SearchProcessorMessage");
    public static final QName TYPE_PROCESSORMESSAGE = new QName("http://www.eclipse.org/smila/processor", "ProcessorMessage");
    private static final String NAME_MESSAGE = "message";
    private static final String PART_RECORDS = "records";
    private static final String PART_ID = "id";
    private static final String NAME_REQID = "ReqId";
    private static final String PROP_RECORD_FILTER = "record.filter";
    private final Log _log = LogFactory.getLog(ODEWorkflowProcessor.class);
    private final RecordBuilder _recordBuilder = new RecordBuilder();
    private final RecordParser _recordParser = new RecordParser();
    private Properties _properties;

    public MessageHelper(Properties properties) {
        this._properties = properties;
    }

    public String parseRequestId(Element message) {
        Element part = DOMUtils.getFirstChildElement((Element)message);
        Element idNode = DOMUtils.getFirstChildElement((Element)part);
        String requestId = idNode.getTextContent();
        return requestId;
    }

    public ProcessorMessage parseMessage(Blackboard blackboard, Element message) {
        ProcessorMessage processorMessage = new ProcessorMessage();
        Element recordsPart = this.findChildByName(message, PART_RECORDS);
        Element recordList = this.findChildByName(recordsPart, "RecordList");
        List workflowRecords = this._recordParser.parseRecordsIn(recordList);
        if (workflowRecords == null) {
            return null;
        }
        processorMessage.setRecords(this.synchronizeBlackboard(blackboard, workflowRecords));
        return processorMessage;
    }

    public SearchMessage parseSearchMessage(Blackboard blackboard, Element message) {
        Element recordList;
        SearchMessage searchMessage = new SearchMessage();
        Element recordsPart = this.findChildByName(message, PART_RECORDS);
        Element record = this.findChildByName(recordsPart, "Record");
        if (record != null) {
            Record workflowQuery = this._recordParser.parseRecordFrom(record);
            searchMessage.setQuery(workflowQuery.getId());
            try {
                blackboard.synchronize(workflowQuery);
            }
            catch (BlackboardAccessException e) {
                this._log.error((Object)("error syncing record " + workflowQuery.getId() + " with blackboard"), (Throwable)e);
            }
        }
        if ((recordList = this.findChildByName(recordsPart, "RecordList")) != null) {
            List workflowRecords = this._recordParser.parseRecordsIn(recordList);
            searchMessage.setRecords(this.synchronizeBlackboard(blackboard, workflowRecords));
        }
        return searchMessage;
    }

    public Element createMessage(Blackboard blackboard, ProcessorMessage procMessage) throws ProcessingException {
        List<Record> workflowRecords = this.createWorkflowObjects(blackboard, procMessage.getRecords());
        Document doc = DOMUtils.newDocument();
        Element message = doc.createElementNS(null, NAME_MESSAGE);
        Element part = doc.createElementNS(null, PART_RECORDS);
        message.appendChild(part);
        this._recordBuilder.appendRecordList(part, workflowRecords);
        return message;
    }

    public Element createSearchMessage(Blackboard blackboard, SearchMessage searchMessage) throws ProcessingException {
        Record workflowQuery = null;
        if (searchMessage.hasQuery()) {
            workflowQuery = this.createWorkflowRecord(blackboard, searchMessage.getQuery());
        }
        List<Record> workflowRecords = null;
        if (searchMessage.hasRecords()) {
            workflowRecords = this.createWorkflowObjects(blackboard, searchMessage.getRecords());
        }
        Document doc = DOMUtils.newDocument();
        Element message = doc.createElementNS(null, NAME_MESSAGE);
        Element recordsPart = doc.createElementNS(null, PART_RECORDS);
        message.appendChild(recordsPart);
        if (workflowQuery != null) {
            recordsPart.appendChild(this._recordBuilder.buildRecord(doc, workflowQuery));
        }
        message.appendChild(recordsPart);
        if (workflowRecords != null) {
            this._recordBuilder.appendRecordList(recordsPart, workflowRecords);
        }
        return message;
    }

    public void addRequestId(Element message, String requestId, QName varType) {
        Element idNode = this.createRequestIdNode(requestId, message.getOwnerDocument());
        Element parent = message;
        if (TYPE_SEARCHMESSAGE.equals(varType)) {
            parent = DOMUtils.getFirstChildElement((Element)message);
        } else {
            Element idPart = message.getOwnerDocument().createElementNS(null, PART_ID);
            idPart.appendChild(idNode);
            idNode = idPart;
        }
        if (DOMUtils.isEmptyElement((Element)parent)) {
            parent.appendChild(idNode);
        } else {
            parent.insertBefore(idNode, DOMUtils.getFirstChildElement((Element)parent));
        }
    }

    public boolean hasRecordFilter() {
        return this._properties.containsKey(PROP_RECORD_FILTER);
    }

    private Element findChildByName(Element parent, String name) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String nodeName;
            Node c = children.item(i);
            if (c.getNodeType() == 1 && name.equals(nodeName = c.getNodeName())) {
                return (Element)c;
            }
            ++i;
        }
        return null;
    }

    private List<Record> createWorkflowObjects(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds == null) {
            this._log.error((Object)"null list of ids passed to create workflow objects.");
            throw new ProcessingException("no list of ids passed to create workflow objects.");
        }
        ArrayList<Record> workflowRecords = new ArrayList<Record>(recordIds.length);
        Id[] idArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            Id id = idArray[n2];
            Record workflowRecord = this.createWorkflowRecord(blackboard, id);
            workflowRecords.add(workflowRecord);
            ++n2;
        }
        return workflowRecords;
    }

    private Record createWorkflowRecord(Blackboard blackboard, Id id) throws ProcessingException {
        if (id == null) {
            this._log.error((Object)"cannot create workflow object from null record id.");
            throw new ProcessingException("can not create workflow object from null record id.");
        }
        Record workflowRecord = null;
        String recordFilterName = this._properties.getProperty(PROP_RECORD_FILTER);
        if (recordFilterName != null) {
            try {
                workflowRecord = blackboard.getRecord(id, recordFilterName);
            }
            catch (RecordFilterNotFoundException ex) {
                this._log.error((Object)("unknown record filter name " + recordFilterName + " in workflow object creation."), (Throwable)ex);
                throw new ProcessingException("unknown record filter name " + recordFilterName + " in workflow object creation.", (Throwable)ex);
            }
            catch (BlackboardAccessException ex) {
                this._log.error((Object)("cannot create workflow object from record " + id), (Throwable)ex);
                throw new ProcessingException("cannot create workflow object from record " + id, (Throwable)ex);
            }
        }
        if (workflowRecord == null) {
            workflowRecord = RecordFactory.DEFAULT_INSTANCE.createRecord();
            workflowRecord.setId(id);
        }
        return workflowRecord;
    }

    private Id[] synchronizeBlackboard(Blackboard blackboard, List<Record> workflowRecords) {
        Id[] recordIds = new Id[workflowRecords.size()];
        int i = 0;
        while (i < recordIds.length) {
            Record record = workflowRecords.get(i);
            recordIds[i] = record.getId();
            try {
                blackboard.synchronize(record);
            }
            catch (BlackboardAccessException e) {
                this._log.error((Object)("error syncing record " + recordIds[i] + " with blackboard"), (Throwable)e);
            }
            ++i;
        }
        return recordIds;
    }

    private Element createRequestIdNode(String requestId, Document doc) {
        Element idNode = doc.createElementNS("http://www.eclipse.org/smila/processor", NAME_REQID);
        Text content = doc.createTextNode(requestId);
        idNode.appendChild(content);
        return idNode;
    }
}

