/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.rtrep.v2.OExtensionActivity;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.utils.DOMUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.ode.ODEServer;
import org.eclipse.smila.processing.IPipelet;
import org.eclipse.smila.processing.PipeletTrackerListener;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.ProcessorMessage;
import org.eclipse.smila.processing.SearchMessage;
import org.eclipse.smila.processing.SearchPipelet;
import org.eclipse.smila.processing.SimplePipelet;
import org.eclipse.smila.processing.bpel.ExtensionAdapter;
import org.eclipse.smila.processing.bpel.ExtensionManager;
import org.eclipse.smila.processing.bpel.ODEWorkflowProcessor;
import org.eclipse.smila.processing.bpel.PipeletInstance;
import org.eclipse.smila.processing.bpel.PipeletPerformanceCounter;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.configuration.PipeletConfigurationLoader;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PipeletManager
extends ExtensionManager
implements PipeletTrackerListener {
    private static final PipeletManager INSTANCE = new PipeletManager();
    private final Map<String, Class<? extends IPipelet>> _activePipeletClasses = new HashMap<String, Class<? extends IPipelet>>();
    private final Log _log = LogFactory.getLog(this.getClass());

    private PipeletManager() {
    }

    public static PipeletManager getInstance() {
        return INSTANCE;
    }

    public void registerAsListener(BundleContext context) {
        Hashtable properties = new Hashtable();
        context.registerService(PipeletTrackerListener.class.getName(), (Object)this, properties);
    }

    @Override
    public String getExtensionName() {
        return "invokePipelet";
    }

    @Override
    public PipeletInstance doRegisterActivity(OProcess pipelineProcess, OExtensionActivity activity, Element content, String key) {
        PipeletInstance instance = new PipeletInstance();
        instance.setClassName(this.getAttributeOfElement(content, "pipelet", "class"));
        if (instance.getClassName() == null) {
            throw new CompilationException(this.createErrorCompilationMessage(key, "Missing definition of pipelet class"));
        }
        try {
            instance.setConfiguration(this.parseConfiguration(content));
            if (instance.getConfiguration() == null) {
                this._log.info((Object)(String.valueOf(key) + ": no pipelet configuration found."));
            } else {
                this._log.info((Object)(String.valueOf(key) + ": pipelet configuration parsed."));
            }
        }
        catch (JAXBException ex) {
            throw new CompilationException(this.createErrorCompilationMessage(key, "Error parsing configuration"), (Throwable)ex);
        }
        String location = activity.name.substring(activity.name.lastIndexOf("line-"));
        instance.setCounter(new PipeletPerformanceCounter(pipelineProcess.getName(), instance.getClassName(), location));
        try {
            this.initPipeletInstance(instance);
        }
        catch (ProcessingException ex) {
            throw new CompilationException(this.createErrorCompilationMessage(key, "error initialising pipelet"), (Throwable)ex);
        }
        return instance;
    }

    @Override
    public void checkAvailability(ExtensionAdapter adapter, ODEWorkflowProcessor processor) throws ProcessingException {
        IPipelet pipelet = this.getPipelet(adapter);
        if (pipelet == null) {
            throw new ProcessingException("Pipelet of class " + ((PipeletInstance)adapter).getClassName() + " for activity " + adapter.getKey() + " is not yet instantiated.");
        }
    }

    @Override
    public ProcessorMessage doInvoke(ExtensionAdapter adapter, ODEWorkflowProcessor processor, Blackboard blackboard, ProcessorMessage request) throws ProcessingException {
        int incomingIds = 0;
        int outgoingIds = 0;
        try {
            IPipelet pipelet = this.getPipelet(adapter);
            if (pipelet instanceof SearchPipelet && request instanceof SearchMessage) {
                incomingIds = this.getRecordCount(((SearchMessage)request).getRecords()) + 1;
                SearchMessage result = ((SearchPipelet)pipelet).process(blackboard, (SearchMessage)request);
                outgoingIds = this.getRecordCount(result.getRecords()) + 1;
                SearchMessage searchMessage = result;
                return searchMessage;
            }
            if (pipelet instanceof SimplePipelet) {
                SimplePipelet simplePipelet = (SimplePipelet)pipelet;
                if (request instanceof SearchMessage && !((SearchMessage)request).hasRecords()) {
                    SearchMessage searchRequest = (SearchMessage)request;
                    if (searchRequest.hasQuery()) {
                        Id[] query = new Id[]{searchRequest.getQuery()};
                        incomingIds = 1;
                        Id[] result = simplePipelet.process(blackboard, query);
                        outgoingIds = this.getRecordCount(result);
                        if (result.length > 0) {
                            searchRequest.setQuery(query[0]);
                            if (result.length > 1) {
                                this._log.warn((Object)(String.valueOf(adapter.getPrintName()) + " has splitted a query object. Extra objects are ignored."));
                            }
                        }
                    }
                } else {
                    incomingIds = this.getRecordCount(request.getRecords());
                    Id[] result = simplePipelet.process(blackboard, request.getRecords());
                    outgoingIds = this.getRecordCount(result);
                    request.setRecords(result);
                }
                ProcessorMessage processorMessage = request;
                return processorMessage;
            }
            throw new ProcessingException("Could not invoke " + adapter.getPrintName() + "Either the pipelet class does not exist or you tried to invoke a search pipelet with a simple variable.");
        }
        finally {
            if (adapter.getCounter() != null) {
                adapter.getCounter().countIds(incomingIds, outgoingIds);
            }
        }
    }

    private IPipelet getPipelet(ExtensionAdapter adapter) {
        PipeletInstance instance = (PipeletInstance)adapter;
        return instance.getPipelet();
    }

    public void pipeletsAdded(Map<String, Class<? extends IPipelet>> pipeletClasses) {
        this._log.info((Object)("Pipelets have been added: " + pipeletClasses.keySet()));
        this._activePipeletClasses.putAll(pipeletClasses);
        for (ExtensionAdapter adapter : this.getAdapters()) {
            PipeletInstance instance = (PipeletInstance)adapter;
            try {
                this.initPipeletInstance(instance);
            }
            catch (ProcessingException ex) {
                this._log.error((Object)"error when initializing pending pipelet", (Throwable)ex);
            }
        }
    }

    public void pipeletsRemoved(Map<String, Class<? extends IPipelet>> pipeletClasses) {
        this._log.info((Object)("Pipelets have been removed: " + pipeletClasses.keySet()));
        for (ExtensionAdapter adapter : this.getAdapters()) {
            PipeletInstance instance = (PipeletInstance)adapter;
            if (!pipeletClasses.containsKey(instance.getClassName())) continue;
            instance.setPipelet(null);
        }
        for (String className : pipeletClasses.keySet()) {
            this._activePipeletClasses.remove(className);
        }
    }

    private void initPipeletInstance(PipeletInstance instance) throws ProcessingException {
        String className;
        if (instance.getPipelet() == null && this._activePipeletClasses.containsKey(className = instance.getClassName())) {
            Class<? extends IPipelet> pipeletClass = this._activePipeletClasses.get(className);
            try {
                SimplePipelet pipelet;
                IPipelet obj = pipeletClass.newInstance();
                if (obj instanceof SimplePipelet) {
                    pipelet = (SimplePipelet)obj;
                } else if (obj instanceof SearchPipelet) {
                    pipelet = (SearchPipelet)obj;
                } else {
                    throw new ProcessingException("error instantiating pipelet class. pipelet is neither simple nor search pipelet [" + className + "]");
                }
                if (instance.getConfiguration() != null) {
                    ClassLoader tcclBackup = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(ODEServer.class.getClassLoader());
                    try {
                        pipelet.configure(instance.getConfiguration());
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(tcclBackup);
                    }
                }
                instance.setPipelet((IPipelet)pipelet);
            }
            catch (InstantiationException e) {
                throw new ProcessingException("error instantiating pipelet class " + className, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ProcessingException("error instantiating pipelet class " + className, (Throwable)e);
            }
        }
    }

    private PipeletConfiguration parseConfiguration(Element content) throws JAXBException {
        PipeletConfiguration configuration = null;
        NodeList config = content.getElementsByTagNameNS("http://www.eclipse.org/smila/processor", "PipeletConfiguration");
        if (config.getLength() > 0) {
            String configString = DOMUtils.domToString((Node)config.item(0));
            Unmarshaller unmarshaller = PipeletConfigurationLoader.createPipeletConfigurationUnmarshaller((boolean)false);
            configuration = (PipeletConfiguration)unmarshaller.unmarshal((Reader)new StringReader(configString));
        }
        return configuration;
    }
}

