/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.compound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.Crawler;
import org.eclipse.smila.connectivity.framework.CrawlerCriticalException;
import org.eclipse.smila.connectivity.framework.CrawlerException;
import org.eclipse.smila.connectivity.framework.compound.CompoundCrawler;
import org.eclipse.smila.connectivity.framework.compound.CompoundException;
import org.eclipse.smila.connectivity.framework.compound.CompoundHandler;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.datamodel.record.Record;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

public abstract class AbstractCompoundHandler
implements CompoundHandler {
    private final Log _log = LogFactory.getLog(this.getClass());
    private ComponentFactory _compoundCrawlerFactory;

    public final void setCompoundCrawlerFactory(ComponentFactory factory) {
        this._compoundCrawlerFactory = factory;
        this._log.debug((Object)("REGISTERED FACTORY: " + factory.toString() + " - " + this.toString()));
    }

    public final void unsetCompoundCrawlerFactory(ComponentFactory factory) {
        if (this._compoundCrawlerFactory == factory) {
            this._compoundCrawlerFactory = null;
        }
        this._log.debug((Object)("UNREGISTERED FACTORY: " + factory.toString() + " - " + this.toString()));
    }

    @Override
    public final Crawler extract(Record record, DataSourceConnectionConfig config) throws CompoundException {
        try {
            CompoundCrawler compoundCrawler = this.createInstance();
            compoundCrawler.setCompoundRecord(record);
            compoundCrawler.initialize(config);
            return compoundCrawler;
        }
        catch (CrawlerException e) {
            String msg = "error during initialization of " + this.getFactoryComponentName(this._compoundCrawlerFactory);
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new CompoundException(msg, e);
        }
        catch (CrawlerCriticalException e) {
            String msg = "error during initialization of " + this.getFactoryComponentName(this._compoundCrawlerFactory);
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new CompoundException(msg, e);
        }
    }

    private CompoundCrawler createInstance() throws CrawlerException {
        try {
            ComponentInstance instance = this._compoundCrawlerFactory.newInstance(null);
            return (CompoundCrawler)instance.getInstance();
        }
        catch (Exception e) {
            String msg = "Could not create instance of CompoundCrawler " + this.getFactoryComponentName(this._compoundCrawlerFactory);
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new CrawlerException(msg);
        }
    }

    private String getFactoryComponentName(ComponentFactory factory) {
        String factoryName = factory.toString();
        if (factoryName != null) {
            return factoryName.substring(factoryName.lastIndexOf(" ") + 1, factoryName.length());
        }
        return null;
    }
}

