/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.performancecounters;

import java.util.Date;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgentBase;
import org.eclipse.smila.management.MeasureUnit;

public class CrawlerPerformanceAgent
extends ConnectivityPerformanceAgentBase {
    private Date _startDate;
    private Date _endDate;
    private String _jobId;

    @MeasureUnit(value="KBytes/Second")
    public double getAverageAttachmentTransferRate() {
        return this.getAttachmentBytesTransfered().getNextSampleValue() / (double)this.getLastRunTime() * 1000.0 / 1024.0;
    }

    @MeasureUnit(value="ms")
    public double getOverallAverageDeltaIndicesProcessingTime() {
        return (double)this.getLastRunTime() / this.getDeltaIndices().getNextSampleValue();
    }

    @MeasureUnit(value="ms")
    public double getOverallAverageRecordsProcessingTime() {
        return (double)this.getLastRunTime() / this.getRecords().getNextSampleValue();
    }

    private long getLastRunTime() {
        if (this._startDate == null) {
            return 0L;
        }
        if (this._startDate != null && this._endDate == null) {
            return System.currentTimeMillis() - this._startDate.getTime();
        }
        return this._endDate.getTime() - this._startDate.getTime();
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public void setStartDate(Date date) {
        this._startDate = date;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public void setEndDate(Date endDate) {
        this._endDate = endDate;
    }

    public String getJobId() {
        return this._jobId;
    }

    public void setJobId(String jobId) {
        this._jobId = jobId;
    }
}

