/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.converters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public class DateConverter
implements Converter {
    public static final String DATE_PATTERN = "dd.MM.yyyy HH:mm";
    public static final String SHORT_DATE_PATTERN = "dd.MM.yyyy";

    public Object convert(Class type, Object value) {
        if (value == null) {
            return null;
        }
        if (type == Date.class) {
            return this.convertToDate(type, value);
        }
        if (type == String.class) {
            return this.convertToString(type, value);
        }
        throw new ConversionException(String.format("Could not convert %s to %s", value.getClass().getName(), type.getName()));
    }

    protected Object convertToDate(Class type, Object value) {
        if (value instanceof String) {
            if ("".equals(value.toString())) {
                return null;
            }
            try {
                return new SimpleDateFormat(DATE_PATTERN).parse((String)value);
            }
            catch (ParseException parseException) {
                try {
                    return new SimpleDateFormat(SHORT_DATE_PATTERN).parse((String)value);
                }
                catch (ParseException parseException2) {
                    throw new ConversionException("Error converting String to Date");
                }
            }
        }
        throw new ConversionException(String.format("Could not convert %s to %s", value.getClass().getName(), type.getName()));
    }

    protected Object convertToString(Class type, Object value) {
        if (value instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN);
            return dateFormat.format(value);
        }
        return value.toString();
    }
}

