/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.configuration;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.crawler.web.auth.Authentication;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.FilterFactory;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.IFilter;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.WorkTypeFiltersCollection;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.impl.CrawlScopeFilter;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.CrawlScope;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.Filter;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.FilterType;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.FollowLinksType;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.WebSite;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.Outlink;

public class Configuration {
    public static final int MILLIS_PER_SECOND = 1000;
    private static final Log LOG = LogFactory.getLog(Configuration.class);
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_PROPERTIES_FILE = "webcrawler.properties";
    private Properties _defaultProperties = new Properties();
    private Properties _webSiteProperties;
    private FollowLinksType _followLinks;
    private CrawlScopeFilter _crawlScopeFilter;
    private WorkTypeFiltersCollection _urlFilters = new WorkTypeFiltersCollection();
    private WorkTypeFiltersCollection _contentTypeFilters = new WorkTypeFiltersCollection();
    private WorkTypeFiltersCollection _metaTagFilters = new WorkTypeFiltersCollection();
    private final Authentication _authentication = new Authentication();
    private final Set<Outlink> _seeds = new HashSet<Outlink>();

    public Configuration() throws IOException {
        InputStream defaultPropertiesInputStream = null;
        try {
            defaultPropertiesInputStream = this.getClass().getResourceAsStream(DEFAULT_PROPERTIES_FILE);
            if (defaultPropertiesInputStream == null) {
                throw new FileNotFoundException(DEFAULT_PROPERTIES_FILE);
            }
            this._defaultProperties.load(defaultPropertiesInputStream);
            this._webSiteProperties = new Properties(this._defaultProperties);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(defaultPropertiesInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)defaultPropertiesInputStream);
    }

    public Configuration(Properties defaultProperties) {
        this._defaultProperties = defaultProperties;
        this._webSiteProperties = new Properties(this._defaultProperties);
    }

    public void loadConfiguration(WebSite webSite) throws IllegalAccessException, InvocationTargetException {
        if (webSite != null) {
            WebSite.Proxy proxy;
            WebSite.Robotstxt robotstxt;
            WebSite.UserAgent userAgent;
            WebSite.CrawlingModel crawlingModel;
            this.setNotEmptyProperty("http.referer", webSite.getReferer());
            this.setNotEmptyProperty("http.headers", webSite.getHeader());
            this.setNotEmptyProperty("http.enable.cookies", String.valueOf(webSite.isEnableCookies()));
            this.setNotEmptyProperty("crawl.project.name", webSite.getProjectName());
            this.setNotEmptyProperty("fetcher.use.sitemaps", String.valueOf(webSite.isSitemaps()));
            WebSite.CrawlLimits crawlLimits = webSite.getCrawlLimits();
            if (crawlLimits != null) {
                WebSite.CrawlLimits.TimeoutLimits timeoutLimits;
                WebSite.CrawlLimits.WaitLimits waitLimits;
                WebSite.CrawlLimits.SizeLimits sizeLimits = crawlLimits.getSizeLimits();
                if (sizeLimits != null) {
                    this.setNotEmptyProperty("crawl.max.time", sizeLimits.getMaxTimeSec().toString());
                    this.setNotEmptyProperty("http.max.length.bytes", sizeLimits.getMaxLengthBytes().toString());
                    this.setNotEmptyProperty("fetcher.max.bytes", sizeLimits.getMaxBytesDownload().toString());
                    this.setNotEmptyProperty("fetcher.max.documents", sizeLimits.getMaxDocumentDownload().toString());
                }
                if ((waitLimits = crawlLimits.getWaitLimits()) != null) {
                    this.setNotEmptyProperty("crawl.wait", waitLimits.getWait().toString());
                    this.setNotEmptyProperty("crawl.random.wait", String.valueOf(waitLimits.isRandomWait()));
                    this.setNotEmptyProperty("fetcher.max.retries", waitLimits.getMaxRetries().toString());
                    this.setNotEmptyProperty("fetcher.wait.retry", waitLimits.getWaitRetry().toString());
                }
                if ((timeoutLimits = crawlLimits.getTimeoutLimits()) != null) {
                    this.setNotEmptyProperty("http.timeout", timeoutLimits.getTimeout().toString());
                    this.setNotEmptyProperty("http.connect.timeout", timeoutLimits.getConnectTimeout().toString());
                    this.setNotEmptyProperty("http.read.timeout", timeoutLimits.getReadTimeout().toString());
                }
            }
            if ((crawlingModel = webSite.getCrawlingModel()) != null) {
                this.setNotEmptyProperty("crawl.model.type", crawlingModel.getType().value());
                this.setNotEmptyProperty("crawl.model.value", crawlingModel.getValue().toString());
            }
            if ((userAgent = webSite.getUserAgent()) != null) {
                this.setNotEmptyProperty("http.agent.name", userAgent.getName());
                this.setNotEmptyProperty("http.agent.version", userAgent.getVersion());
                this.setNotEmptyProperty("http.agent.description", userAgent.getDescription());
                this.setNotEmptyProperty("http.agent.url", userAgent.getUrl());
                this.setNotEmptyProperty("http.agent.email", userAgent.getEmail());
            }
            if ((robotstxt = webSite.getRobotstxt()) != null) {
                if (webSite.getRobotstxt().getPolicy() != null) {
                    this.setNotEmptyProperty("http.robotstxt.policy", webSite.getRobotstxt().getPolicy().name());
                }
                this.setNotEmptyProperty("http.robotstxt.value", webSite.getRobotstxt().getValue());
                this.setNotEmptyProperty("http.robots.agents", webSite.getRobotstxt().getAgentNames());
            }
            if ((proxy = webSite.getProxy()) != null) {
                this.setNotEmptyProperty("http.proxy.host", proxy.getProxyServer().getHost());
                this.setNotEmptyProperty("http.proxy.port", proxy.getProxyServer().getPort());
                this.setNotEmptyProperty("http.proxy.login", proxy.getProxyServer().getLogin());
                this.setNotEmptyProperty("http.proxy.password", proxy.getProxyServer().getPassword());
            }
            if (webSite.getAuthentication() != null) {
                BeanUtils.copyProperties((Object)this._authentication, (Object)webSite.getAuthentication());
            }
        } else {
            throw new IllegalArgumentException("WebSite can't be null");
        }
        this._followLinks = webSite.getSeeds().getFollowLinks();
        this.setSeeds(webSite.getSeeds().getSeed());
        this.setFilters(webSite);
    }

    private void setNotEmptyProperty(String key, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            this._webSiteProperties.setProperty(key, value);
        }
    }

    public String get(String key) {
        return this._webSiteProperties.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        return this._webSiteProperties.getProperty(key, defaultValue);
    }

    public int getInt(String key) {
        String value = this._webSiteProperties.getProperty(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return Integer.valueOf(value);
        }
        return 0;
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this._webSiteProperties.getProperty(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.valueOf(this._webSiteProperties.getProperty(key, String.valueOf(defaultValue)));
    }

    public Object getObject(String name) {
        return this._webSiteProperties.get(name);
    }

    public void setObject(String name, Object value) {
        this._webSiteProperties.put(name, value);
    }

    public WorkTypeFiltersCollection getUrlFilters() {
        return this._urlFilters;
    }

    public void setUrlFilters(WorkTypeFiltersCollection filters) {
        this._urlFilters = filters;
    }

    public FollowLinksType getFollowLinks() {
        return this._followLinks;
    }

    public void setFollowLinks(FollowLinksType links) {
        this._followLinks = links;
    }

    private void setFilters(WebSite webSite) throws IllegalAccessException, InvocationTargetException {
        FilterFactory filterFactory = new FilterFactory(this);
        if (webSite.getFilters() != null) {
            List<WebSite.Filters.Filter> dFilters = webSite.getFilters().getFilter();
            for (Filter filter : dFilters) {
                IFilter<?> iFilter = filterFactory.getFilter(filter.getType());
                BeanUtils.copyProperties(iFilter, (Object)filter);
                if (filter.getType().equals((Object)FilterType.CONTENT_TYPE)) {
                    this._contentTypeFilters.add(iFilter);
                    continue;
                }
                this._urlFilters.add(iFilter);
            }
        }
        if (webSite.getMetaTagFilters() != null) {
            List<WebSite.MetaTagFilters.MetaTagFilter> dMetaTagFilters = webSite.getMetaTagFilters().getMetaTagFilter();
            for (WebSite.MetaTagFilters.MetaTagFilter metaTagFilter : dMetaTagFilters) {
                IFilter<?> iFilter = filterFactory.getFilter(FilterType.HTML_META_TAG);
                BeanUtils.copyProperties(iFilter, (Object)metaTagFilter);
                this._metaTagFilters.add(iFilter);
            }
        }
        this._crawlScopeFilter = (CrawlScopeFilter)filterFactory.getFilter(FilterType.CRAWL_SCOPE);
        this._crawlScopeFilter.setSeeds(this._seeds);
        WebSite.CrawlScope crawlScope = webSite.getCrawlScope();
        if (crawlScope != null) {
            this._crawlScopeFilter.setCrawlScope(webSite.getCrawlScope().getType());
            WebSite.CrawlScope.Filters filters = webSite.getCrawlScope().getFilters();
            if (filters != null) {
                List<WebSite.CrawlScope.Filters.Filter> dFilters = filters.getFilter();
                for (Filter filter : dFilters) {
                    IFilter<?> filter2 = filterFactory.getFilter(filter.getType());
                    BeanUtils.copyProperties(filter2, (Object)filter);
                    this._crawlScopeFilter.getUrlFilters().add(filter2);
                }
            }
        } else {
            this._crawlScopeFilter.setCrawlScope(CrawlScope.HOST);
        }
    }

    private void setSeeds(List<String> seeds) {
        for (String seed : seeds) {
            try {
                this._seeds.add(new Outlink(seed, seed, this));
            }
            catch (MalformedURLException malformedURLException) {
                LOG.error((Object)("bad seed url:" + seed));
            }
        }
    }

    public Set<Outlink> getSeeds() {
        return this._seeds;
    }

    public CrawlScopeFilter getCrawlScopeFilter() {
        return this._crawlScopeFilter;
    }

    public void setCrawlScopeFilter(CrawlScopeFilter scopeFilter) {
        this._crawlScopeFilter = scopeFilter;
    }

    public WorkTypeFiltersCollection getMetaTagFilters() {
        return this._metaTagFilters;
    }

    public void setMetaTagFilters(WorkTypeFiltersCollection tagFilters) {
        this._metaTagFilters = tagFilters;
    }

    public WorkTypeFiltersCollection getContentTypeFilters() {
        return this._contentTypeFilters;
    }

    public void setContentTypeFilters(WorkTypeFiltersCollection filters) {
        this._contentTypeFilters = filters;
    }

    public Authentication getAuthentication() {
        return this._authentication;
    }
}

