/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;

public final class RequestUtil {
    private RequestUtil() {
    }

    public static StringBuffer createQueryStringFromMap(Map<?, ?> m, String ampersand, boolean encode) {
        StringBuffer result = new StringBuffer("");
        Set<Map.Entry<?, ?>> entrySet = m.entrySet();
        for (Map.Entry<?, ?> entry : entrySet) {
            Object o = entry.getValue();
            if (o == null) {
                RequestUtil.append(entry.getKey(), "", result, ampersand, encode);
                continue;
            }
            if (o instanceof String) {
                RequestUtil.append(entry.getKey(), o, result, ampersand, encode);
                continue;
            }
            if (o instanceof String[]) {
                String[] values = (String[])o;
                int i = 0;
                while (i < values.length) {
                    RequestUtil.append(entry.getKey(), values[i], result, ampersand, encode);
                    ++i;
                }
                continue;
            }
            RequestUtil.append(entry.getKey(), o, result, ampersand, encode);
        }
        return result;
    }

    public static StringBuffer createQueryStringFromMap(Map<?, ?> m, String ampersand) {
        return RequestUtil.createQueryStringFromMap(m, ampersand, true);
    }

    public static String appendParams(String uri, Map<?, ?> params) {
        String delim = uri.indexOf(63) == -1 ? "?" : "&";
        return String.valueOf(uri) + delim + RequestUtil.createQueryStringFromMap(params, "&").toString();
    }

    private static StringBuffer append(Object key, Object value, StringBuffer queryString, String ampersand, boolean encode) {
        if (queryString.length() > 0) {
            queryString.append(ampersand);
        }
        try {
            if (encode) {
                key = URLEncoder.encode(key.toString(), "UTF-8");
                value = URLEncoder.encode(value.toString(), "UTF-8");
            }
            queryString.append(key);
            queryString.append("=");
            queryString.append(value);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return queryString;
    }
}

