/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.listener;

import java.util.Enumeration;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import org.eclipse.smila.connectivity.queue.worker.ListenerException;
import org.eclipse.smila.connectivity.queue.worker.ListenerRule;
import org.eclipse.smila.connectivity.queue.worker.Operation;
import org.eclipse.smila.connectivity.queue.worker.config.ListenerRuleType;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractLoggedComponent;
import org.eclipse.smila.connectivity.queue.worker.internal.ServicesAccessPoint;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.tools.DatamodelSerializationUtils;
import org.eclipse.smila.utils.log.RecordLifecycleLogHelper;

public class ListenerWorker
extends AbstractLoggedComponent
implements Runnable {
    private static final int MS = 1000;
    private final ServicesAccessPoint _accessPoint;
    private final ListenerRuleType _ruleConfig;
    private Connection _connection;
    private Session _session;
    private Queue _queue;
    private MessageConsumer _consumer;
    private boolean _stop;
    private final ListenerRule _rule;

    public ListenerWorker(ListenerRule rule, ServicesAccessPoint accessPoint, ListenerRuleType ruleConfig, int number) {
        super(String.format("%s, thread:%d", ruleConfig.getName(), number));
        this._rule = rule;
        this._accessPoint = accessPoint;
        this._ruleConfig = ruleConfig;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)this.msg("Started"));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void suggestToStop() {
        this._stop = true;
    }

    private void initialize() {
        try {
            this._stop = false;
            this._connection = this._accessPoint.getBrokerConnections().getConnection(this._ruleConfig.getSource(), false);
            this._connection.start();
            this._session = this._connection.createSession(true, 1);
            this._queue = this._session.createQueue(this._ruleConfig.getSource().getQueue());
            this._consumer = this._session.createConsumer((Destination)this._queue, this._ruleConfig.getCondition());
        }
        catch (Throwable e) {
            this._log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private Message recieveMessage(boolean wait) {
        Message message = null;
        try {
            message = wait ? this._consumer.receive((long)(this._ruleConfig.getWaitMessageTimeout() * 1000)) : this._consumer.receiveNoWait();
        }
        catch (JMSException e) {
            this._log.error((Object)this.msg("Error during recieving message"), (Throwable)e);
            this.rollbackSessionQuietly();
        }
        return message;
    }

    private Record parseMessage(Message message, Properties messageProperties) throws ListenerException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)this.msg("Processing JMS message..."));
        }
        if (!(message instanceof BytesMessage)) {
            throw new ListenerException(this.msg("Message is not a ByteMessage"));
        }
        try {
            Operation operation;
            BytesMessage byteMessage = (BytesMessage)message;
            byte[] byteArray = new byte[(int)byteMessage.getBodyLength()];
            byteMessage.readBytes(byteArray);
            if (this._log.isDebugEnabled()) {
                try {
                    this._log.debug((Object)this.msg("Accepted bytes as STRING: " + new String(byteArray)));
                }
                catch (Exception e) {
                    this._log.error((Object)e);
                }
            }
            Record record = DatamodelSerializationUtils.deserialize((byte[])byteArray);
            Enumeration names = byteMessage.getPropertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = byteMessage.getStringProperty(name);
                messageProperties.setProperty(name, value);
            }
            String operationStr = messageProperties.getProperty("Operation");
            try {
                operation = Operation.valueOf((String)operationStr);
            }
            catch (Throwable throwable) {
                operation = Operation.NONE;
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)this.msg(String.format("processMessage: Operation=%s; %s", operation.toString(), DatamodelSerializationUtils.serialize2string((Record)record))));
            }
            if (RecordLifecycleLogHelper.isRecordStateLogEnabled()) {
                RecordLifecycleLogHelper.logRecordState((String)("Record is processed by Listener with rule: [" + this._ruleConfig.getName() + "] and operation [" + operation.name() + "]"), (String)record.getId().getIdHash());
            }
            return record;
        }
        catch (Exception e) {
            throw new ListenerException(this.msg("processMessage"), (Throwable)e);
        }
    }

    private void rollbackSessionQuietly() {
        try {
            this._session.rollback();
        }
        catch (JMSException e1) {
            this._log.error((Object)this.msg("JMSException"), (Throwable)e1);
        }
    }
}

