/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.recycler;

import java.util.HashMap;
import java.util.Properties;
import javax.jms.Message;
import org.eclipse.smila.connectivity.queue.worker.Operation;
import org.eclipse.smila.connectivity.queue.worker.RecordRecyclerException;
import org.eclipse.smila.connectivity.queue.worker.config.RecordRecyclerRuleType;
import org.eclipse.smila.connectivity.queue.worker.config.TaskListType;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractRule;
import org.eclipse.smila.connectivity.queue.worker.internal.ServicesAccessPoint;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.jms.MessageSelectorEvalException;
import org.eclipse.smila.jms.MessageSelectorEvalHelper;
import org.eclipse.smila.utils.log.RecordLifecycleLogHelper;

public class RecyclerRule
extends AbstractRule<RecordRecyclerRuleType> {
    private final MessageSelectorEvalHelper _evalHelper;

    public RecyclerRule(ServicesAccessPoint accessPoint, RecordRecyclerRuleType ruleConfig) throws RecordRecyclerException {
        super(accessPoint, ruleConfig);
        try {
            this._evalHelper = new MessageSelectorEvalHelper(ruleConfig.getCondition());
        }
        catch (MessageSelectorEvalException e) {
            throw new RecordRecyclerException((Throwable)e);
        }
    }

    public boolean isApplied(Message message) throws RecordRecyclerException {
        try {
            return this._evalHelper.evaluate(message);
        }
        catch (MessageSelectorEvalException e) {
            throw new RecordRecyclerException((Throwable)e);
        }
    }

    public void process(Record record) throws RecordRecyclerException {
        HashMap<Record, Properties> recordPropertyMap = new HashMap<Record, Properties>();
        Properties messageProperties = new Properties();
        messageProperties.setProperty("Operation", Operation.ADD.name());
        recordPropertyMap.put(record, messageProperties);
        try {
            this._accessPoint.getTaskListExecutionService().execute(this._accessPoint, (TaskListType)((RecordRecyclerRuleType)this._ruleConfig).getTask(), recordPropertyMap);
            if (RecordLifecycleLogHelper.isRecordStateLogEnabled()) {
                RecordLifecycleLogHelper.logRecordState((String)("Record processing is repeated by rule [" + ((RecordRecyclerRuleType)this._ruleConfig).getName() + "] and operation [" + Operation.ADD.name() + "]"), (String)record.getId().getIdHash());
            }
        }
        catch (Throwable e) {
            throw new RecordRecyclerException(e);
        }
    }
}

