/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.router;

import java.util.Map;
import java.util.Properties;
import javax.jms.Message;
import org.eclipse.smila.connectivity.queue.worker.Operation;
import org.eclipse.smila.connectivity.queue.worker.RouterException;
import org.eclipse.smila.connectivity.queue.worker.config.RouterRuleType;
import org.eclipse.smila.connectivity.queue.worker.config.TaskListType;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractRule;
import org.eclipse.smila.connectivity.queue.worker.internal.ServicesAccessPoint;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.jms.MessageSelectorEvalException;
import org.eclipse.smila.jms.MessageSelectorEvalHelper;
import org.eclipse.smila.utils.log.RecordLifecycleLogHelper;

public class RouterRule
extends AbstractRule<RouterRuleType> {
    private final MessageSelectorEvalHelper _evalHelper;

    public RouterRule(ServicesAccessPoint accessPoint, RouterRuleType ruleConfig) throws RouterException {
        super(accessPoint, ruleConfig);
        try {
            this._evalHelper = new MessageSelectorEvalHelper(ruleConfig.getCondition());
        }
        catch (MessageSelectorEvalException e) {
            throw new RouterException((Throwable)e);
        }
    }

    public boolean isApplied(Message message) throws RouterException {
        try {
            return this._evalHelper.evaluate(message);
        }
        catch (Throwable e) {
            throw new RouterException(e);
        }
    }

    public void route(Map<Record, Properties> recordPropertyMap) throws RouterException {
        try {
            this._accessPoint.getTaskListExecutionService().execute(this._accessPoint, (TaskListType)((RouterRuleType)this._ruleConfig).getTask(), recordPropertyMap);
            if (RecordLifecycleLogHelper.isRecordStateLogEnabled()) {
                for (Record record : recordPropertyMap.keySet()) {
                    Properties props = recordPropertyMap.get(record);
                    RecordLifecycleLogHelper.logRecordState((String)("Record is routed with rule [" + ((RouterRuleType)this._ruleConfig).getName() + "] and operation [" + props.getProperty(Operation.ADD.name()) + "]"), (String)record.getId().getIdHash());
                }
            }
        }
        catch (Throwable e) {
            throw new RouterException(e);
        }
    }
}

