/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.task;

import java.util.Map;
import java.util.Properties;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractLoggedComponent;
import org.eclipse.smila.connectivity.queue.worker.internal.task.TaskExecutionEnv;
import org.eclipse.smila.connectivity.queue.worker.internal.task.TaskExecutionException;
import org.eclipse.smila.connectivity.queue.worker.internal.task.TaskExecutionService;
import org.eclipse.smila.datamodel.id.Id;

public abstract class AbstractTask<ConfigType>
extends AbstractLoggedComponent
implements TaskExecutionService<ConfigType> {
    public AbstractTask(String id) {
        super(id);
    }

    @Override
    public Id[] execute(TaskExecutionEnv env, ConfigType config, Map<Id, Properties> idPropertyMap) throws TaskExecutionException {
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)this.msg("Executing.."));
            }
            Id[] ids = this.executeInternal(env, config, idPropertyMap);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)this.msg("Executed"));
            }
            return ids;
        }
        catch (TaskExecutionException e) {
            this._log.error((Object)this.msg("Error"), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            this._log.error((Object)this.msg("Error"), e);
            throw new TaskExecutionException(e);
        }
    }

    protected abstract Id[] executeInternal(TaskExecutionEnv var1, ConfigType var2, Map<Id, Properties> var3) throws Exception;
}

