/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.task;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.connectivity.queue.worker.config.ListenerTaskListType;
import org.eclipse.smila.connectivity.queue.worker.config.ProcessType;
import org.eclipse.smila.connectivity.queue.worker.config.SendType;
import org.eclipse.smila.connectivity.queue.worker.config.TaskListType;
import org.eclipse.smila.connectivity.queue.worker.internal.ServicesAccessPoint;
import org.eclipse.smila.connectivity.queue.worker.internal.task.TaskExecutionEnv;
import org.eclipse.smila.connectivity.queue.worker.internal.task.TaskExecutionException;
import org.eclipse.smila.connectivity.queue.worker.internal.task.TaskExecutionService;
import org.eclipse.smila.connectivity.queue.worker.internal.task.impl.Process;
import org.eclipse.smila.connectivity.queue.worker.internal.task.impl.Send;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Record;

public class TaskListExecutionService {
    private final Map<Class, TaskExecutionService> _tasks = new HashMap<Class, TaskExecutionService>();

    public TaskListExecutionService() {
        this._tasks.put(ProcessType.class, new Process());
        this._tasks.put(SendType.class, new Send());
    }

    public void execute(ServicesAccessPoint accessPoint, TaskListType taskList, Map<Record, Properties> recordPropertyMap) throws TaskExecutionException, BlackboardAccessException {
        if (taskList != null) {
            Blackboard taskBlackboard = accessPoint.getBlackboardService(taskList.isBlackboardSync());
            TaskExecutionEnv env = new TaskExecutionEnv(accessPoint, taskBlackboard);
            try {
                env.setCommitRequired(false);
                HashMap<Id, Properties> idPropertyMap = new HashMap<Id, Properties>();
                for (Record record : recordPropertyMap.keySet()) {
                    idPropertyMap.put(record.getId(), recordPropertyMap.get(record));
                    if (this.isInitiallySet(taskList)) {
                        env.getBlackboard().setRecord(record);
                        continue;
                    }
                    env.getBlackboard().synchronize(record);
                }
                for (Object object : taskList.getProcessOrSend()) {
                    TaskExecutionService taskExecutionService = this._tasks.get(object.getClass());
                    if (taskExecutionService == null) {
                        throw new RuntimeException("Unknown task " + object.getClass().getName());
                    }
                    taskExecutionService.execute(env, object, idPropertyMap);
                }
            }
            finally {
                if (env.isCommitRequired()) {
                    env.getBlackboard().commit();
                } else {
                    env.getBlackboard().invalidate();
                }
            }
        }
    }

    private boolean isInitiallySet(TaskListType taskList) {
        boolean isInitiallySet = true;
        if (taskList instanceof ListenerTaskListType) {
            ListenerTaskListType listenerTaskList = (ListenerTaskListType)taskList;
            isInitiallySet = listenerTaskList.isInitiallySet();
        }
        return isInitiallySet;
    }
}

