/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network.jms;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.naming.NamingException;
import org.apache.activemq.Service;
import org.apache.activemq.network.jms.JmsConnector;
import org.apache.activemq.network.jms.JmsMesageConvertor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DestinationBridge
implements Service,
MessageListener {
    private static final Log LOG = LogFactory.getLog(DestinationBridge.class);
    protected MessageConsumer consumer;
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected JmsMesageConvertor jmsMessageConvertor;
    protected boolean doHandleReplyTo = true;
    protected JmsConnector jmsConnector;
    private int maximumRetries = 10;

    public MessageConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    public void setJmsConnector(JmsConnector connector) {
        this.jmsConnector = connector;
    }

    public JmsMesageConvertor getJmsMessageConvertor() {
        return this.jmsMessageConvertor;
    }

    public void setJmsMessageConvertor(JmsMesageConvertor jmsMessageConvertor) {
        this.jmsMessageConvertor = jmsMessageConvertor;
    }

    public int getMaximumRetries() {
        return this.maximumRetries;
    }

    public void setMaximumRetries(int maximumRetries) {
        this.maximumRetries = maximumRetries;
    }

    protected Destination processReplyToDestination(Destination destination) {
        return this.jmsConnector.createReplyToBridge(destination, this.getConnnectionForConsumer(), this.getConnectionForProducer());
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            MessageConsumer consumer = this.createConsumer();
            consumer.setMessageListener((MessageListener)this);
            this.createProducer();
        }
    }

    public void stop() throws Exception {
        this.started.set(false);
    }

    public void onMessage(Message message) {
        block8: {
            if (this.started.get() && message != null) {
                int attempt = 0;
                try {
                    Message converted;
                    if (attempt > 0) {
                        this.restartProducer();
                    }
                    if (this.doHandleReplyTo) {
                        Destination replyTo = message.getJMSReplyTo();
                        converted = replyTo != null ? this.jmsMessageConvertor.convert(message, this.processReplyToDestination(replyTo)) : this.jmsMessageConvertor.convert(message);
                    } else {
                        message.setJMSReplyTo(null);
                        converted = this.jmsMessageConvertor.convert(message);
                    }
                    this.sendMessage(converted);
                    message.acknowledge();
                }
                catch (Exception e) {
                    LOG.error((Object)("failed to forward message on attempt: " + ++attempt + " reason: " + e + " message: " + message), (Throwable)e);
                    if (this.maximumRetries <= 0 || attempt < this.maximumRetries) break block8;
                    try {
                        this.stop();
                    }
                    catch (Exception e1) {
                        LOG.warn((Object)"Failed to stop cleanly", (Throwable)e1);
                    }
                }
            }
        }
    }

    protected boolean isDoHandleReplyTo() {
        return this.doHandleReplyTo;
    }

    protected void setDoHandleReplyTo(boolean doHandleReplyTo) {
        this.doHandleReplyTo = doHandleReplyTo;
    }

    protected abstract MessageConsumer createConsumer() throws JMSException;

    protected abstract MessageProducer createProducer() throws JMSException;

    protected abstract void sendMessage(Message var1) throws JMSException;

    protected abstract Connection getConnnectionForConsumer();

    protected abstract Connection getConnectionForProducer();

    protected void restartProducer() throws JMSException, NamingException {
        try {
            this.getConnectionForProducer().close();
        }
        catch (Exception e) {
            LOG.debug((Object)("Ignoring failure to close producer connection: " + e), (Throwable)e);
        }
        this.jmsConnector.restartProducerConnection();
        this.createProducer();
    }
}

