/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.configuration;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.configuration.PropertyAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"_properties"}, namespace="http://www.eclipse.org/smila/processor")
@XmlRootElement(name="PipeletConfiguration", namespace="http://www.eclipse.org/smila/processor")
public class PipeletConfiguration {
    @XmlElement(name="Property", required=false, namespace="http://www.eclipse.org/smila/processor")
    private List<Property> _properties;

    public Object getPropertyFirstValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this._properties != null) {
            for (Property property : this._properties) {
                if (!name.equals(property.getName()) || property.getValue() == null) continue;
                return property.getValue();
            }
        }
        return null;
    }

    public boolean hasPropertyValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this._properties != null) {
            for (Property property : this._properties) {
                if (!name.equals(property.getName()) || property.getValue() == null) continue;
                return true;
            }
        }
        return false;
    }

    public Object[] getPropertyValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this._properties != null) {
            for (Property property : this._properties) {
                if (!name.equals(property.getName()) || property.getValues() == null) continue;
                return property.getValues().toArray(new Object[property.getValues().size()]);
            }
        }
        return new Object[0];
    }

    public String[] getPropertyStringValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this._properties != null) {
            for (Property property : this._properties) {
                if (!name.equals(property.getName()) || property.getValues() == null) continue;
                for (Object value : property.getValues()) {
                    if (value == null) continue;
                    list.add(value.toString());
                }
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public Object getPropertyFirstValueNotNull(String name) throws ProcessingException {
        Object value = this.getPropertyFirstValue(name);
        if (value == null) {
            throw new ProcessingException("property requires a defined value [" + name + "]");
        }
        return value;
    }

    public List<Property> getProperties() {
        return this._properties;
    }

    @XmlJavaTypeAdapter(value=PropertyAdapter.class)
    public static class Property {
        private final String _name;
        private final List<Object> _values;

        public Property(String name, Object singleValue) {
            this._name = name;
            this._values = new ArrayList<Object>();
            this._values.add(singleValue);
        }

        public Property(String name, List<Object> values) {
            this._name = name;
            this._values = values;
        }

        public String getName() {
            return this._name;
        }

        public List<Object> getValues() {
            return this._values;
        }

        public Object getValue() {
            if (this._values != null && !this._values.isEmpty()) {
                return this._values.get(0);
            }
            return null;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"_name", "_type", "_values"}, namespace="http://www.eclipse.org/smila/processor")
    static class PropertySource {
        @XmlAttribute(name="name", required=true)
        private String _name;
        @XmlAttribute(name="type", required=true)
        private String _type;
        @XmlElement(name="Value", required=false, namespace="http://www.eclipse.org/smila/processor")
        private List<String> _values;

        PropertySource() {
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getType() {
            return this._type;
        }

        public void setType(String type) {
            this._type = type;
        }

        public List<String> getValues() {
            return this._values;
        }
    }
}

