/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.utils.config.ConfigurationLoadException;
import org.osgi.framework.Bundle;

public final class ConfigUtils {
    public static final String PROPERTY_CONFIG_ROOT = "org.eclipse.smila.utils.config.root";
    private static final String CONFIGURATION_FOLDER_NAME = "configuration/";
    private static final String[] PRIOTIZED_PATHS = new String[]{System.getProperty("org.eclipse.smila.utils.config.root"), System.getenv("org.eclipse.smila.utils.config.root"), String.valueOf(Platform.getInstallLocation().getURL().getFile()) + "configuration/"};
    private static final File CONFIGURATION_FOLDER = ConfigUtils.determineFolder();

    private ConfigUtils() {
    }

    private static File determineFolder() {
        Log log = LogFactory.getLog(ConfigUtils.class);
        File file = null;
        String[] stringArray = PRIOTIZED_PATHS;
        int n = PRIOTIZED_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (StringUtils.isNotBlank((String)path)) {
                file = new File(path);
                break;
            }
            ++n2;
        }
        if (file != null) {
            if (file.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("CONFIGURATION_FOLDER = " + file.getPath()));
                } else {
                    System.out.println("CONFIGURATION_FOLDER = " + file.getPath());
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("CONFIGURATION_FOLDER ( " + file.getPath() + " ) is not found"));
                } else {
                    System.out.println("CONFIGURATION_FOLDER ( " + file.getPath() + " ) is not found");
                }
                file = null;
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"No CONFIGURATION_FOLDER is found");
        } else {
            System.out.println("No CONFIGURATION_FOLDER is found");
        }
        return file;
    }

    public static InputStream getConfigStream(String bundleName, String configPath, String defaultConfigPath) {
        File file;
        if (ConfigUtils.getConfigurationFolder() != null && (file = new File(ConfigUtils.getConfigurationFolder(), bundleName)).exists() && (file = configPath.contains(":") ? new File(configPath) : new File(file, configPath)).exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (defaultConfigPath == null) {
            throw new ConfigurationLoadException(String.format("Configuration resource %s is for the bundle %s not found", configPath, bundleName));
        }
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ConfigurationLoadException("Unable to fing bundle " + bundleName);
        }
        URL url = bundle.getEntry(defaultConfigPath);
        if (url == null) {
            throw new ConfigurationLoadException(String.format("Unable to find configuration resource %s in the bundle %s", defaultConfigPath, bundleName));
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new ConfigurationLoadException(e);
        }
    }

    public static File getConfigFolder(String bundleName, String configPath) {
        File file;
        if (CONFIGURATION_FOLDER != null && (file = new File(CONFIGURATION_FOLDER, bundleName)).exists() && (file = new File(file, configPath)).exists()) {
            return file;
        }
        return null;
    }

    public static InputStream getConfigStream(String bundleName, String configPath) {
        return ConfigUtils.getConfigStream(bundleName, configPath, configPath);
    }

    public static List<String> getConfigEntries(String bundleName, String configPath) {
        File file;
        if (ConfigUtils.getConfigurationFolder() != null && (file = new File(ConfigUtils.getConfigurationFolder(), bundleName)).exists() && (file = new File(file, configPath)).exists()) {
            String[] files = file.list();
            return Arrays.asList(files);
        }
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ConfigurationLoadException("Unable to fing bundle " + bundleName);
        }
        try {
            ArrayList<String> entries = new ArrayList<String>();
            Enumeration paths = bundle.getEntryPaths(configPath);
            if (entries != null) {
                while (paths.hasMoreElements()) {
                    entries.add((String)paths.nextElement());
                }
            }
            return entries;
        }
        catch (Exception exception) {
            throw new ConfigurationLoadException(String.format("Unable to find configuration resource %s in the bundle %s", configPath, bundleName));
        }
    }

    public static File getConfigurationFolder() {
        return CONFIGURATION_FOLDER;
    }
}

