/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.xml;

import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

public final class SchemaUtils {
    private SchemaUtils() {
    }

    public static Schema loadSchema(String bundleId, String schemaLocation) throws SAXException {
        Bundle bundle = Platform.getBundle((String)bundleId);
        return SchemaUtils.loadSchema(bundle, schemaLocation);
    }

    public static Schema loadSchemaRuntimeEx(String bundleId, String schemaLocation) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        return SchemaUtils.loadSchemaRuntimeEx(bundle, schemaLocation);
    }

    public static Schema loadSchema(Bundle bundle, String resourcePath) throws SAXException {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SchemaUtils.class.getClassLoader());
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(bundle.getEntry(resourcePath));
        Thread.currentThread().setContextClassLoader(oldCL);
        return schema;
    }

    public static Schema loadSchemaRuntimeEx(Bundle bundle, String resourcePath) {
        Log log = LogFactory.getLog(SchemaUtils.class);
        try {
            return SchemaUtils.loadSchema(bundle, resourcePath);
        }
        catch (Throwable e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new RuntimeException(e);
        }
    }
}

