/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.RecordFactory;

public final class DatamodelCopyUtils {
    private DatamodelCopyUtils() {
    }

    public static MObject cloneMObject(MObject source, RecordFactory factory) {
        if (source == null) {
            return null;
        }
        MObject destination = factory.createMetadataObject();
        destination.setSemanticType(source.getSemanticType());
        DatamodelCopyUtils.copyAnnotations((Annotatable)source, (Annotatable)destination, factory);
        DatamodelCopyUtils.copyAttributes(source, destination, factory);
        return destination;
    }

    public static void copyAttributes(MObject source, MObject destination, RecordFactory factory) {
        Iterator attributeNameIterator = source.getAttributeNames();
        while (attributeNameIterator.hasNext()) {
            String name = (String)attributeNameIterator.next();
            Attribute sourceAttribute = source.getAttribute(name);
            Attribute attribute = DatamodelCopyUtils.cloneAttribute(sourceAttribute, factory);
            destination.setAttribute(name, attribute);
        }
    }

    public static void copyAnnotations(Annotatable source, Annotatable destination, RecordFactory factory) {
        Iterator annotationNameIterator = source.getAnnotationNames();
        while (annotationNameIterator.hasNext()) {
            String annotationName = (String)annotationNameIterator.next();
            Collection sourceAnnotations = source.getAnnotations(annotationName);
            for (Annotation sourceAnnotation : sourceAnnotations) {
                Annotation annotation = DatamodelCopyUtils.cloneAnnotation(sourceAnnotation, factory);
                destination.addAnnotation(annotationName, annotation);
            }
        }
    }

    public static void copyLiterals(Attribute source, Attribute destination, RecordFactory factory) {
        if (source == null || destination == null) {
            throw new IllegalArgumentException("Source and destination cannot be null!");
        }
        destination.removeLiterals();
        ArrayList<Literal> destinationLiterals = null;
        if (source.hasLiterals()) {
            destinationLiterals = new ArrayList<Literal>();
            for (Literal literal : source.getLiterals()) {
                destinationLiterals.add(DatamodelCopyUtils.cloneLiteral(literal, factory));
            }
        }
        if (destinationLiterals != null) {
            destination.setLiterals(destinationLiterals);
        }
    }

    public static Annotation cloneAnnotation(Annotation source, RecordFactory factory) {
        if (source == null) {
            throw new IllegalArgumentException("annotation source cannot be null!");
        }
        if (factory == null) {
            throw new IllegalArgumentException("record factory cannot be null!");
        }
        Annotation destination = factory.createAnnotation();
        if (source.hasNamedValues()) {
            Iterator namesIterator = source.getValueNames();
            while (namesIterator.hasNext()) {
                String name = (String)namesIterator.next();
                String value = source.getNamedValue(name);
                destination.setNamedValue(name, value);
            }
        }
        if (source.hasAnonValues()) {
            for (String anonymousValue : source.getAnonValues()) {
                destination.addAnonValue(anonymousValue);
            }
        }
        DatamodelCopyUtils.copyAnnotations((Annotatable)source, (Annotatable)destination, factory);
        return destination;
    }

    public static Attribute cloneAttribute(Attribute source, RecordFactory factory) {
        return DatamodelCopyUtils.cloneAttribute(source, factory, true);
    }

    public static Attribute cloneAttribute(Attribute source, RecordFactory factory, boolean doCopyAnnotation) {
        if (source == null) {
            return null;
        }
        Attribute destination = factory.createAttribute();
        destination.setName(source.getName());
        if (doCopyAnnotation) {
            DatamodelCopyUtils.copyAnnotations((Annotatable)source, (Annotatable)destination, factory);
        }
        DatamodelCopyUtils.copyLiterals(source, destination, factory);
        List sourceMObjects = source.getObjects();
        destination.removeObjects();
        if (sourceMObjects != null && !sourceMObjects.isEmpty()) {
            ArrayList<MObject> destinationMObjects = new ArrayList<MObject>();
            for (MObject object : sourceMObjects) {
                destinationMObjects.add(DatamodelCopyUtils.cloneMObject(object, factory));
            }
            destination.setObjects(destinationMObjects);
        }
        return destination;
    }

    public static Literal cloneLiteral(Literal source, RecordFactory factory) {
        if (source == null) {
            return null;
        }
        Literal destination = factory.createLiteral();
        destination.setSemanticType(source.getSemanticType());
        switch (source.getDataType()) {
            case BOOL: {
                destination.setBoolValue(source.getBoolValue());
                break;
            }
            case DATE: {
                destination.setDateValue(source.getDateValue());
                break;
            }
            case DATETIME: {
                destination.setDateTimeValue(source.getDateTimeValue());
                break;
            }
            case TIME: {
                destination.setTimeValue(source.getTimeValue());
                break;
            }
            case FP: {
                destination.setFpValue(source.getFpValue());
                break;
            }
            case STRING: {
                destination.setStringValue(source.getStringValue());
                break;
            }
            case INT: {
                destination.setIntValue(source.getIntValue());
                break;
            }
            default: {
                throw new RuntimeException("There is no copy procedure described for the type " + source.getDataType());
            }
        }
        DatamodelCopyUtils.copyAnnotations((Annotatable)source, (Annotatable)destination, factory);
        return destination;
    }
}

