/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.tools;

import java.util.List;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.InvalidTypeException;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.datamodel.tools.NameValuePair;

public final class MObjectHelper {
    private MObjectHelper() {
    }

    public static void addSimpleLiteralAttribute(RecordFactory factory, MObject mObject, String attributeName, Object attributeValue) throws InvalidTypeException {
        Attribute attribute = factory.createAttribute();
        attribute.setName(attributeName);
        Literal literal = factory.createLiteral();
        literal.setValue(attributeValue);
        attribute.addLiteral(literal);
        mObject.setAttribute(attributeName, attribute);
    }

    public static void addLiteralArrayAttribute(RecordFactory factory, MObject mObject, String attributeName, Object[] values) throws InvalidTypeException {
        Attribute attribute = factory.createAttribute();
        attribute.setName(attributeName);
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            Literal literal = factory.createLiteral();
            literal.setValue(value);
            attribute.addLiteral(literal);
            ++n2;
        }
        mObject.setAttribute(attributeName, attribute);
    }

    public static void addNameValuePairsAttribute(RecordFactory factory, MObject mObject, String attributeName, NameValuePair[] nameValuePairs) throws InvalidTypeException {
        Attribute attribute = factory.createAttribute();
        attribute.setName(attributeName);
        MObject attributeMObject = factory.createMetadataObject();
        NameValuePair[] nameValuePairArray = nameValuePairs;
        int n = nameValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            NameValuePair nameValuePair = nameValuePairArray[n2];
            Attribute valueAttribute = factory.createAttribute();
            valueAttribute.setName(nameValuePair.getName());
            Literal literal = factory.createLiteral();
            literal.setValue((Object)nameValuePair.getValue());
            valueAttribute.addLiteral(literal);
            attributeMObject.setAttribute(nameValuePair.getName(), valueAttribute);
            ++n2;
        }
        attribute.setObject(attributeMObject);
        mObject.setAttribute(attributeName, attribute);
    }

    public static String glueLiterals(Attribute recordAttribute) {
        List values;
        StringBuilder sb = new StringBuilder();
        if (recordAttribute != null && !(values = recordAttribute.getLiterals()).isEmpty()) {
            boolean notFirst = false;
            for (Literal literal : values) {
                if (notFirst) {
                    sb.append(',');
                } else {
                    notFirst = true;
                }
                sb.append(literal.getStringValue());
            }
        }
        return sb.toString();
    }
}

